/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.util.DocTreeFactory;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.parser.ReferenceParser;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.StringUtils;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class DocTreeMaker
implements DocTreeFactory {
    protected static final Context.Key<DocTreeMaker> treeMakerKey = new Context.Key();
    final Set<String> sentenceBreakTags;
    public int pos = -1;
    private final JavacTrees trees;
    private final ReferenceParser referenceParser;

    public static DocTreeMaker instance(Context context) {
        DocTreeMaker instance = context.get(treeMakerKey);
        if (instance == null) {
            instance = new DocTreeMaker(context);
        }
        return instance;
    }

    protected DocTreeMaker(Context context) {
        context.put(treeMakerKey, this);
        this.pos = -1;
        this.trees = JavacTrees.instance(context);
        this.referenceParser = new ReferenceParser(ParserFactory.instance(context));
        this.sentenceBreakTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("H1", "H2", "H3", "H4", "H5", "H6", "PRE", "P")));
    }

    @Override
    public DocTreeMaker at(int pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public DCTree.DCAttribute newAttributeTree(Name name, AttributeTree.ValueKind vkind, java.util.List<? extends DocTree> value) {
        DCTree.DCAttribute tree = new DCTree.DCAttribute(name, vkind, this.cast(value));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCAuthor newAuthorTree(java.util.List<? extends DocTree> name) {
        DCTree.DCAuthor tree = new DCTree.DCAuthor(this.cast(name));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newCodeTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.CODE, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCComment newCommentTree(String text) {
        DCTree.DCComment tree = new DCTree.DCComment(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDeprecated newDeprecatedTree(java.util.List<? extends DocTree> text) {
        DCTree.DCDeprecated tree = new DCTree.DCDeprecated(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags) {
        return this.newDocCommentTree((java.util.List)fullBody, (java.util.List)tags, Collections.emptyList(), Collections.emptyList());
    }

    public DCTree.DCDocComment newDocCommentTree(Tokens.Comment comment, java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags, java.util.List<? extends DocTree> preamble, java.util.List<? extends DocTree> postamble) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(fullBody);
        DCTree.DCDocComment tree = new DCTree.DCDocComment(comment, this.cast(fullBody), (java.util.List)pair.fst, (java.util.List)pair.snd, this.cast(tags), this.cast(preamble), this.cast(postamble));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocComment newDocCommentTree(java.util.List<? extends DocTree> fullBody, java.util.List<? extends DocTree> tags, java.util.List<? extends DocTree> preamble, java.util.List<? extends DocTree> postamble) {
        ListBuffer<DCTree> lb = new ListBuffer<DCTree>();
        lb.addAll((Collection<DCTree>)this.cast(fullBody));
        List<DCTree> fBody = lb.toList();
        Tokens.Comment c = new Tokens.Comment(){

            @Override
            public String getText() {
                return null;
            }

            @Override
            public int getSourcePos(int index) {
                return -1;
            }

            @Override
            public Tokens.Comment.CommentStyle getStyle() {
                return Tokens.Comment.CommentStyle.JAVADOC;
            }

            @Override
            public boolean isDeprecated() {
                return false;
            }
        };
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(fullBody);
        DCTree.DCDocComment tree = new DCTree.DCDocComment(c, fBody, (java.util.List)pair.fst, (java.util.List)pair.snd, this.cast(tags), this.cast(preamble), this.cast(postamble));
        return tree;
    }

    @Override
    public DCTree.DCDocRoot newDocRootTree() {
        DCTree.DCDocRoot tree = new DCTree.DCDocRoot();
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCDocType newDocTypeTree(String text) {
        DCTree.DCDocType tree = new DCTree.DCDocType(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEndElement newEndElementTree(Name name) {
        DCTree.DCEndElement tree = new DCTree.DCEndElement(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCEntity newEntityTree(Name name) {
        DCTree.DCEntity tree = new DCTree.DCEntity(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCErroneous newErroneousTree(String text, Diagnostic<JavaFileObject> diag) {
        DCTree.DCErroneous tree = new DCTree.DCErroneous(text, (JCDiagnostic)diag);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newExceptionTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.EXCEPTION, (DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCHidden newHiddenTree(java.util.List<? extends DocTree> text) {
        DCTree.DCHidden tree = new DCTree.DCHidden(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIdentifier newIdentifierTree(Name name) {
        DCTree.DCIdentifier tree = new DCTree.DCIdentifier(name);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCIndex newIndexTree(DocTree term, java.util.List<? extends DocTree> description) {
        DCTree.DCIndex tree = new DCTree.DCIndex((DCTree)term, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCInheritDoc newInheritDocTree() {
        DCTree.DCInheritDoc tree = new DCTree.DCInheritDoc();
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkTree(ReferenceTree ref, java.util.List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK, (DCTree.DCReference)ref, this.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLink newLinkPlainTree(ReferenceTree ref, java.util.List<? extends DocTree> label) {
        DCTree.DCLink tree = new DCTree.DCLink(DocTree.Kind.LINK_PLAIN, (DCTree.DCReference)ref, this.cast(label));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCLiteral newLiteralTree(TextTree text) {
        DCTree.DCLiteral tree = new DCTree.DCLiteral(DocTree.Kind.LITERAL, (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCParam newParamTree(boolean isTypeParameter, IdentifierTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCParam tree = new DCTree.DCParam(isTypeParameter, (DCTree.DCIdentifier)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCProvides newProvidesTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCProvides tree = new DCTree.DCProvides((DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReference newReferenceTree(String signature) {
        try {
            ReferenceParser.Reference ref = this.referenceParser.parse(signature);
            DCTree.DCReference tree = new DCTree.DCReference(signature, ref.moduleName, ref.qualExpr, ref.member, ref.paramTypes);
            tree.pos = this.pos;
            return tree;
        }
        catch (ReferenceParser.ParseException e) {
            throw new IllegalArgumentException("invalid signature", e);
        }
    }

    public DCTree.DCReference newReferenceTree(String signature, JCTree.JCExpression moduleName, JCTree qualExpr, Name member, java.util.List<JCTree> paramTypes) {
        DCTree.DCReference tree = new DCTree.DCReference(signature, moduleName, qualExpr, member, paramTypes);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCReturn newReturnTree(java.util.List<? extends DocTree> description) {
        return this.newReturnTree(false, (java.util.List)description);
    }

    @Override
    public DCTree.DCReturn newReturnTree(boolean isInline, java.util.List<? extends DocTree> description) {
        DCTree.DCReturn tree = new DCTree.DCReturn(isInline, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSee newSeeTree(java.util.List<? extends DocTree> reference) {
        DCTree.DCSee tree = new DCTree.DCSee(this.cast(reference));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerial newSerialTree(java.util.List<? extends DocTree> description) {
        DCTree.DCSerial tree = new DCTree.DCSerial(this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialData newSerialDataTree(java.util.List<? extends DocTree> description) {
        DCTree.DCSerialData tree = new DCTree.DCSerialData(this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSerialField newSerialFieldTree(IdentifierTree name, ReferenceTree type, java.util.List<? extends DocTree> description) {
        DCTree.DCSerialField tree = new DCTree.DCSerialField((DCTree.DCIdentifier)name, (DCTree.DCReference)type, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSince newSinceTree(java.util.List<? extends DocTree> text) {
        DCTree.DCSince tree = new DCTree.DCSince(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSnippet newSnippetTree(java.util.List<? extends DocTree> attributes, TextTree text) {
        DCTree.DCSnippet tree = new DCTree.DCSnippet(this.cast(attributes), (DCTree.DCText)text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCStartElement newStartElementTree(Name name, java.util.List<? extends DocTree> attrs, boolean selfClosing) {
        DCTree.DCStartElement tree = new DCTree.DCStartElement(name, this.cast(attrs), selfClosing);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSummary newSummaryTree(java.util.List<? extends DocTree> text) {
        DCTree.DCSummary tree = new DCTree.DCSummary(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCSystemProperty newSystemPropertyTree(Name propertyName) {
        DCTree.DCSystemProperty tree = new DCTree.DCSystemProperty(propertyName);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCText newTextTree(String text) {
        DCTree.DCText tree = new DCTree.DCText(text);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCThrows newThrowsTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCThrows tree = new DCTree.DCThrows(DocTree.Kind.THROWS, (DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownBlockTag newUnknownBlockTagTree(Name name, java.util.List<? extends DocTree> content) {
        DCTree.DCUnknownBlockTag tree = new DCTree.DCUnknownBlockTag(name, this.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUnknownInlineTag newUnknownInlineTagTree(Name name, java.util.List<? extends DocTree> content) {
        DCTree.DCUnknownInlineTag tree = new DCTree.DCUnknownInlineTag(name, this.cast(content));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCUses newUsesTree(ReferenceTree name, java.util.List<? extends DocTree> description) {
        DCTree.DCUses tree = new DCTree.DCUses((DCTree.DCReference)name, this.cast(description));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCValue newValueTree(ReferenceTree ref) {
        DCTree.DCValue tree = new DCTree.DCValue((DCTree.DCReference)ref);
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public DCTree.DCVersion newVersionTree(java.util.List<? extends DocTree> text) {
        DCTree.DCVersion tree = new DCTree.DCVersion(this.cast(text));
        tree.pos = this.pos;
        return tree;
    }

    @Override
    public java.util.List<DocTree> getFirstSentence(java.util.List<? extends DocTree> list) {
        Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = this.splitBody(list);
        return new ArrayList<DocTree>((Collection)pair.fst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<java.util.List<DCTree>, java.util.List<DCTree>> splitBody(Collection<? extends DocTree> list) {
        int savedpos = this.pos;
        try {
            ListBuffer<DCTree> body = new ListBuffer<DCTree>();
            ListBuffer<DCTree> fs = new ListBuffer<DCTree>();
            if (list.isEmpty()) {
                Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(fs.toList(), body.toList());
                return pair;
            }
            boolean foundFirstSentence = false;
            ArrayList<? extends DocTree> alist = new ArrayList<DocTree>(list);
            ListIterator<? extends DocTree> itr = alist.listIterator();
            block8: while (itr.hasNext()) {
                boolean isFirst = !itr.hasPrevious();
                DocTree dt = itr.next();
                int spos = ((DCTree)dt).pos;
                if (foundFirstSentence) {
                    body.add((DCTree)dt);
                    continue;
                }
                switch (dt.getKind()) {
                    case RETURN: 
                    case SUMMARY: {
                        foundFirstSentence = true;
                        break;
                    }
                    case TEXT: {
                        boolean sbrk;
                        DCTree.DCText tt = (DCTree.DCText)dt;
                        String s = tt.getBody();
                        DocTree peekedNext = itr.hasNext() ? alist.get(itr.nextIndex()) : null;
                        int sbreak = this.getSentenceBreak(s, peekedNext);
                        if (sbreak > 0) {
                            s = s.substring(0, sbreak).replaceAll("\\p{javaWhitespace}+$", "");
                            DCTree.DCText text = this.at(spos).newTextTree(s);
                            fs.add(text);
                            foundFirstSentence = true;
                            int nwPos = this.skipWhiteSpace(tt.getBody(), sbreak);
                            if (nwPos <= 0) continue block8;
                            DCTree.DCText text2 = this.at(spos + nwPos).newTextTree(tt.getBody().substring(nwPos));
                            body.add(text2);
                            continue block8;
                        }
                        if (!itr.hasNext() || !(sbrk = this.isSentenceBreak(peekedNext = alist.get(itr.nextIndex()), false))) break;
                        DocTree next = itr.next();
                        s = s.replaceAll("\\p{javaWhitespace}+$", "");
                        DCTree.DCText text = this.at(spos).newTextTree(s);
                        fs.add(text);
                        body.add((DCTree)next);
                        foundFirstSentence = true;
                        continue block8;
                    }
                    default: {
                        if (!this.isSentenceBreak(dt, isFirst)) break;
                        body.add((DCTree)dt);
                        foundFirstSentence = true;
                        continue block8;
                    }
                }
                fs.add((DCTree)dt);
            }
            Pair<java.util.List<DCTree>, java.util.List<DCTree>> pair = new Pair<java.util.List<DCTree>, java.util.List<DCTree>>(fs.toList(), body.toList());
            return pair;
        }
        finally {
            this.pos = savedpos;
        }
    }

    private boolean isTextTree(DocTree tree) {
        return tree.getKind() == DocTree.Kind.TEXT;
    }

    private int defaultSentenceBreak(String s) {
        int period = -1;
        block4: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '.': {
                    period = i;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (period < 0) continue block4;
                    return i;
                }
                default: {
                    period = -1;
                }
            }
        }
        return -1;
    }

    private int getSentenceBreak(String s, DocTree dt) {
        BreakIterator breakIterator = this.trees.getBreakIterator();
        if (breakIterator == null) {
            return this.defaultSentenceBreak(s);
        }
        breakIterator.setText(s);
        int sbrk = breakIterator.next();
        if (dt == null) {
            return sbrk;
        }
        if (sbrk < s.length() - 1) {
            return sbrk;
        }
        if (this.isTextTree(dt)) {
            TextTree ttnext = (TextTree)dt;
            String combined = s + ttnext.getBody();
            breakIterator.setText(combined);
            int sbrk2 = breakIterator.next();
            if (sbrk < sbrk2) {
                return sbrk;
            }
        }
        if (this.isSentenceBreak(dt, false)) {
            return sbrk;
        }
        String combined = s + "Dummy Sentence.";
        breakIterator.setText(combined);
        int sbrk2 = breakIterator.next();
        if (sbrk2 <= sbrk) {
            return sbrk2;
        }
        return -1;
    }

    private boolean isSentenceBreak(Name tagName) {
        return this.sentenceBreakTags.contains(StringUtils.toUpperCase(tagName.toString()));
    }

    private boolean isSentenceBreak(DocTree dt, boolean isFirstDocTree) {
        switch (dt.getKind()) {
            case START_ELEMENT: {
                StartElementTree set = (StartElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(set.getName());
            }
            case END_ELEMENT: {
                EndElementTree eet = (EndElementTree)dt;
                return !isFirstDocTree && ((DCTree)dt).pos > 1 && this.isSentenceBreak(eet.getName());
            }
        }
        return false;
    }

    private int skipWhiteSpace(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    private java.util.List<DCTree> cast(java.util.List<? extends DocTree> list) {
        return list;
    }
}

