/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.wizard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.api.util.ValidationUtilities;
import org.netbeans.modules.web.clientproject.ui.wizard.Bundle;
import org.netbeans.modules.web.clientproject.ui.wizard.ClientSideProjectDetector;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ExistingClientSideProject
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    boolean fireChanges = true;
    String lastSiteRoot = "";
    volatile String testDir = null;
    private JButton projectDirectoryBrowseButton;
    private JLabel projectDirectoryLabel;
    private JTextField projectDirectoryTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JButton siteRootBrowseButton;
    private JLabel siteRootLabel;
    private JTextField siteRootTextField;
    private JButton sourcesBrowseButton;
    private JLabel sourcesLabel;
    private JTextField sourcesTextField;

    public ExistingClientSideProject() {
        this.initComponents();
        this.init();
    }

    private void init() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.siteRootTextField.getDocument().addDocumentListener(new DefaultDocumentListener(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                ExistingClientSideProject.this.fireChanges = false;
                ExistingClientSideProject.this.updateProjectName();
                ExistingClientSideProject.this.updateProjectDirectory();
                ExistingClientSideProject.this.lastSiteRoot = ExistingClientSideProject.this.getSiteRoot();
                ExistingClientSideProject.this.detectClientSideProject(ExistingClientSideProject.this.lastSiteRoot);
                ExistingClientSideProject.this.fireChanges = true;
            }
        }));
        this.sourcesTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.projectNameTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.projectDirectoryTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public String getSiteRoot() {
        return this.siteRootTextField.getText().trim();
    }

    public String getSources() {
        return this.sourcesTextField.getText().trim();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectDirectory() {
        return this.projectDirectoryTextField.getText().trim();
    }

    public String getTestDir() {
        return this.testDir;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getErrorMessage() {
        String siteRoot = this.getSiteRoot();
        String sources = this.getSources();
        if (!StringUtilities.hasText((String)siteRoot) && !StringUtilities.hasText((String)sources)) {
            return Bundle.ExistingClientSideProject_error_noFolder();
        }
        String error = this.validateFolder(siteRoot, Bundle.ExistingClientSideProject_siteRoot_label());
        if (error != null) {
            return error;
        }
        error = this.validateFolder(sources, Bundle.ExistingClientSideProject_sources_label());
        if (error != null) {
            return error;
        }
        error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectDirectory();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateFolder(String folder, String folderName) {
        if (!StringUtilities.hasText((String)folder)) {
            return null;
        }
        File folderDir = FileUtil.normalizeFile((File)new File(folder).getAbsoluteFile());
        if (!folderDir.isDirectory()) {
            return Bundle.ExistingClientSideProject_error_folder_invalid(folderName);
        }
        if (ClientSideProjectUtilities.isProject(folderDir)) {
            return Bundle.ExistingClientSideProject_error_folder_nbproject(folderName);
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return Bundle.ExistingClientSideProject_error_name_empty();
        }
        return null;
    }

    private String validateProjectDirectory() {
        String projectDirectory = this.getProjectDirectory();
        if (projectDirectory.isEmpty()) {
            return Bundle.ExistingClientSideProject_error_projectDirectory_empty();
        }
        File projDir = FileUtil.normalizeFile((File)new File(projectDirectory).getAbsoluteFile());
        if (ClientSideProjectUtilities.isProject(projDir)) {
            return Bundle.ExistingClientSideProject_error_projectDirectory_alreadyProject();
        }
        if (!projDir.isDirectory()) {
            File existingParent;
            if (!ValidationUtilities.isValidFilename((File)projDir)) {
                return Bundle.ExistingClientSideProject_error_projectDirectory_invalid();
            }
            for (existingParent = projDir; existingParent != null && !existingParent.exists(); existingParent = existingParent.getParentFile()) {
            }
            if (existingParent == null || !existingParent.canWrite()) {
                return Bundle.ExistingClientSideProject_error_projectDirectory_notWritable();
            }
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void updateProjectName() {
        this.projectNameTextField.setText(new File(this.getSiteRoot()).getName());
    }

    void updateProjectDirectory() {
        assert (EventQueue.isDispatchThread());
        String projectDirectory = this.getProjectDirectory();
        if (!this.lastSiteRoot.isEmpty() && projectDirectory.equals(this.lastSiteRoot)) {
            return;
        }
        this.projectDirectoryTextField.setText(this.getSiteRoot());
    }

    void detectClientSideProject(String folder) {
        ClientSideProjectDetector detector = new ClientSideProjectDetector(new File(folder));
        if (detector.detected()) {
            this.projectNameTextField.setText(detector.getName());
            this.projectDirectoryTextField.setText(detector.getProjectDirPath());
            this.testDir = detector.getTestDirPath();
        } else {
            this.resetDetectedValues();
        }
    }

    void resetDetectedValues() {
        this.testDir = null;
    }

    private void initComponents() {
        this.siteRootLabel = new JLabel();
        this.siteRootTextField = new JTextField();
        this.siteRootBrowseButton = new JButton();
        this.sourcesLabel = new JLabel();
        this.sourcesTextField = new JTextField();
        this.sourcesBrowseButton = new JButton();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectDirectoryLabel = new JLabel();
        this.projectDirectoryTextField = new JTextField();
        this.projectDirectoryBrowseButton = new JButton();
        this.siteRootLabel.setLabelFor(this.siteRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.siteRootLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.siteRootLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.siteRootBrowseButton, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.siteRootBrowseButton.text"));
        this.siteRootBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingClientSideProject.this.siteRootBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.sourcesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sourcesBrowseButton, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.sourcesBrowseButton.text"));
        this.sourcesBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingClientSideProject.this.sourcesBrowseButtonActionPerformed(evt);
            }
        });
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectNameLabel.text"));
        this.projectDirectoryLabel.setLabelFor(this.projectDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectDirectoryLabel, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectDirectoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectDirectoryBrowseButton, (String)NbBundle.getMessage(ExistingClientSideProject.class, (String)"ExistingClientSideProject.projectDirectoryBrowseButton.text"));
        this.projectDirectoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingClientSideProject.this.projectDirectoryBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDirectoryLabel).addComponent(this.projectNameLabel).addComponent(this.siteRootLabel).addComponent(this.sourcesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sourcesTextField).addComponent(this.siteRootTextField, GroupLayout.Alignment.LEADING).addComponent(this.projectDirectoryTextField, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteRootBrowseButton, GroupLayout.Alignment.TRAILING).addComponent(this.projectDirectoryBrowseButton, GroupLayout.Alignment.TRAILING).addComponent(this.sourcesBrowseButton, GroupLayout.Alignment.TRAILING))))));
        layout.linkSize(0, this.projectDirectoryBrowseButton, this.siteRootBrowseButton, this.sourcesBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteRootTextField, -2, -1, -2).addComponent(this.siteRootBrowseButton).addComponent(this.siteRootLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourcesTextField, -2, -1, -2).addComponent(this.sourcesLabel).addComponent(this.sourcesBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDirectoryLabel).addComponent(this.projectDirectoryTextField, -2, -1, -2).addComponent(this.projectDirectoryBrowseButton))));
    }

    private void siteRootBrowseButtonActionPerformed(ActionEvent evt) {
        File folder = this.browseFile(".siteRoot", Bundle.ExistingClientSideProject_siteRoot_dialog_title(), this.getSiteRoot());
        if (folder != null) {
            this.siteRootTextField.setText(FileUtil.normalizeFile((File)folder).getAbsolutePath());
        }
    }

    private void projectDirectoryBrowseButtonActionPerformed(ActionEvent evt) {
        File projectDirectory = this.browseFile(".projectDirectory", Bundle.ExistingClientSideProject_projectDirectory_dialog_title(), this.getProjectDirectory());
        if (projectDirectory != null) {
            this.projectDirectoryTextField.setText(FileUtil.normalizeFile((File)projectDirectory).getAbsolutePath());
        }
    }

    private void sourcesBrowseButtonActionPerformed(ActionEvent evt) {
        File folder = this.browseFile(".sources", Bundle.ExistingClientSideProject_sources_dialog_title(), this.getSources());
        if (folder != null) {
            this.sourcesTextField.setText(FileUtil.normalizeFile((File)folder).getAbsolutePath());
        }
    }

    private File browseFile(String dirKey, String title, String currentDirectory) {
        File currDir;
        File workDir = null;
        if (currentDirectory != null && !currentDirectory.isEmpty() && (currDir = new File(currentDirectory)).isDirectory()) {
            workDir = currDir;
        }
        FileChooserBuilder builder = new FileChooserBuilder(ExistingClientSideProject.class.getName() + dirKey).setTitle(title).setDirectoriesOnly(true);
        if (workDir != null) {
            builder.setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true);
        }
        return builder.showOpenDialog();
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private final Runnable task;

        public DefaultDocumentListener() {
            this(null);
        }

        public DefaultDocumentListener(Runnable task) {
            this.task = task;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            assert (EventQueue.isDispatchThread());
            if (this.task != null) {
                this.task.run();
            }
            if (ExistingClientSideProject.this.fireChanges) {
                ExistingClientSideProject.this.fireChange();
            }
        }
    }
}

