/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.ui.JFXRunPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JFXApplicationMultiPropertyPanel
extends JPanel
implements TableModelListener {
    private JFXProjectProperties.PropertiesTableModel tableModel;
    private JFXProjectProperties.PropertyCellEditor cellEditor;
    private DialogDescriptor desc;
    private JButton buttonAdd;
    private JButton buttonDefault;
    private JButton buttonRemove;
    private JScrollPane jScrollPane1;
    private JLabel labelRemark;
    private JLabel labelTable;
    private JTable tableMultiProperties;

    public JFXApplicationMultiPropertyPanel(@NonNull JFXProjectProperties.PropertiesTableModel mdl) {
        this.tableModel = mdl;
        this.initComponents();
        this.cellEditor = new JFXProjectProperties.PropertyCellEditor();
        this.tableMultiProperties.setDefaultRenderer(Object.class, new JFXProjectProperties.PropertyCellRenderer());
        this.tableMultiProperties.setDefaultEditor(Object.class, this.cellEditor);
        this.tableMultiProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.updateRemoveButton();
        this.updateDefaultButtonLabel();
        this.updateDefaultButtonState();
        FontMetrics fm = this.tableMultiProperties.getFontMetrics(this.tableMultiProperties.getFont());
        this.tableMultiProperties.setRowHeight(fm.getHeight() + 5);
    }

    public void setTableTitle(String label) {
        if (label == null) {
            this.labelTable.setText("");
            this.labelTable.setVisible(false);
        } else {
            this.labelTable.setText(label);
        }
    }

    public void setRemark(String remark) {
        if (remark == null) {
            this.labelRemark.setText("");
            this.labelRemark.setVisible(false);
        } else {
            this.labelRemark.setText(remark);
        }
    }

    void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
        this.updateDialogButtons();
        this.updateAddButton();
    }

    void registerListeners() {
        this.tableModel.addTableModelListener(this);
        this.tableMultiProperties.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    JFXApplicationMultiPropertyPanel.this.updateRemoveButton();
                }
            }
        });
        this.cellEditor.registerCellEditorListener();
    }

    void unregisterListeners() {
        this.tableModel.removeTableModelListener(this);
        this.cellEditor.unregisterCellEditorListener();
    }

    private void initComponents() {
        this.labelTable = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tableMultiProperties = new JTable();
        this.buttonAdd = new JButton();
        this.buttonRemove = new JButton();
        this.labelRemark = new JLabel();
        this.buttonDefault = new JButton();
        this.setPreferredSize(new Dimension(400, 250));
        this.setLayout(new GridBagLayout());
        this.labelTable.setLabelFor(this.tableMultiProperties);
        Mnemonics.setLocalizedText((JLabel)this.labelTable, (String)NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"LBL_JFXApplicationParametersPanel.labelParams.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 5, 0);
        this.add((Component)this.labelTable, gridBagConstraints);
        this.labelTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AN_JFXApplicationParametersPanel.labelParams.text"));
        this.labelTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AD_JFXApplicationParametersPanel.labelParams.text"));
        this.tableMultiProperties.setModel(this.tableModel);
        this.jScrollPane1.setViewportView(this.tableMultiProperties);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonAdd, (String)NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"LBL_JFXApplicationParametersPanel.buttonAdd.text"));
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXApplicationMultiPropertyPanel.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        this.add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonAdd.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AN_JFXApplicationParametersPanel.buttonAdd.text"));
        this.buttonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AD_JFXApplicationParametersPanel.buttonAdd.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemove, (String)NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"LBL_JFXApplicationParametersPanel.buttonRemove.text"));
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXApplicationMultiPropertyPanel.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 10);
        this.add((Component)this.buttonRemove, gridBagConstraints);
        this.buttonRemove.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AN_JFXApplicationParametersPanel.buttonRemove.text"));
        this.buttonRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AD_JFXApplicationParametersPanel.buttonRemove.text"));
        this.labelRemark.setText(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"JFXApplicationMultiPropertyPanel.labelRemark.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.labelRemark, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDefault, (String)NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"JFXApplicationMultiPropertyPanel.buttonDefault.text"));
        this.buttonDefault.setEnabled(false);
        this.buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXApplicationMultiPropertyPanel.this.buttonDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        this.add((Component)this.buttonDefault, gridBagConstraints);
        this.buttonDefault.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AN_JFXApplicationParametersPanel.buttonDefault.text"));
        this.buttonDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXApplicationMultiPropertyPanel.class, (String)"AD_JFXApplicationParametersPanel.buttonDefault.text"));
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        this.tableModel.addRow();
        this.tableMultiProperties.requestFocusInWindow();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        int selIndex = this.tableMultiProperties.getSelectedRow();
        if (selIndex != -1) {
            this.tableModel.removeRow(selIndex);
            this.tableMultiProperties.requestFocusInWindow();
        }
    }

    private void buttonDefaultActionPerformed(ActionEvent evt) {
        this.tableModel.reset();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateDialogButtons();
        this.updateAddButton();
        this.updateDefaultButtonState();
    }

    private void updateDialogButtons() {
        if (this.tableModel.isValid()) {
            this.desc.setValid(true);
        } else {
            this.desc.setValid(false);
        }
    }

    private void updateRemoveButton() {
        int selIndex = this.tableMultiProperties.getSelectedRow();
        this.buttonRemove.setEnabled(selIndex != -1);
    }

    private void updateAddButton() {
        if (this.tableModel.isLastRowEmpty()) {
            this.buttonAdd.setEnabled(false);
        } else {
            this.buttonAdd.setEnabled(true);
        }
    }

    private void updateDefaultButtonState() {
        this.buttonDefault.setEnabled(this.tableModel.isResettable());
    }

    private void updateDefaultButtonLabel() {
        if (this.tableModel.hasDefaultProperties()) {
            this.buttonDefault.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXApplicationMultiPropertyPanel.buttonDefault.text.default"));
            this.buttonDefault.setMnemonic(68);
        } else {
            this.buttonDefault.setText(NbBundle.getMessage(JFXRunPanel.class, (String)"JFXApplicationMultiPropertyPanel.buttonDefault.text.clean"));
            this.buttonDefault.setMnemonic(67);
        }
    }
}

