/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.io.File;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.system.resolver.StringResolver;

public class NameResolver
implements StringResolver {
    public static final String ERROR_CANNOT_GET_DEFAULT_APPS_LOCATION_KEY = "NR.error.cannot.get.default.apps.location";

    @Override
    public String resolve(String string, ClassLoader cl) {
        String parsed = string;
        LogManager.log("NameResolver - to parse " + parsed);
        if (parsed.contains("$N{install}")) {
            try {
                parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{install\\}", StringUtils.escapeRegExp(SystemUtils.getDefaultApplicationsLocation().getAbsolutePath()));
                LogManager.log("      --- parsed to " + parsed);
            }
            catch (NativeException e) {
                ErrorManager.notifyError(ResourceUtils.getString(SystemUtils.class, ERROR_CANNOT_GET_DEFAULT_APPS_LOCATION_KEY), e);
            }
        }
        if (SystemUtils.isWindows()) {
            String path;
            File defaultApplicationsLocation = null;
            if (parsed.contains("$N{install_x86}")) {
                try {
                    path = SystemUtils.getEnvironmentVariable("ProgramFiles(x86)");
                    LogManager.log("      --- Path " + path);
                    defaultApplicationsLocation = path != null ? new File(path).getAbsoluteFile() : SystemUtils.getDefaultApplicationsLocation();
                    parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{install_x86\\}", StringUtils.escapeRegExp(defaultApplicationsLocation.getAbsolutePath()));
                    LogManager.log("      --- parsed to " + parsed);
                }
                catch (NativeException e) {
                    ErrorManager.notifyError(ResourceUtils.getString(SystemUtils.class, ERROR_CANNOT_GET_DEFAULT_APPS_LOCATION_KEY), e);
                }
            }
            if (parsed.contains("$N{install_x64}")) {
                try {
                    path = SystemUtils.getEnvironmentVariable("ProgramW6432");
                    LogManager.log("      --- Path " + path);
                    defaultApplicationsLocation = path != null ? new File(path).getAbsoluteFile() : SystemUtils.getDefaultApplicationsLocation();
                    parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{install_x64\\}", StringUtils.escapeRegExp(defaultApplicationsLocation.getAbsolutePath()));
                    LogManager.log("      --- parsed to " + parsed);
                }
                catch (NativeException e) {
                    ErrorManager.notifyError(ResourceUtils.getString(SystemUtils.class, ERROR_CANNOT_GET_DEFAULT_APPS_LOCATION_KEY), e);
                }
            }
        }
        if (parsed.contains("$N{home}")) {
            parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{home\\}", StringUtils.escapeRegExp(SystemUtils.getUserHomeDirectory().getAbsolutePath()));
        }
        if (parsed.contains("$N{temp}")) {
            parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{temp\\}", StringUtils.escapeRegExp(SystemUtils.getTempDirectory().getAbsolutePath()));
        }
        if (parsed.contains("$N{current}")) {
            parsed = parsed.replaceAll("(?<!\\\\)\\$N\\{current\\}", StringUtils.escapeRegExp(SystemUtils.getCurrentDirectory().getAbsolutePath()));
        }
        return parsed;
    }
}

