/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util;

import com.oracle.bmc.InternalSdk;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalSdk
public class JavaRuntimeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaRuntimeUtils.class);
    private static final String VNUM = "([1-9][0-9]*)(((\\.0)*\\.[1-9][0-9]*)*)*";
    private static final String PRE = "[a-zA-Z0-9]+";
    private static final String JEP223 = String.format("^%s(-%s)?$", "([1-9][0-9]*)(((\\.0)*\\.[1-9][0-9]*)*)*", "[a-zA-Z0-9]+");
    private static final Pattern JEP223_PATTERN = Pattern.compile(JEP223);
    private static final JreVersion VERSION = JavaRuntimeUtils.parse();

    static JreVersion parse() {
        JreVersion version = JreVersion.Unknown;
        String versionString = System.getProperty("java.version");
        if (versionString.startsWith("1.")) {
            String[] versionParts = versionString.split("\\.");
            int featureVersion = Integer.parseInt(versionParts[1]);
            if (featureVersion < 7) {
                version = JreVersion.Unsupported;
            } else if (featureVersion == 7) {
                version = JreVersion.Java_7;
            } else if (featureVersion == 8) {
                version = JreVersion.Java_8;
            } else if (featureVersion == 9) {
                version = JreVersion.Java_9;
            }
        } else {
            Matcher matcher = JEP223_PATTERN.matcher(versionString);
            if (matcher.matches()) {
                int majorVersion = Integer.parseInt(matcher.group(1));
                if (majorVersion == 9) {
                    version = JreVersion.Java_9;
                } else if (majorVersion == 11) {
                    version = JreVersion.Java_11;
                }
            }
        }
        return version;
    }

    public static JreVersion getRuntimeVersion() {
        return VERSION;
    }

    static {
        LOG.info("Determined JRE version as {}", (Object)VERSION);
    }

    public static enum JreVersion {
        Unsupported,
        Java_7,
        Java_8,
        Java_9,
        Java_11,
        Unknown;

    }
}

