/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.datatype;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.schema.model.Whitespace;

public abstract class NumberBase
extends Datatype {
    public static final Number UNBOUNDED_VALUE = Double.MAX_VALUE;
    public static final String UNBOUNDED_STRING = "unbounded";
    static List<Datatype.Facet> applicableFacets;
    private Datatype.Kind kind;
    private boolean hasFacets;
    private boolean isList;
    private List<Integer> totalDigits;
    private List<Integer> fractionDigits;
    private List<String> patterns;
    private List<Whitespace.Treatment> whitespaces;
    private List<Number> enumerations;
    private List<Number> maxInclusives;
    private List<Number> maxExclusives;
    private List<Number> minInclusives;
    private List<Number> minExclusives;

    public NumberBase(Datatype.Kind kind) {
        this.kind = kind;
    }

    @Override
    public Datatype.Kind getKind() {
        return this.kind;
    }

    @Override
    public synchronized List<Datatype.Facet> getApplicableFacets() {
        if (applicableFacets == null) {
            ArrayList<Datatype.Facet> facets = new ArrayList<Datatype.Facet>();
            facets.add(Datatype.Facet.TOTATDIGITS);
            facets.add(Datatype.Facet.FRACTIONDIGITS);
            facets.add(Datatype.Facet.PATTERN);
            facets.add(Datatype.Facet.WHITESPACE);
            facets.add(Datatype.Facet.ENUMERATION);
            facets.add(Datatype.Facet.MAXINCLUSIVE);
            facets.add(Datatype.Facet.MAXEXCLUSIVE);
            facets.add(Datatype.Facet.MININCLUSIVE);
            facets.add(Datatype.Facet.MINEXCLUSIVE);
            applicableFacets = Collections.unmodifiableList(facets);
        }
        return applicableFacets;
    }

    @Override
    public boolean hasFacets() {
        return this.hasFacets;
    }

    @Override
    public boolean isList() {
        return this.isList;
    }

    @Override
    public void setIsList(boolean isList) {
        this.isList = isList;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public List<Number> getEnumerations() {
        return this.enumerations;
    }

    @Override
    public List<Whitespace.Treatment> getWhiteSpaces() {
        return this.whitespaces;
    }

    public List<Integer> getTotalDigits() {
        return this.totalDigits;
    }

    public List<Integer> getFractionDigits() {
        return this.fractionDigits;
    }

    public List<Number> getMaxInclusives() {
        return this.maxInclusives;
    }

    public List<Number> getMaxExclusives() {
        return this.maxExclusives;
    }

    public List<Number> getMinInclusives() {
        return this.minInclusives;
    }

    public List<Number> getMinExclusives() {
        return this.minExclusives;
    }

    @Override
    public void addPattern(String pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<String>(1);
            this.hasFacets = true;
        }
        this.patterns.add(pattern);
    }

    public void addEnumeration(Number enumeration) {
        if (this.enumerations == null) {
            this.enumerations = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.enumerations.add(enumeration);
    }

    @Override
    public void addWhitespace(Whitespace.Treatment whitespace) {
        if (this.whitespaces == null) {
            this.whitespaces = new ArrayList<Whitespace.Treatment>(1);
            this.hasFacets = true;
        }
        this.whitespaces.add(whitespace);
    }

    @Override
    public void addTotalDigits(int totalDigits) {
        if (this.totalDigits == null) {
            this.totalDigits = new ArrayList<Integer>(1);
            this.hasFacets = true;
        }
        this.totalDigits.add(totalDigits);
    }

    @Override
    public void addFractionDigits(int fractionDigits) {
        if (this.fractionDigits == null) {
            this.fractionDigits = new ArrayList<Integer>(1);
            this.hasFacets = true;
        }
        this.fractionDigits.add(fractionDigits);
    }

    public void addMaxInclusive(Number maxInclusive) {
        if (this.maxInclusives == null) {
            this.maxInclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.maxInclusives.add(maxInclusive);
    }

    public void addMaxExclusive(Number maxExclusive) {
        if (this.maxExclusives == null) {
            this.maxExclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.maxExclusives.add(maxExclusive);
    }

    public void addMinInclusive(Number minInclusive) {
        if (this.minInclusives == null) {
            this.minInclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.minInclusives.add(minInclusive);
    }

    public void addMinExclusive(Number minExclusive) {
        if (this.minExclusives == null) {
            this.minExclusives = new ArrayList<Number>(1);
            this.hasFacets = true;
        }
        this.minExclusives.add(minExclusive);
    }

    @Override
    public void removePattern(String pattern) {
        if (this.patterns != null) {
            this.patterns.remove(pattern);
        }
    }

    public void removeEnumeration(Number enumeration) {
        if (this.enumerations != null) {
            this.enumerations.remove(enumeration);
        }
    }

    @Override
    public void removeWhitespace(Whitespace.Treatment whitespace) {
        if (this.whitespaces != null) {
            this.whitespaces.remove(whitespace);
        }
    }

    @Override
    public void removeTotalDigits(Number totalDigits) {
        if (this.totalDigits != null) {
            this.totalDigits.remove(totalDigits);
        }
    }

    @Override
    public void removeFractionDigits(Number fractionDigits) {
        if (this.fractionDigits != null) {
            this.fractionDigits.remove(fractionDigits);
        }
    }

    public void removeMaxInclusive(Number maxInclusive) {
        if (this.maxInclusives != null) {
            this.maxInclusives.remove(maxInclusive);
        }
    }

    public void removeMaxExclusive(Number maxExclusive) {
        if (this.maxExclusives != null) {
            this.maxExclusives.remove(maxExclusive);
        }
    }

    public void removeMinInclusive(Number minInclusive) {
        if (this.minInclusives != null) {
            this.minInclusives.remove(minInclusive);
        }
    }

    public void removeMinExclusive(Number minExclusive) {
        if (this.minExclusives != null) {
            this.minExclusives.remove(minExclusive);
        }
    }

    public static Number toNumber(String value) {
        Number n = null;
        if (value.equals(UNBOUNDED_STRING)) {
            n = UNBOUNDED_VALUE;
        } else {
            try {
                n = new BigDecimal(value);
            }
            catch (Throwable th) {
                n = 0;
            }
        }
        return n;
    }

    public static String toXMLString(Number val) {
        if (val == UNBOUNDED_VALUE) {
            return UNBOUNDED_STRING;
        }
        return String.valueOf(val);
    }
}

