/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.ui.libraries;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.javascript.bower.ui.libraries.Bundle;
import org.netbeans.modules.javascript.bower.ui.libraries.Dependency;
import org.netbeans.modules.javascript.bower.ui.libraries.Library;
import org.netbeans.modules.javascript.bower.ui.libraries.LibraryProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(EditPanel.class);
    private LibraryProvider libraryProvider;
    private Library libraryDetails;
    private boolean loadingLibraryDetails;
    private Library.Version lastSelectedVersion;
    private JComboBox<Library.Version> installVersionCombo;
    private JLabel installVersionLabel;
    private JTextField requiredVersionField;
    private JLabel requiredVersionLabel;

    public EditPanel() {
        this.initComponents();
        this.installVersionCombo.setRenderer(new VersionRenderer());
    }

    void setLibraryProvider(LibraryProvider libraryProvider) {
        this.libraryProvider = libraryProvider;
    }

    void setDependency(Dependency dependency) {
        Library.Version versionToSelect = null;
        String installedVersionName = dependency.getInstalledVersion();
        this.libraryDetails = this.libraryProvider.libraryDetails(dependency.getName(), true);
        if (this.libraryDetails == null) {
            this.libraryDetails = new Library(dependency.getName());
            if (installedVersionName != null) {
                versionToSelect = new Library.Version(this.libraryDetails, installedVersionName);
            }
        } else {
            versionToSelect = installedVersionName == null ? this.libraryDetails.getLatestVersion() : this.findVersion(installedVersionName);
        }
        this.requiredVersionField.setText(dependency.getRequiredVersion());
        this.updateInstalledCombo(versionToSelect);
        this.loadingLibraryDetails = false;
    }

    String getRequiredVersion() {
        return this.requiredVersionField.getText();
    }

    String getInstalledVersion() {
        Library.Version selectedVersion = (Library.Version)this.installVersionCombo.getSelectedItem();
        return selectedVersion == null ? null : selectedVersion.getName();
    }

    private Library.Version findVersion(String versionName) {
        for (Library.Version version : this.libraryDetails.getVersions()) {
            if (!versionName.equals(version.getName())) continue;
            return version;
        }
        return null;
    }

    private void updateLibraryDetails(Library libraryDetails) {
        this.libraryDetails = libraryDetails;
        this.loadingLibraryDetails = false;
        if (libraryDetails != null) {
            Library.Version installedVersion = (Library.Version)this.installVersionCombo.getSelectedItem();
            this.updateInstalledCombo(installedVersion);
        }
    }

    private void updateInstalledCombo(Library.Version installedVersion) {
        DefaultComboBoxModel<Library.Version> model = new DefaultComboBoxModel<Library.Version>();
        Library.Version[] versions = this.libraryDetails.getVersions();
        if (versions == null) {
            if (installedVersion != null) {
                model.addElement(installedVersion);
            }
        } else {
            for (Library.Version version : versions) {
                model.addElement(version);
            }
        }
        this.installVersionCombo.setModel(model);
        this.lastSelectedVersion = installedVersion;
        this.installVersionCombo.setSelectedItem(installedVersion);
    }

    private void loadLibraryDetails(final Library library) {
        final Library details = this.libraryProvider.libraryDetails(library.getName(), false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (library.getName().equals(EditPanel.this.libraryDetails.getName())) {
                    EditPanel.this.updateLibraryDetails(details);
                }
            }
        });
    }

    private void initComponents() {
        this.installVersionLabel = new JLabel();
        this.installVersionCombo = new JComboBox();
        this.requiredVersionLabel = new JLabel();
        this.requiredVersionField = new JTextField();
        this.installVersionLabel.setLabelFor(this.installVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.installVersionLabel, (String)NbBundle.getMessage(EditPanel.class, (String)"EditPanel.installVersionLabel.text"));
        this.installVersionCombo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                EditPanel.this.installVersionComboPopupMenuWillBecomeVisible(evt);
            }
        });
        this.installVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditPanel.this.installVersionComboActionPerformed(evt);
            }
        });
        this.requiredVersionLabel.setLabelFor(this.requiredVersionField);
        Mnemonics.setLocalizedText((JLabel)this.requiredVersionLabel, (String)NbBundle.getMessage(EditPanel.class, (String)"EditPanel.requiredVersionLabel.text"));
        this.requiredVersionField.setColumns(10);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installVersionLabel).addComponent(this.requiredVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installVersionCombo, 0, -1, Short.MAX_VALUE).addComponent(this.requiredVersionField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.installVersionLabel).addComponent(this.installVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.requiredVersionLabel).addComponent(this.requiredVersionField, -2, -1, -2))));
    }

    private void installVersionComboPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        if (this.libraryDetails != null && this.libraryDetails.getVersions() == null && !this.loadingLibraryDetails) {
            this.loadingLibraryDetails = true;
            final Library library = this.libraryDetails;
            RP.post(new Runnable(){

                @Override
                public void run() {
                    EditPanel.this.loadLibraryDetails(library);
                }
            });
        }
    }

    private void installVersionComboActionPerformed(ActionEvent evt) {
        String lastSelectedVersionName = this.lastSelectedVersion == null ? null : this.lastSelectedVersion.getName();
        String requiredVersion = this.requiredVersionField.getText();
        this.lastSelectedVersion = (Library.Version)this.installVersionCombo.getSelectedItem();
        if ((lastSelectedVersionName == null || lastSelectedVersionName.equals(requiredVersion)) && this.lastSelectedVersion != null) {
            String newRequiredVersion = this.lastSelectedVersion.getName();
            if ("\t".equals(newRequiredVersion)) {
                newRequiredVersion = "*";
            }
            this.requiredVersionField.setText(newRequiredVersion);
        }
    }

    private class VersionRenderer
    extends DefaultListCellRenderer {
        private VersionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderedValue;
            if (value instanceof Library.Version) {
                String versionName = ((Library.Version)value).getName();
                if ("\t".equals(versionName)) {
                    versionName = Bundle.EditPanel_latestVersionPlaceholder();
                }
                renderedValue = versionName;
            } else {
                renderedValue = value;
            }
            if (EditPanel.this.loadingLibraryDetails) {
                renderedValue = Bundle.EditPanel_loadingVersions();
            }
            return super.getListCellRendererComponent(list, renderedValue, index, isSelected, cellHasFocus);
        }
    }
}

