/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListFaultDomainsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String availabilityDomain;

    @ConstructorProperties(value={"compartmentId", "availabilityDomain"})
    ListFaultDomainsRequest(String compartmentId, String availabilityDomain) {
        this.compartmentId = compartmentId;
        this.availabilityDomain = availabilityDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).availabilityDomain(this.availabilityDomain);
    }

    public String toString() {
        return "ListFaultDomainsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", availabilityDomain=" + this.getAvailabilityDomain() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListFaultDomainsRequest)) {
            return false;
        }
        ListFaultDomainsRequest other = (ListFaultDomainsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        return !(this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListFaultDomainsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public static class Builder
    implements BmcRequest.Builder<ListFaultDomainsRequest, Void> {
        private String compartmentId;
        private String availabilityDomain;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListFaultDomainsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListFaultDomainsRequest build() {
            ListFaultDomainsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public ListFaultDomainsRequest buildWithoutInvocationCallback() {
            return new ListFaultDomainsRequest(this.compartmentId, this.availabilityDomain);
        }

        public String toString() {
            return "ListFaultDomainsRequest.Builder(compartmentId=" + this.compartmentId + ", availabilityDomain=" + this.availabilityDomain + ")";
        }
    }
}

