/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;

public class UnusableTypesHintError
extends HintErrorRule {
    private static final String TRAVERSABLE_TYPE = "Traversable";
    private static final List<String> VALID_TYPES_WITH_OBJECT_TYPE = Arrays.asList("array", "bool", "callable", "false", "float", "int", "iterable", "null", "string", "void");

    public String getDisplayName() {
        return Bundle.UnusableTypesHintError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(this, fileObject, phpParseResult.getModel(), CodeUtils.getPhpVersion(fileObject));
            phpParseResult.getProgram().accept(checkVisitor);
            result.addAll(checkVisitor.getHints());
        }
    }

    private static final class IterableRedundantTypeCombination
    extends RedundantTypeCombination {
        public IterableRedundantTypeCombination(Rule rule, FileObject fileObject, int startOffset, int endOffset, UnionType unionType, RedundantType redundantType) {
            super(rule, fileObject, startOffset, endOffset, unionType, (Pair<String, String>)Pair.of((Object)"iterable", (Object)redundantType.getType()));
        }

        static enum RedundantType {
            Array("array"),
            Traversable("Traversable");

            private final String type;

            private RedundantType(String type) {
                this.type = type;
            }

            public String getType() {
                return this.type;
            }
        }
    }

    private static class RedundantTypeCombination
    extends Hint {
        public RedundantTypeCombination(Rule rule, FileObject fileObject, int startOffset, int endOffset, UnionType unionType, Pair<String, String> types) {
            super(rule, Bundle.RedundantTypeCombination_description(VariousUtils.getUnionType(unionType), types.first(), types.second()), fileObject, new OffsetRange(startOffset, endOffset), Collections.emptyList(), 500);
        }
    }

    private static final class DuplicateType
    extends Hint {
        private DuplicateType(Rule rule, FileObject fileObject, int startOffset, int endOffset, String type) {
            super(rule, Bundle.DuplicateType_description(type), fileObject, new OffsetRange(startOffset, endOffset), Collections.emptyList(), 500);
        }
    }

    private static final class UnusableType
    extends Hint {
        private UnusableType(Rule rule, FileObject fileObject, int startOffset, int endOffset, String type, Context context) {
            super(rule, Bundle.UnusableType_description(type, context.getContext()), fileObject, new OffsetRange(startOffset, endOffset), Collections.emptyList(), 500);
        }

        static enum Context {
            Parameter(Bundle.UnusableType_Context_parameter()),
            Return(Bundle.UnusableType_Context_return()),
            ArrowFunctionReturn(Bundle.UnusableType_Context_arrowFunctionReturn()),
            Property(Bundle.UnusableType_Context_property()),
            Standalone(Bundle.UnusableType_Context_standalone()),
            Union(Bundle.UnusableType_Context_union()),
            Nullable(Bundle.UnusableType_Context_nullable());

            private final String context;

            private Context(String context) {
                this.context = context;
            }

            public String getContext() {
                return this.context;
            }
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final UnusableTypesHintError rule;
        private final List<Hint> hints = new ArrayList<Hint>();
        private final FileObject fileObject;
        private final Model model;
        private final PhpVersion phpVersion;
        private boolean isInMethod;
        private boolean isInLambdaFunction;
        private boolean isInMethodBody;

        private CheckVisitor(UnusableTypesHintError rule, FileObject fileObject, Model model, PhpVersion phpVersion) {
            assert (fileObject != null);
            this.rule = rule;
            this.fileObject = fileObject;
            this.model = model;
            this.phpVersion = phpVersion;
        }

        private List<Hint> getHints() {
            return Collections.unmodifiableList(this.hints);
        }

        @Override
        public void visit(FieldsDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression fieldType = node.getFieldType();
            if (fieldType != null) {
                this.checkFieldType(fieldType, false);
            }
            super.visit(node);
        }

        @Override
        public void visit(FormalParameter node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression parameterType = node.getParameterType();
            if (parameterType != null) {
                this.checkParameterType(parameterType, false);
            }
            super.visit(node);
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression returnType = node.getReturnType();
            if (returnType != null) {
                this.checkArrowFunctionReturnType(returnType, false);
            }
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.isInLambdaFunction = true;
            this.checkReturnType(node.getReturnType(), false);
            super.visit(node);
            this.isInLambdaFunction = false;
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkReturnType(node.getReturnType(), false);
            super.visit(node);
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (FormalParameter parameter : node.getFunction().getFormalParameters()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                FieldsDeclaration fieldsDeclaration = FieldsDeclaration.create(parameter);
                if (fieldsDeclaration == null) continue;
                this.scan(fieldsDeclaration);
            }
            this.isInMethod = true;
            FunctionDeclaration function = node.getFunction();
            this.scan(function.getFunctionName());
            this.scan(function.getFormalParameters());
            this.checkReturnType(function.getReturnType(), false);
            this.scan(function.getReturnType());
            this.isInMethodBody = true;
            this.scan(function.getBody());
            this.isInMethodBody = false;
            this.isInMethod = false;
        }

        @Override
        public void visit(UnionType node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkUnionType(node);
            super.visit(node);
        }

        @Override
        public void visit(NullableType nullableType) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression type = nullableType.getType();
            if (this.phpVersion.hasMixedType() && type instanceof NamespaceName && CheckVisitor.isMixedType((NamespaceName)type)) {
                this.createError(type, "mixed", UnusableType.Context.Nullable);
            }
            super.visit(nullableType);
        }

        private void checkFieldType(@NullAllowed Expression fieldType, boolean isInUnionType) {
            Expression type = fieldType;
            if (fieldType instanceof NullableType) {
                type = ((NullableType)fieldType).getType();
            }
            if (type == null) {
                return;
            }
            if (type instanceof Identifier) {
                if (CheckVisitor.isCallableType((Identifier)type)) {
                    this.createError(type, "callable", UnusableType.Context.Property);
                }
            } else if (type instanceof NamespaceName) {
                if (CheckVisitor.isVoidType((NamespaceName)type)) {
                    this.createError(type, "void", UnusableType.Context.Property);
                } else if (CheckVisitor.isNeverType((NamespaceName)type)) {
                    this.createError(type, "never", UnusableType.Context.Property);
                }
                if (!isInUnionType) {
                    this.checkFalseAndNullTypes((NamespaceName)type);
                }
            } else if (type instanceof UnionType) {
                ((UnionType)type).getTypes().forEach(unionType -> this.checkFieldType((Expression)unionType, true));
            }
        }

        private void checkParameterType(Expression parameterType, boolean isInUnionType) {
            if (parameterType instanceof NamespaceName) {
                if (CheckVisitor.isVoidType((NamespaceName)parameterType)) {
                    this.createError(parameterType, "void", UnusableType.Context.Parameter);
                } else if (CheckVisitor.isNeverType((NamespaceName)parameterType)) {
                    this.createError(parameterType, "never", UnusableType.Context.Parameter);
                }
                if (!isInUnionType) {
                    this.checkFalseAndNullTypes((NamespaceName)parameterType);
                }
            } else if (parameterType instanceof UnionType) {
                ((UnionType)parameterType).getTypes().forEach(type -> this.checkParameterType((Expression)type, true));
            }
        }

        private void checkArrowFunctionReturnType(Expression returnType, boolean isInUnionType) {
            if (returnType instanceof NamespaceName) {
                if (CheckVisitor.isVoidType((NamespaceName)returnType)) {
                    this.createError(returnType, "void", UnusableType.Context.ArrowFunctionReturn);
                } else if (CheckVisitor.isNeverType((NamespaceName)returnType)) {
                    this.createError(returnType, "never", UnusableType.Context.ArrowFunctionReturn);
                }
                if (!isInUnionType) {
                    this.checkFalseAndNullTypes((NamespaceName)returnType);
                }
            } else if (returnType instanceof UnionType) {
                ((UnionType)returnType).getTypes().forEach(type -> this.checkArrowFunctionReturnType((Expression)type, true));
            }
        }

        private void checkReturnType(@NullAllowed Expression returnType, boolean isInUnionType) {
            if (returnType == null) {
                return;
            }
            Expression type = returnType;
            if (returnType instanceof NullableType) {
                type = ((NullableType)returnType).getType();
            }
            if (type instanceof NamespaceName) {
                if (!isInUnionType) {
                    this.checkFalseAndNullTypes((NamespaceName)type);
                } else if (CheckVisitor.isVoidType((NamespaceName)type)) {
                    this.createError(type, "void", UnusableType.Context.Union);
                } else if (CheckVisitor.isNeverType((NamespaceName)type)) {
                    this.createError(type, "never", UnusableType.Context.Union);
                }
            } else if (type instanceof UnionType) {
                ((UnionType)type).getTypes().forEach(unionType -> this.checkReturnType((Expression)unionType, true));
            } else if (type instanceof Identifier && ((Identifier)type).getName().equals("static") && (!this.isInMethod && !this.isInLambdaFunction || !this.isInLambdaFunction && this.isInMethodBody)) {
                this.createError(type, "static", UnusableType.Context.Return);
            }
        }

        private void checkFalseAndNullTypes(NamespaceName type) {
            if (CheckVisitor.isFalseType(type)) {
                this.createError(type, "false", UnusableType.Context.Standalone);
            } else if (CheckVisitor.isNullType(type)) {
                this.createError(type, "null", UnusableType.Context.Standalone);
            }
        }

        private void checkUnionType(UnionType unionType) {
            this.checkDuplicateType(unionType);
            this.checkRedundantTypeCombination(unionType);
        }

        private void checkDuplicateType(UnionType unionType) {
            HashSet<String> types = new HashSet<String>();
            for (Expression type : unionType.getTypes()) {
                QualifiedName qualifiedName = QualifiedName.create(type);
                assert (qualifiedName != null);
                String name = qualifiedName.toString().toLowerCase(Locale.ENGLISH);
                if ("false".equals(name)) {
                    name = "bool";
                }
                if (types.contains(name)) {
                    this.createDuplicateTypeError(type, qualifiedName.toString());
                    return;
                }
                types.add(name);
            }
        }

        private void checkRedundantTypeCombination(UnionType unionType) {
            this.checkRedundantTypeCombinationWithObject(unionType);
            this.checkRedundantMixedType(unionType);
            this.checkRedundantTypeCombinationWithIterable(unionType);
        }

        private void checkRedundantTypeCombinationWithObject(UnionType unionType) {
            boolean hasObjectType = false;
            for (Expression type : unionType.getTypes()) {
                if (!(type instanceof NamespaceName) || !CheckVisitor.isObjectType((NamespaceName)type)) continue;
                hasObjectType = true;
            }
            if (hasObjectType) {
                for (Expression type : unionType.getTypes()) {
                    if (type instanceof NamespaceName && !CheckVisitor.isObjectType((NamespaceName)type)) {
                        String typeName = CodeUtils.extractUnqualifiedName((NamespaceName)type);
                        if (VALID_TYPES_WITH_OBJECT_TYPE.contains(typeName)) continue;
                        this.createRedundantTypeCombinationError(type, unionType, "object", CodeUtils.extractQualifiedName((NamespaceName)type));
                        continue;
                    }
                    if (!(type instanceof Identifier) || VALID_TYPES_WITH_OBJECT_TYPE.contains(((Identifier)type).getName())) continue;
                    this.createRedundantTypeCombinationError(type, unionType, "object", ((Identifier)type).getName());
                }
            }
        }

        private void checkRedundantMixedType(UnionType unionType) {
            for (Expression type : unionType.getTypes()) {
                if (!(type instanceof NamespaceName) || !CheckVisitor.isMixedType((NamespaceName)type)) continue;
                this.createError(type, "mixed", UnusableType.Context.Union);
                break;
            }
        }

        private void checkRedundantTypeCombinationWithIterable(UnionType unionType) {
            boolean hasIterable = false;
            boolean hasTraversable = false;
            boolean hasArray = false;
            for (Expression type : unionType.getTypes()) {
                if (!(type instanceof NamespaceName) || !CheckVisitor.isIterableType((NamespaceName)type)) continue;
                hasIterable = true;
                break;
            }
            if (hasIterable) {
                for (Expression type : unionType.getTypes()) {
                    if (type instanceof Identifier) {
                        if (!CheckVisitor.isArrayType((Identifier)type)) continue;
                        hasArray = true;
                        continue;
                    }
                    if (!(type instanceof NamespaceName) || !CheckVisitor.isTraversableType((NamespaceName)type)) continue;
                    NamespaceName name = (NamespaceName)type;
                    QualifiedName qualifiedName = QualifiedName.create(name);
                    NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this.model.getFileScope(), type.getStartOffset());
                    QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(qualifiedName, type.getStartOffset(), namespaceScope);
                    if (!"\\Traversable".equals(fullyQualifiedName.toString())) continue;
                    hasTraversable = true;
                }
            }
            if (hasIterable && hasArray) {
                this.createIterableRedundantTypeCombinationError(unionType, IterableRedundantTypeCombination.RedundantType.Array);
            }
            if (hasIterable && hasTraversable) {
                this.createIterableRedundantTypeCombinationError(unionType, IterableRedundantTypeCombination.RedundantType.Traversable);
            }
        }

        private void createError(ASTNode node, String type, UnusableType.Context context) {
            this.createError(node.getStartOffset(), node.getEndOffset(), type, context);
        }

        private void createError(int startOffset, int endOffset, String type, UnusableType.Context context) {
            this.hints.add(new UnusableType((Rule)this.rule, this.fileObject, startOffset, endOffset, type, context));
        }

        private void createDuplicateTypeError(ASTNode node, String type) {
            this.hints.add(new DuplicateType((Rule)this.rule, this.fileObject, node.getStartOffset(), node.getEndOffset(), type));
        }

        private void createRedundantTypeCombinationError(ASTNode node, UnionType unionType, String type, String redundantType) {
            this.hints.add(new RedundantTypeCombination((Rule)this.rule, this.fileObject, node.getStartOffset(), node.getEndOffset(), unionType, (Pair<String, String>)Pair.of((Object)type, (Object)redundantType)));
        }

        private void createIterableRedundantTypeCombinationError(UnionType unionType, IterableRedundantTypeCombination.RedundantType redundantType) {
            this.hints.add(new IterableRedundantTypeCombination((Rule)this.rule, this.fileObject, unionType.getStartOffset(), unionType.getEndOffset(), unionType, redundantType));
        }

        private static boolean isArrayType(Identifier identifier) {
            return !identifier.isKeyword() && "array".equals(identifier.getName().toLowerCase(Locale.ENGLISH));
        }

        private static boolean isCallableType(Identifier identifier) {
            return !identifier.isKeyword() && "callable".equals(identifier.getName().toLowerCase(Locale.ENGLISH));
        }

        private static boolean isVoidType(NamespaceName namespaceName) {
            return "void".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isNeverType(NamespaceName namespaceName) {
            return "never".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isFalseType(NamespaceName namespaceName) {
            return "false".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isNullType(NamespaceName namespaceName) {
            return "null".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isObjectType(NamespaceName namespaceName) {
            return "object".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isMixedType(NamespaceName namespaceName) {
            return "mixed".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isIterableType(NamespaceName namespaceName) {
            return "iterable".equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }

        private static boolean isTraversableType(NamespaceName namespaceName) {
            return UnusableTypesHintError.TRAVERSABLE_TYPE.equals(CodeUtils.extractUnqualifiedName(namespaceName));
        }
    }
}

