/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.nodes.Hk2ApplicationsChildren;
import org.netbeans.modules.payara.common.nodes.Hk2InstanceNode;
import org.netbeans.modules.payara.common.nodes.Hk2ItemNode;
import org.netbeans.modules.payara.common.nodes.Hk2ResourceContainers;
import org.netbeans.modules.payara.common.nodes.Hk2WSChildren;
import org.netbeans.modules.payara.common.nodes.Refreshable;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.spi.PluggableNodeProvider;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class Hk2InstanceChildren
extends Children.Keys<Node>
implements Refreshable,
ChangeListener {
    private PayaraInstance serverInstance;

    Hk2InstanceChildren(PayaraInstance instance) {
        this.serverInstance = instance;
        this.serverInstance.getCommonSupport().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.serverInstance));
    }

    @Override
    public void updateKeys() {
        LinkedList<Hk2ItemNode> keys = new LinkedList<Hk2ItemNode>();
        this.serverInstance.getCommonSupport().refresh();
        if (this.serverInstance.getServerState() == PayaraModule.ServerState.RUNNING) {
            keys.add(new Hk2ItemNode(this.serverInstance.getLookup(), (Children)new Hk2ApplicationsChildren(this.serverInstance.getLookup()), NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_Apps"), Hk2ItemNode.J2EE_APPLICATION_FOLDER));
            keys.add(new Hk2ItemNode(this.serverInstance.getLookup(), (Children)new Hk2ResourceContainers(this.serverInstance.getLookup()), NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_Resources"), Hk2ItemNode.RESOURCES_FOLDER));
            String iid = this.serverInstance.getDeployerUri();
            if (null != iid && iid.contains("pfv3ee6wc")) {
                keys.add(new Hk2ItemNode(this.serverInstance.getLookup(), (Children)new Hk2WSChildren(this.serverInstance.getLookup()), NbBundle.getMessage(Hk2InstanceNode.class, (String)"LBL_WS"), Hk2ItemNode.WS_FOLDER));
            }
            List<Node> pluggableNodes = this.getExtensionNodes();
            Iterator<Node> itr = pluggableNodes.iterator();
            while (itr.hasNext()) {
                keys.add((Hk2ItemNode)itr.next());
            }
        }
        this.setKeys(keys);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        Set noKeys = Collections.emptySet();
        this.setKeys(noKeys);
    }

    protected Node[] createNodes(Node key) {
        return new Node[]{key};
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                Hk2InstanceChildren.this.updateKeys();
            }
        });
    }

    List<Node> getExtensionNodes() {
        ArrayList<Node> nodesList = new ArrayList<Node>();
        for (PluggableNodeProvider nep : Lookup.getDefault().lookupAll(PluggableNodeProvider.class)) {
            if (nep == null) continue;
            try {
                Node node = nep.getPluggableNode(this.serverInstance.getProperties());
                if (node == null) continue;
                nodesList.add(node);
            }
            catch (Exception ex) {
                Logger.getLogger("payara-common").log(Level.SEVERE, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)nep.getClass().getName()));
                Logger.getLogger("payara-common").log(Level.FINER, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)nep.getClass().getName()), ex);
            }
            catch (AssertionError ae) {
                Logger.getLogger("payara-common").log(Level.SEVERE, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)(nep.getClass().getName() + ".")));
                Logger.getLogger("payara-common").log(Level.FINER, NbBundle.getMessage(Hk2InstanceChildren.class, (String)"WARN_BOGUS_GET_EXTENSION_NODE_IMPL", (Object)nep.getClass().getName()), (Throwable)((Object)ae));
            }
        }
        return nodesList;
    }
}

