/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.api;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2ee.common.SharabilityUtility;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.Utils;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectCreateData;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.javaee.project.api.ant.DeployOnSaveUtils;
import org.netbeans.modules.javaee.project.api.ant.ui.J2EEProjectProperties;
import org.netbeans.spi.java.project.support.PreferredProjectPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EjbJarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "conf";
    private static final String DEFAULT_SRC_FOLDER = "src";
    private static final String DEFAULT_TEST_FOLDER = "test";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String DEFAULT_JAVA_FOLDER = "java";
    private static final String DEFAULT_BUILD_DIR = "build";
    public static final String MINIMUM_ANT_VERSION = "1.6.5";

    private EjbJarProjectGenerator() {
    }

    public static AntProjectHelper createProject(File dir, String name, String j2eeLevel, String serverInstanceID) throws IOException {
        return EjbJarProjectGenerator.createProject(dir, name, j2eeLevel, serverInstanceID, null);
    }

    @Deprecated
    public static AntProjectHelper createProject(File dir, String name, String j2eeLevel, String serverInstanceID, String librariesDefinition) throws IOException {
        EjbJarProjectCreateData createData = new EjbJarProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setJavaEEProfile(Profile.fromPropertiesString((String)j2eeLevel));
        createData.setServerInstanceID(serverInstanceID);
        createData.setLibrariesDefinition(librariesDefinition);
        return EjbJarProjectGenerator.createProject(createData);
    }

    public static AntProjectHelper createProject(final EjbJarProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = EjbJarProjectGenerator.createProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    private static AntProjectHelper createProjectImpl(final EjbJarProjectCreateData createData, FileObject projectDir) throws IOException {
        String name = createData.getName();
        String serverInstanceID = createData.getServerInstanceID();
        FileObject srcRoot = projectDir.createFolder(DEFAULT_SRC_FOLDER);
        srcRoot.createFolder(DEFAULT_JAVA_FOLDER);
        if (!createData.skipTests()) {
            projectDir.createFolder(DEFAULT_TEST_FOLDER);
        }
        FileObject confRoot = srcRoot.createFolder(DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)"org-netbeans-modules-j2ee-ejbjarproject/MANIFEST.MF"), (FileObject)confRoot, (String)"MANIFEST");
        final AntProjectHelper h = EjbJarProjectGenerator.setupProject(projectDir, name, DEFAULT_SRC_FOLDER, DEFAULT_TEST_FOLDER, null, null, null, createData.getJavaEEProfile(), serverInstanceID, createData.getLibrariesDefinition(), createData.skipTests());
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put("source.root", DEFAULT_SRC_FOLDER);
        ep.setProperty("meta.inf", "${source.root}/conf");
        ep.setProperty("src.dir", "${source.root}/java");
        ep.setProperty("meta.inf.excludes", "sun-cmp-mappings.xml");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        h.putProperties("nbproject/project.properties", ep);
        EjbJarProject p = (EjbJarProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ProjectManager.getDefault().saveProject((Project)p);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EjbJarProjectGenerator.copyRequiredLibraries(h, refHelper, createData);
                    return null;
                }
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex.getException());
        }
        Profile profile = createData.getJavaEEProfile();
        boolean isJ2EE = false;
        if (profile.equals(Profile.J2EE_14) || profile.equals(Profile.J2EE_13)) {
            isJ2EE = true;
        }
        if (isJ2EE) {
            String resource = profile.equals(Profile.J2EE_14) ? "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml" : "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.0.xml";
            FileObject ddFile = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)resource), (FileObject)confRoot, (String)"ejb-jar");
            EjbJar ejbJar = DDProvider.getDefault().getDDRoot(ddFile);
            ejbJar.setDisplayName(name);
            ejbJar.write(ddFile);
        }
        if (createData.isCDIEnabled()) {
            DDHelper.createBeansXml((Profile)profile, (FileObject)confRoot);
        }
        return h;
    }

    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID, boolean fromJavaSources) throws IOException {
        return EjbJarProjectGenerator.importProject(dir, name, sourceFolders, testFolders, configFilesBase, libFolder, j2eeLevel, serverInstanceID, fromJavaSources, null);
    }

    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID, boolean fromJavaSources, String librariesDefinition) throws IOException {
        AntProjectHelper retVal = EjbJarProjectGenerator.importProject(dir, name, sourceFolders, testFolders, configFilesBase, libFolder, j2eeLevel, serverInstanceID, librariesDefinition);
        EditableProperties subEp = retVal.getProperties("nbproject/project.properties");
        subEp.setProperty("java.source.based", fromJavaSources + "");
        retVal.putProperties("nbproject/project.properties", subEp);
        Project subP = ProjectManager.getDefault().findProject(retVal.getProjectDirectory());
        ProjectManager.getDefault().saveProject(subP);
        return retVal;
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID) throws IOException {
        return EjbJarProjectGenerator.importProject(dir, name, sourceFolders, testFolders, configFilesBase, libFolder, j2eeLevel, serverInstanceID, null);
    }

    @Deprecated
    public static AntProjectHelper importProject(File dir, String name, File[] sourceFolders, File[] testFolders, File configFilesBase, File libFolder, String j2eeLevel, String serverInstanceID, String librariesDefinition) throws IOException {
        EjbJarProjectCreateData createData = new EjbJarProjectCreateData();
        createData.setProjectDir(dir);
        createData.setName(name);
        createData.setSourceFolders(sourceFolders);
        createData.setTestFolders(testFolders);
        createData.setConfigFilesBase(configFilesBase);
        createData.setLibFolder(libFolder);
        createData.setJavaEEProfile(Profile.fromPropertiesString((String)j2eeLevel));
        createData.setServerInstanceID(serverInstanceID);
        createData.setLibrariesDefinition(librariesDefinition);
        return EjbJarProjectGenerator.importProject(createData);
    }

    public static AntProjectHelper importProject(final EjbJarProjectCreateData createData) throws IOException {
        File dir = createData.getProjectDir();
        assert (dir != null) : "Project folder can't be null";
        final FileObject projectDir = FileUtil.createFolder((File)dir);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        FileSystem fs = projectDir.getFileSystem();
        fs.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                AntProjectHelper helper;
                h[0] = helper = EjbJarProjectGenerator.importProjectImpl(createData, projectDir);
            }
        });
        return h[0];
    }

    private static AntProjectHelper importProjectImpl(final EjbJarProjectCreateData createData, FileObject projectDir) throws IOException {
        String name = createData.getName();
        final File[] sourceFolders = createData.getSourceFolders();
        final File[] testFolders = createData.getTestFolders();
        Profile j2eeProfile = createData.getJavaEEProfile();
        String serverInstanceID = createData.getServerInstanceID();
        assert (sourceFolders != null && testFolders != null) : "Package roots can't be null";
        final AntProjectHelper h = EjbJarProjectGenerator.setupProject(projectDir, name, null, null, createData.getConfigFilesBase(), createData.getLibFolder(), null, j2eeProfile, serverInstanceID, createData.getLibrariesDefinition(), createData.skipTests());
        final EjbJarProject p = (EjbJarProject)ProjectManager.getDefault().findProject(projectDir);
        final ReferenceHelper refHelper = p.getReferenceHelper();
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    EditableProperties props;
                    Element root;
                    String propName;
                    int i;
                    Element data = h.getPrimaryConfigurationData(true);
                    Document doc = data.getOwnerDocument();
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
                    assert (nl.getLength() == 1);
                    Element sourceRoots = (Element)nl.item(0);
                    nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
                    assert (nl.getLength() == 1);
                    Element testRoots = (Element)nl.item(0);
                    for (i = 0; i < sourceFolders.length; ++i) {
                        propName = "src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                        String srcReference = refHelper.createForeignFileReference(sourceFolders[i], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                        root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                        root.setAttribute("id", propName);
                        sourceRoots.appendChild(root);
                        props = h.getProperties("nbproject/project.properties");
                        props.put(propName, srcReference);
                        h.putProperties("nbproject/project.properties", props);
                    }
                    if (testFolders.length == 0) {
                        EditableProperties props2 = h.getProperties("nbproject/project.properties");
                        props2.put("test.src.dir", "");
                        h.putProperties("nbproject/project.properties", props2);
                    } else {
                        for (i = 0; i < testFolders.length; ++i) {
                            if (!testFolders[i].exists()) {
                                FileUtil.createFolder((File)testFolders[i]);
                            }
                            propName = "test.src.dir" + (i == 0 ? "" : Integer.toString(i + 1));
                            String testReference = refHelper.createForeignFileReference(testFolders[i], EjbJarProjectGenerator.DEFAULT_JAVA_FOLDER);
                            root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                            root.setAttribute("id", propName);
                            testRoots.appendChild(root);
                            props = h.getProperties("nbproject/project.properties");
                            props.put(propName, testReference);
                            h.putProperties("nbproject/project.properties", props);
                        }
                    }
                    h.putPrimaryConfigurationData(data, true);
                    EjbJarProjectGenerator.copyRequiredLibraries(h, refHelper, createData);
                    ProjectManager.getDefault().saveProject((Project)p);
                    return null;
                }
            });
        }
        catch (MutexException me) {
            IOException ex = new IOException("project creation failed");
            ex.initCause(me);
            throw ex;
        }
        FileObject ejbJarXml = FileUtil.toFileObject((File)createData.getConfigFilesBase()).getFileObject("ejb-jar.xml");
        if (ejbJarXml != null) {
            try {
                String dispName;
                boolean updateXml;
                EjbJar root = DDProvider.getDefault().getDDRoot(ejbJarXml);
                boolean writeDD = false;
                boolean bl = root.getVersion() == null ? true : (updateXml = new BigDecimal("2.1").compareTo(root.getVersion()) > 0);
                if (updateXml && Profile.J2EE_14.equals(j2eeProfile)) {
                    root.setVersion(new BigDecimal("2.1"));
                    writeDD = true;
                }
                if (null == (dispName = root.getDefaultDisplayName()) || dispName.trim().length() == 0) {
                    root.setDisplayName(name);
                    writeDD = true;
                }
                if (writeDD) {
                    root.write(ejbJarXml);
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return h;
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, EjbJarProjectCreateData data) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        if (!data.skipTests() && rh.getProjectLibraryManager().getLibrary("junit") == null && LibraryManager.getDefault().getLibrary("junit") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit"));
        }
        if (!data.skipTests() && rh.getProjectLibraryManager().getLibrary("junit_4") == null && LibraryManager.getDefault().getLibrary("junit_4") != null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary("junit_4"));
        }
        Profile j2eeProfile = data.getJavaEEProfile();
        String libraryName = null;
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            libraryName = "javaee-endorsed-api-6.0";
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            libraryName = "javaee-endorsed-api-7.0";
        }
        if (libraryName != null && rh.getProjectLibraryManager().getLibrary(libraryName) == null) {
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libraryName));
        }
        SharabilityUtility.makeSureProjectHasCopyLibsLibrary((AntProjectHelper)h, (ReferenceHelper)rh);
    }

    private static String createFileReference(ReferenceHelper refHelper, FileObject projectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)projectFO, (FileObject)referencedFO)) {
            return EjbJarProjectGenerator.relativePath(projectFO, referencedFO);
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private static AntProjectHelper setupProject(FileObject dirFO, String name, String srcRoot, String testRoot, File configFiles, File libraries, String resources, Profile j2eeProfile, String serverInstanceID, String librariesDefinition, boolean skipTests) throws IOException {
        EditableProperties props;
        String ref;
        String[] stringArray;
        Utils.logUI(NbBundle.getBundle(EjbJarProjectGenerator.class), "UI_EJB_PROJECT_CREATE_SHARABILITY", new Object[]{librariesDefinition != null, Boolean.FALSE});
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.j2ee.ejbjarproject", (String)librariesDefinition);
        EjbJarProject prj = (EjbJarProject)ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ReferenceHelper referenceHelper = prj.getReferenceHelper();
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "minimum-ant-version");
        minant.appendChild(doc.createTextNode(MINIMUM_ANT_VERSION));
        data.appendChild(minant);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        EditableProperties epPriv = h.getProperties("nbproject/private/private.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "src.dir");
            root.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_src.dir"));
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            root.setAttribute("id", "test.src.dir");
            root.setAttribute("name", NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"NAME_test.src.dir"));
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        if (resources != null) {
            ep.setProperty("resource.dir", resources);
        } else {
            ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        }
        JavaPlatform defaultPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        SpecificationVersion v = defaultPlatform.getSpecification().getVersion();
        String sourceLevel = v.toString();
        ep.setProperty("javac.source", sourceLevel);
        ep.setProperty("javac.target", sourceLevel);
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("dist.ear.jar", "${dist.dir}/${jar.name}");
        ep.setProperty("j2ee.platform", j2eeProfile.toPropertiesString());
        ep.setProperty("jar.name", PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("jar.compress", "false");
        ep.setProperty("javac.classpath", "");
        J2EEProjectProperties.setServerProperties((EditableProperties)ep, (EditableProperties)epPriv, null, null, (String)serverInstanceID, (Profile)j2eeProfile, (J2eeModule.Type)J2eeModule.Type.EJB);
        ep.setProperty("j2ee.compile.on.save", "true");
        ep.setProperty("j2ee.deploy.on.save", DeployOnSaveUtils.isDeployOnSaveSupported((String)serverInstanceID));
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        if (skipTests) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        ep.setProperty("javac.test.classpath", stringArray);
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.ear.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}");
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.preview", "true");
        ep.setProperty("javadoc.additionalparam", "");
        ep.setProperty("runmain.jvmargs", "");
        ep.setComment("runmain.jvmargs", new String[]{"# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs"), "# " + NbBundle.getMessage(EjbJarProjectGenerator.class, (String)"COMMENT_runmain.jvmargs_2")}, false);
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (j2eeProfile.equals(Profile.JAVA_EE_6_FULL) || j2eeProfile.equals(Profile.JAVA_EE_6_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-6.0.classpath}"});
        }
        if (j2eeProfile.equals(Profile.JAVA_EE_7_FULL) || j2eeProfile.equals(Profile.JAVA_EE_7_WEB)) {
            ep.setProperty("endorsed.classpath", new String[]{"${libs.javaee-endorsed-api-7.0.classpath}"});
        }
        h.putProperties("nbproject/project.properties", ep);
        if (configFiles != null) {
            ref = EjbJarProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)configFiles));
            props = h.getProperties("nbproject/project.properties");
            props.setProperty("meta.inf", ref);
            h.putProperties("nbproject/project.properties", props);
        }
        if (libraries != null) {
            ref = EjbJarProjectGenerator.createFileReference(referenceHelper, dirFO, FileUtil.toFileObject((File)libraries));
            props = h.getProperties("nbproject/project.properties");
            props.setProperty("lib.dir", ref);
            h.putProperties("nbproject/project.properties", props);
        }
        J2EEProjectProperties.createDeploymentScript((FileObject)dirFO, (EditableProperties)ep, (EditableProperties)epPriv, (String)serverInstanceID, (J2eeModule.Type)J2eeModule.Type.EJB);
        h.putProperties("nbproject/private/private.properties", epPriv);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(p);
        return h;
    }

    public static void setPlatform(final AntProjectHelper helper, final String platformName, final String sourceLevel) {
        FileObject projectDir = helper.getProjectDirectory();
        if (projectDir == null) {
            return;
        }
        try {
            projectDir.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JavaPlatform platform;
                                EjbJarProject project = (EjbJarProject)ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                                UpdateHelper updateHelper = project.getUpdateHelper();
                                EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                String finalPlatformName = platformName;
                                if (finalPlatformName == null && (platform = PreferredProjectPlatform.getPreferredPlatform((String)JavaPlatform.getDefault().getSpecification().getName())) != null) {
                                    finalPlatformName = platform.getDisplayName();
                                }
                                PlatformUiSupport.storePlatform((EditableProperties)ep, (UpdateHelper)updateHelper, (String)"http://www.netbeans.org/ns/j2ee-ejbjarproject/3", (String)finalPlatformName, (SpecificationVersion)(sourceLevel != null ? new SpecificationVersion(sourceLevel) : null));
                                helper.putProperties("nbproject/project.properties", ep);
                                ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    });
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }
}

