/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.diff.builtin.visualizer.TextDiffVisualizer;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.ExportDiffSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ExportDiffAction
extends ContextAction {
    private static final int enabledForStatus = 72084;

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_ExportDiff";
    }

    @Override
    public String getName() {
        String setupName;
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource && (setupName = ((DiffSetupSource)activated).getSetupDisplayName()) != null) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.getBaseName(this.getActivatedNodes()) + "_Context"), (Object)setupName);
        }
        return super.getName();
    }

    @Override
    public boolean enable(Node[] nodes) {
        if (super.enable(nodes)) {
            Context ctx = this.getCachedContext(nodes);
            if (!Subversion.getInstance().getStatusCache().containsFiles(ctx, 72084, true)) {
                return false;
            }
            TopComponent activated = TopComponent.getRegistry().getActivated();
            if (activated instanceof DiffSetupSource) {
                return true;
            }
            return Lookup.getDefault().lookup(DiffProvider.class) != null;
        }
        return false;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        this.performContextAction(nodes, false);
    }

    void performContextAction(final Node[] nodes, final boolean singleDiffSetup) {
        boolean noop;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodes);
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            noop = ((DiffSetupSource)activated).getSetups().isEmpty();
        } else {
            boolean bl = noop = !Subversion.getInstance().getStatusCache().containsFiles(context, 88532, true);
        }
        if (noop) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"BK3001"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        ExportDiffSupport exportDiffSupport = new ExportDiffSupport(context.getRootFiles(), SvnModuleConfig.getDefault().getPreferences()){

            public void writeDiffFile(final File toFile) {
                RequestProcessor rp = Subversion.getInstance().getRequestProcessor();
                SvnProgressSupport ps = new SvnProgressSupport(){

                    @Override
                    protected void perform() {
                        ExportDiffAction.this.async(this, nodes, toFile, singleDiffSetup);
                    }
                };
                ps.start(rp, null, ExportDiffAction.this.getRunningName(nodes)).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    @Override
    protected boolean asynchronous() {
        return false;
    }

    private void async(SvnProgressSupport progress, Node[] nodes, File destination, boolean singleDiffSetup) {
        File root;
        ArrayList<Setup> setups;
        TopComponent activated = TopComponent.getRegistry().getActivated();
        if (activated instanceof DiffSetupSource) {
            if (!singleDiffSetup) {
                setups = new ArrayList<Setup>(((DiffSetupSource)activated).getSetups());
            } else if (nodes.length > 0 && nodes[0] instanceof DiffNode) {
                setups = new ArrayList<Setup>(Collections.singletonList(((DiffNode)nodes[0]).getSetup()));
            } else {
                return;
            }
            ArrayList<File> setupFiles = new ArrayList<File>(setups.size());
            for (Setup setup : setups) {
                setupFiles.add(setup.getBaseFile());
            }
            root = ExportDiffAction.getCommonParent(setupFiles.toArray(new File[setupFiles.size()]));
        } else {
            Context context = this.getContext(nodes);
            File[] files = SvnUtils.getModifiedFiles(context, 88532);
            root = ExportDiffAction.getCommonParent(context.getRootFiles());
            setups = new ArrayList(files.length);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (Subversion.getInstance().getStatusCache().getStatus(file).isDirectory()) continue;
                Setup setup = new Setup(file, null, 0);
                setups.add(setup);
            }
        }
        this.exportDiff(setups, destination, root, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDiff(List<Setup> setups, File destination, File root, SvnProgressSupport progress) {
        if (root == null) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Prompt"), NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_BadSelection_Title"), -1, 0, null, null);
            DialogDisplayer.getDefault().notify(nd);
            return;
        }
        boolean success = false;
        OutputStream out = null;
        int exportedFiles = 0;
        try {
            String sep = System.getProperty("line.separator");
            out = new BufferedOutputStream(new FileOutputStream(destination));
            out.write(("# This patch file was generated by NetBeans IDE" + sep).getBytes("utf8"));
            out.write(("# Following Index: paths are relative to: " + root.getAbsolutePath() + sep).getBytes("utf8"));
            out.write(("# This patch can be applied using context Tools: Patch action on respective folder." + sep).getBytes("utf8"));
            out.write(("# It uses platform neutral UTF-8 encoding and \\n newlines." + sep).getBytes("utf8"));
            out.write(("# Above lines and this line are ignored by the patching process." + sep).getBytes("utf8"));
            Collections.sort(setups, new Comparator<Setup>(){

                @Override
                public int compare(Setup o1, Setup o2) {
                    return o1.getBaseFile().compareTo(o2.getBaseFile());
                }
            });
            Iterator<Setup> it = setups.iterator();
            int i = 0;
            while (it.hasNext()) {
                String filePath;
                Setup setup = it.next();
                File file = setup.getBaseFile();
                if (file.isDirectory()) continue;
                try {
                    progress.setRepositoryRoot(SvnUtils.getRepositoryRootUrl(file));
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                    if (out != null) {
                        try {
                            out.flush();
                            out.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (success) {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3004", (Object)exportedFiles));
                        if (exportedFiles == 0) {
                            destination.delete();
                        } else {
                            Utils.openFile((File)FileUtil.normalizeFile((File)destination));
                        }
                    } else {
                        destination.delete();
                    }
                    return;
                }
                progress.setDisplayName(file.getName());
                String index = "Index: ";
                String rootPath = root.getAbsolutePath();
                String relativePath = filePath = file.getAbsolutePath();
                if (filePath.startsWith(rootPath)) {
                    relativePath = filePath.substring(rootPath.length() + 1).replace(File.separatorChar, '/');
                    index = index + relativePath + sep;
                    out.write(index.getBytes("utf8"));
                }
                this.exportDiff(setup, relativePath, out);
                ++i;
            }
            exportedFiles = i;
            success = true;
        }
        catch (IOException ex) {
            SvnClientExceptionHandler.notifyException(new Exception(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3003", (Object)ex.getLocalizedMessage()), ex), true, false);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (success) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ExportDiffAction.class, (String)"BK3004", (Object)exportedFiles));
                if (exportedFiles == 0) {
                    destination.delete();
                } else {
                    Utils.openFile((File)FileUtil.normalizeFile((File)destination));
                }
            } else {
                destination.delete();
            }
        }
    }

    private static File getCommonParent(File[] files) {
        File root = files[0];
        if (!root.exists() || root.isFile()) {
            root = root.getParentFile();
        }
        for (int i = 1; i < files.length; ++i) {
            if ((root = Utils.getCommonParent((File)root, (File)files[i])) != null) continue;
            return null;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDiff(Setup setup, String relativePath, OutputStream out) throws IOException {
        Difference[] differences;
        setup.initSources();
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        Reader r1 = null;
        Reader r2 = null;
        try {
            r1 = setup.getFirstSource().createReader();
            if (r1 == null) {
                r1 = new StringReader("");
            }
            if ((r2 = setup.getSecondSource().createReader()) == null) {
                r2 = new StringReader("");
            }
            differences = diff.computeDiff(r1, r2);
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception exception) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception exception) {}
            }
        }
        File file = setup.getBaseFile();
        try {
            int i;
            ByteArrayInputStream is;
            if (!SvnUtils.getMimeType(file).startsWith("text/") && differences.length == 0) {
                is = new ByteArrayInputStream(this.exportBinaryFile(file).getBytes("utf8"));
            } else {
                r1 = setup.getFirstSource().createReader();
                if (r1 == null) {
                    r1 = new StringReader("");
                }
                if ((r2 = setup.getSecondSource().createReader()) == null) {
                    r2 = new StringReader("");
                }
                TextDiffVisualizer.TextDiffInfo info = new TextDiffVisualizer.TextDiffInfo(relativePath + " " + setup.getFirstSource().getTitle(), relativePath + " " + setup.getSecondSource().getTitle(), null, null, r1, r2, differences);
                info.setContextMode(true, 3);
                String diffText = TextDiffVisualizer.differenceToUnifiedDiffText((TextDiffVisualizer.TextDiffInfo)info);
                is = new ByteArrayInputStream(diffText.getBytes("utf8"));
            }
            while ((i = ((InputStream)is).read()) != -1) {
                out.write(i);
            }
        }
        finally {
            if (r1 != null) {
                try {
                    r1.close();
                }
                catch (Exception exception) {}
            }
            if (r2 != null) {
                try {
                    r2.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String exportBinaryFile(File file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder sb = new StringBuilder((int)file.length());
        if (file.canRead()) {
            Utils.copyStreamsCloseAll((OutputStream)baos, (InputStream)new FileInputStream(file));
        }
        sb.append("MIME: application/octet-stream; encoding: Base64; length: ").append(file.canRead() ? file.length() : -1L);
        sb.append(System.getProperty("line.separator"));
        sb.append(ExportDiffAction.encodeToWrappedBase64(baos.toByteArray()));
        sb.append(System.getProperty("line.separator"));
        return sb.toString();
    }

    static String encodeToWrappedBase64(byte[] data) {
        return Base64.getMimeEncoder(60, System.getProperty("line.separator").getBytes(StandardCharsets.ISO_8859_1)).encodeToString(data);
    }
}

