/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.customizer;

import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.ProjectTrust;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.customizer.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GradleExecutionPanel
extends JPanel {
    Project project;
    private JComboBox<TrustLevel> cbTrustLevel;
    private JLabel lbReadOnly;
    private JLabel lbTrustLevel;
    private JLabel lbTrustTerms;

    public GradleExecutionPanel() {
        this.initComponents();
        this.lbTrustTerms.setText(Bundle.GRADLE_TRUST_MSG());
    }

    public GradleExecutionPanel(Project project) {
        this();
        this.project = project;
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            this.lbReadOnly.setVisible(!gbp.isRoot());
            this.lbTrustLevel.setEnabled(gbp.isRoot());
            this.cbTrustLevel.setEnabled(gbp.isRoot());
            this.lbTrustTerms.setEnabled(gbp.isRoot());
            this.cbTrustLevel.setModel(new DefaultComboBoxModel<TrustLevel>(TrustLevel.values()));
            if (ProjectTrust.getDefault().isTrustedPermanently(project)) {
                this.cbTrustLevel.setSelectedItem((Object)TrustLevel.PERMANENT);
            } else if (ProjectTrust.getDefault().isTrusted(project)) {
                this.cbTrustLevel.setSelectedItem((Object)TrustLevel.TEMPORARY);
            } else {
                this.cbTrustLevel.setSelectedItem((Object)TrustLevel.NONE);
            }
        }
    }

    private void initComponents() {
        this.lbTrustTerms = new JLabel();
        this.lbReadOnly = new JLabel();
        this.cbTrustLevel = new JComboBox();
        this.lbTrustLevel = new JLabel();
        this.lbTrustTerms.setVerticalAlignment(1);
        this.lbReadOnly.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/gradle/resources/info.png")));
        Mnemonics.setLocalizedText((JLabel)this.lbReadOnly, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbReadOnly.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbTrustLevel, (String)NbBundle.getMessage(GradleExecutionPanel.class, (String)"GradleExecutionPanel.lbTrustLevel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbReadOnly).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbTrustLevel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbTrustLevel, 0, -1, Short.MAX_VALUE)).addComponent(this.lbTrustTerms, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbTrustLevel, -2, -1, -2).addComponent(this.lbTrustLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbTrustTerms, -2, 234, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addComponent(this.lbReadOnly).addContainerGap()));
    }

    void save() {
        if (this.project != null) {
            TrustLevel v = (TrustLevel)((Object)this.cbTrustLevel.getSelectedItem());
            if (v == null) {
                v = TrustLevel.NONE;
            }
            switch (v) {
                case NONE: {
                    ProjectTrust.getDefault().distrustProject(this.project);
                    break;
                }
                case PERMANENT: {
                    ProjectTrust.getDefault().trustProject(this.project, true);
                    break;
                }
                case TEMPORARY: {
                    if (ProjectTrust.getDefault().isTrustedPermanently(this.project)) {
                        ProjectTrust.getDefault().distrustProject(this.project);
                    }
                    ProjectTrust.getDefault().trustProject(this.project, false);
                }
            }
        }
    }

    static enum TrustLevel {
        PERMANENT,
        TEMPORARY,
        NONE;


        public String toString() {
            return NbBundle.getMessage(GradleExecutionPanel.class, (String)("GradleExecutionPanel.cbTrustLevel." + this.name()));
        }
    }
}

