/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.TestLauncher;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.spi.execute.GradleDistributionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class GradleProjectConnection
implements ProjectConnection {
    final Project project;
    ProjectConnection conn;
    ProjectConnection compatConn;
    final ChangeListener listener = e -> this.close();

    public GradleProjectConnection(Project project) {
        this.project = project;
    }

    public <T> T getModel(Class<T> type) throws GradleConnectionException, IllegalStateException {
        return (T)this.getConnection(true).getModel(type);
    }

    public <T> void getModel(Class<T> type, ResultHandler<? super T> rh) throws IllegalStateException {
        this.getConnection(true).getModel(type, rh);
    }

    public BuildLauncher newBuild() {
        return this.getConnection(false).newBuild();
    }

    public TestLauncher newTestLauncher() {
        return this.getConnection(false).newTestLauncher();
    }

    public <T> ModelBuilder<T> model(Class<T> type) {
        return this.getConnection(true).model(type);
    }

    public <T> BuildActionExecuter<T> action(BuildAction<T> action) {
        return this.getConnection(true).action(action);
    }

    public BuildActionExecuter.Builder action() {
        return this.getConnection(true).action();
    }

    public void notifyDaemonsAboutChangedPaths(List<Path> list) {
        this.getConnection(false).notifyDaemonsAboutChangedPaths(list);
    }

    public synchronized void close() {
        if (this.conn != null) {
            this.conn.close();
        }
        if (this.conn != this.compatConn) {
            this.compatConn.close();
        }
        this.conn = null;
        this.compatConn = null;
    }

    synchronized boolean hasConnection() {
        return this.conn != null || this.compatConn != null;
    }

    private synchronized ProjectConnection getConnection(boolean compatible) {
        if (this.conn == null) {
            File projectDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            GradleConnector gconn = GradleConnector.newConnector();
            GradleDistributionProvider pvd = (GradleDistributionProvider)this.project.getLookup().lookup(GradleDistributionProvider.class);
            if (pvd != null) {
                pvd.addChangeListener(WeakListeners.change((ChangeListener)this.listener, null));
                GradleDistributionManager.GradleDistribution dist = pvd.getGradleDistribution();
                if (dist != null) {
                    this.conn = GradleProjectConnection.createConnection(dist, projectDir);
                    if (dist.isCompatibleWithSystemJava()) {
                        this.compatConn = this.conn;
                    } else {
                        GradleDistributionManager.GradleDistribution compatDist = GradleDistributionManager.get(dist.getGradleUserHome()).defaultDistribution();
                        this.compatConn = GradleProjectConnection.createConnection(compatDist, projectDir);
                    }
                }
            }
            if (this.conn == null) {
                this.compatConn = this.conn = gconn.forProjectDirectory(projectDir).connect();
            }
        }
        return compatible ? this.compatConn : this.conn;
    }

    private static ProjectConnection createConnection(GradleDistributionManager.GradleDistribution dist, File projectDir) {
        GradleConnector gconn = GradleConnector.newConnector();
        gconn = gconn.useGradleUserHomeDir(dist.getGradleUserHome());
        gconn = dist.isAvailable() ? gconn.useInstallation(dist.getDistributionDir()) : gconn.useDistribution(dist.getDistributionURI());
        return gconn.forProjectDirectory(projectDir).connect();
    }
}

