/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.Diagnostic;
import org.netbeans.api.lsp.Hover;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.lsp.ResourceOperation;
import org.netbeans.api.lsp.TextDocumentEdit;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.lsp.WorkspaceEdit;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.java.editor.base.fold.JavaElementFoldVisitor;
import org.netbeans.modules.java.editor.base.semantic.MarkOccurrencesHighlighterBase;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.plugins.FileRenamePlugin;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.lsp.ErrorProvider;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Union2;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;

public class TextDocumentServiceImpl
implements TextDocumentService,
LanguageClientAware {
    private static final Logger LOG = Logger.getLogger(TextDocumentServiceImpl.class.getName());
    private static final String COMMAND_RUN_SINGLE = "java.run.single";
    private static final String COMMAND_DEBUG_SINGLE = "java.debug.single";
    private static final String NETBEANS_JAVADOC_LOAD_TIMEOUT = "netbeans.javadoc.load.timeout";
    private static final RequestProcessor BACKGROUND_TASKS = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private static final RequestProcessor WORKER = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private Map<String, Instant> knownFiles = new HashMap<String, Instant>();
    private final Map<String, RequestProcessor.Task> diagnosticTasks = new HashMap<String, RequestProcessor.Task>();
    private final LspServerState server;
    private NbCodeLanguageClient client;
    private final AtomicInteger javadocTimeout = new AtomicInteger(-1);
    private List<Completion> lastCompletions = null;
    private static final int DELAY = 500;
    private static final String[] ERROR_KEYS = new String[]{"errors", "hints"};
    static BiConsumer<String, Object> HOOK_NOTIFICATION = null;

    TextDocumentServiceImpl(LspServerState server) {
        this.server = server;
        ((RefreshDocument)Lookup.getDefault().lookup(RefreshDocument.class)).register(this);
    }

    private void reRunDiagnostics() {
        for (String doc : this.server.getOpenedDocuments().getUris()) {
            this.runDiagnosticTasks(doc);
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        this.lastCompletions = new ArrayList<Completion>();
        AtomicInteger index = new AtomicInteger(0);
        CompletionList completionList = new CompletionList();
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
        }
        try {
            String uri = params.getTextDocument().getUri();
            FileObject file = this.fromURI(uri);
            if (file == null) {
                return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            if (!(doc instanceof LineDocument)) {
                return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
            }
            ConfigurationItem conf = new ConfigurationItem();
            conf.setScopeUri(uri);
            conf.setSection(NETBEANS_JAVADOC_LOAD_TIMEOUT);
            return this.client.configuration(new ConfigurationParams(Collections.singletonList(conf))).thenApply(c -> {
                if (c != null && !c.isEmpty()) {
                    this.javadocTimeout.set(((JsonPrimitive)c.get(0)).getAsInt());
                }
                int caret = Utils.getOffset((LineDocument)doc, params.getPosition());
                ArrayList items = new ArrayList();
                Completion.Context context = params.getContext() != null ? new Completion.Context(Completion.TriggerKind.valueOf((String)params.getContext().getTriggerKind().name()), params.getContext().getTriggerCharacter() == null || params.getContext().getTriggerCharacter().isEmpty() ? null : Character.valueOf(params.getContext().getTriggerCharacter().charAt(0))) : null;
                Preferences prefs = CodeStylePreferences.get((Document)doc, (String)"text/x-java").getPreferences();
                String point = prefs.get("classMemberInsertionPoint", null);
                try {
                    prefs.put("classMemberInsertionPoint", CodeStyle.InsertionPoint.CARET_LOCATION.name());
                    boolean isComplete = Completion.collect((Document)doc, (int)caret, (Completion.Context)context, completion -> {
                        List additionalTextEdits;
                        TextEdit edit;
                        String documentation;
                        CompletionItem item = new CompletionItem(completion.getLabel());
                        if (completion.getKind() != null) {
                            item.setKind(CompletionItemKind.valueOf((String)completion.getKind().name()));
                        }
                        if (completion.getTags() != null) {
                            item.setTags(completion.getTags().stream().map(tag -> CompletionItemTag.valueOf((String)tag.name())).collect(Collectors.toList()));
                        }
                        if (completion.getDetail() != null && completion.getDetail().isDone()) {
                            item.setDetail((String)completion.getDetail().getNow(null));
                        }
                        if (completion.getDocumentation() != null && completion.getDocumentation().isDone() && (documentation = (String)completion.getDocumentation().getNow(null)) != null) {
                            MarkupContent markup = new MarkupContent();
                            markup.setKind("markdown");
                            markup.setValue(TextDocumentServiceImpl.html2MD(documentation));
                            item.setDocumentation(markup);
                        }
                        if (completion.isPreselect()) {
                            item.setPreselect(Boolean.valueOf(true));
                        }
                        item.setSortText(completion.getSortText());
                        item.setFilterText(completion.getFilterText());
                        item.setInsertText(completion.getInsertText());
                        if (completion.getInsertTextFormat() != null) {
                            item.setInsertTextFormat(InsertTextFormat.valueOf((String)completion.getInsertTextFormat().name()));
                        }
                        if ((edit = completion.getTextEdit()) != null) {
                            item.setTextEdit(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, edit.getStartOffset()), Utils.createPosition(file, edit.getEndOffset())), edit.getNewText()));
                        }
                        if (completion.getAdditionalTextEdits() != null && completion.getAdditionalTextEdits().isDone() && (additionalTextEdits = (List)completion.getAdditionalTextEdits().getNow(null)) != null && !additionalTextEdits.isEmpty()) {
                            item.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, ed.getStartOffset()), Utils.createPosition(file, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
                        }
                        if (completion.getCommitCharacters() != null) {
                            item.setCommitCharacters(completion.getCommitCharacters().stream().map(ch -> ch.toString()).collect(Collectors.toList()));
                        }
                        this.lastCompletions.add((Completion)completion);
                        item.setData((Object)new CompletionData(uri, index.getAndIncrement()));
                        items.add(item);
                    });
                    if (!isComplete) {
                        completionList.setIsIncomplete(true);
                    }
                }
                finally {
                    if (point != null) {
                        prefs.put("classMemberInsertionPoint", point);
                    } else {
                        prefs.remove("classMemberInsertionPoint");
                    }
                }
                completionList.setItems(items);
                return Either.forRight((Object)completionList);
            });
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem ci) {
        JsonObject rawData = (JsonObject)ci.getData();
        if (rawData != null) {
            FileObject file;
            CompletionData data = (CompletionData)new Gson().fromJson((JsonElement)rawData, CompletionData.class);
            Completion completion = this.lastCompletions.get(data.index);
            if (completion != null && (file = this.fromURI(data.uri)) != null) {
                CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
                WORKER.post(() -> {
                    if (completion.getDetail() != null) {
                        try {
                            String detail = (String)completion.getDetail().get();
                            if (detail != null) {
                                ci.setDetail(detail);
                            }
                        }
                        catch (Exception detail) {
                            // empty catch block
                        }
                    }
                    if (completion.getAdditionalTextEdits() != null) {
                        try {
                            List additionalTextEdits = (List)completion.getAdditionalTextEdits().get();
                            if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
                                ci.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, ed.getStartOffset()), Utils.createPosition(file, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
                            }
                        }
                        catch (Exception additionalTextEdits) {
                            // empty catch block
                        }
                    }
                    if (completion.getDocumentation() != null) {
                        try {
                            String documentation;
                            int timeout = this.javadocTimeout.get();
                            String string = timeout < 0 ? (String)completion.getDocumentation().get() : (documentation = timeout == 0 ? (String)completion.getDocumentation().getNow(null) : (String)completion.getDocumentation().get(timeout, TimeUnit.MILLISECONDS));
                            if (documentation != null) {
                                MarkupContent markup = new MarkupContent();
                                markup.setKind("markdown");
                                markup.setValue(TextDocumentServiceImpl.html2MD(documentation));
                                ci.setDocumentation(markup);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result.complete(ci);
                });
                return result;
            }
        }
        return CompletableFuture.completedFuture(ci);
    }

    public static String html2MD(String html) {
        int idx = html.indexOf("<p id=\"not-found\">");
        return FlexmarkHtmlConverter.builder().build().convert(idx >= 0 ? html.substring(0, idx) : html).replaceAll("<br />[ \n]*$", "");
    }

    public CompletableFuture<org.eclipse.lsp4j.Hover> hover(HoverParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(null);
        }
        String uri = params.getTextDocument().getUri();
        FileObject file = this.fromURI(uri);
        Document doc = this.server.getOpenedDocuments().getDocument(uri);
        if (file == null || !(doc instanceof LineDocument)) {
            return CompletableFuture.completedFuture(null);
        }
        return Hover.getContent((Document)doc, (int)Utils.getOffset((LineDocument)doc, params.getPosition())).thenApply(content -> {
            if (content != null) {
                MarkupContent markup = new MarkupContent();
                markup.setKind("markdown");
                markup.setValue(TextDocumentServiceImpl.html2MD(content));
                return new org.eclipse.lsp4j.Hover(markup);
            }
            return null;
        });
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        try {
            FileObject file;
            String uri = params.getTextDocument().getUri();
            Document doc = this.server.getOpenedDocuments().getDocument(uri);
            if (doc instanceof LineDocument && (file = Utils.fromUri(uri)) != null) {
                int offset = Utils.getOffset((LineDocument)doc, params.getPosition());
                return HyperlinkLocation.resolve((Document)doc, (int)offset).thenApply(locs -> Either.forLeft(locs.stream().map(location -> {
                    FileObject fo = location.getFileObject();
                    return new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, location.getStartOffset()), Utils.createPosition(fo, location.getEndOffset())));
                }).collect(Collectors.toList())));
            }
        }
        catch (MalformedURLException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams params) {
        try {
            FileObject file;
            String uri = params.getTextDocument().getUri();
            Document doc = this.server.getOpenedDocuments().getDocument(uri);
            if (doc instanceof LineDocument && (file = Utils.fromUri(uri)) != null) {
                int offset = Utils.getOffset((LineDocument)doc, params.getPosition());
                return HyperlinkLocation.resolveTypeDefinition((Document)doc, (int)offset).thenApply(locs -> Either.forLeft(locs.stream().map(location -> {
                    FileObject fo = location.getFileObject();
                    return new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, location.getStartOffset()), Utils.createPosition(fo, location.getEndOffset())));
                }).collect(Collectors.toList())));
            }
        }
        catch (MalformedURLException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams params) {
        return this.usages(params.getTextDocument().getUri(), params.getPosition(), true, false).thenApply(locations -> Either.forLeft((Object)locations));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        return this.usages(params.getTextDocument().getUri(), params.getPosition(), false, params.getContext().isIncludeDeclaration());
    }

    private CompletableFuture<List<? extends Location>> usages(String uri, Position position, boolean implementations, boolean includeDeclaration) {
        Project[] projects = this.server.openedProjects().getNow(null);
        if (projects == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<List<? extends Location>> result = new CompletableFuture<List<? extends Location>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getJavaSource(uri);
            if (js == null) {
                result.complete(new ArrayList());
                return;
            }
            try {
                WhereUsedQuery[] query = new WhereUsedQuery[1];
                ArrayList<Location> locations = new ArrayList<Location>();
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    if (doc instanceof LineDocument) {
                        Element decl;
                        TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset((LineDocument)doc, position));
                        query[0] = new WhereUsedQuery(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                        if (implementations) {
                            query[0].putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)true);
                            query[0].putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)true);
                            query[0].putValue((Object)"FIND_REFERENCES", (Object)false);
                        } else if (includeDeclaration && (decl = cc.getTrees().getElement(path)) != null) {
                            TreePath declPath = cc.getTrees().getPath(decl);
                            if (declPath != null && cc.getCompilationUnit() == declPath.getCompilationUnit()) {
                                Range range = TextDocumentServiceImpl.declarationRange((CompilationInfo)cc, declPath);
                                if (range != null) {
                                    locations.add(new Location(Utils.toUri(cc.getFileObject()), range));
                                }
                            } else {
                                JavaSource source;
                                ElementHandle declHandle = ElementHandle.create((Element)decl);
                                FileObject sourceFile = SourceUtils.getFile((ElementHandle)declHandle, (ClasspathInfo)cc.getClasspathInfo());
                                JavaSource javaSource = source = sourceFile != null ? JavaSource.forFileObject((FileObject)sourceFile) : null;
                                if (source != null) {
                                    source.runUserActionTask(nestedCC -> {
                                        Range range;
                                        TreePath declPath2;
                                        nestedCC.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                        Element declHandle2 = declHandle.resolve((CompilationInfo)nestedCC);
                                        TreePath treePath = declPath2 = declHandle2 != null ? nestedCC.getTrees().getPath(declHandle2) : null;
                                        if (declPath2 != null && (range = TextDocumentServiceImpl.declarationRange((CompilationInfo)nestedCC, declPath2)) != null) {
                                            locations.add(new Location(Utils.toUri(nestedCC.getFileObject()), range));
                                        }
                                    }, true);
                                }
                            }
                        }
                    }
                }, true);
                if (cancel.get()) {
                    return;
                }
                ArrayList<FileObject> sourceRoots = new ArrayList<FileObject>();
                for (Project project : projects) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
                        sourceRoots.add(sourceGroup.getRootFolder());
                    }
                }
                if (!sourceRoots.isEmpty()) {
                    query[0].getContext().add((Object)Scope.create(sourceRoots, null, null, (boolean)true));
                }
                cancelCallback[0] = () -> query[0].cancelRequest();
                RefactoringSession refactoring = RefactoringSession.create((String)"FindUsages");
                Problem p = query[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = query[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = query[0].prepare(refactoring);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                for (RefactoringElement re : refactoring.getRefactoringElements()) {
                    if (cancel.get()) {
                        return;
                    }
                    FileObject parentFile = re.getParentFile();
                    if (!parentFile.isData()) continue;
                    locations.add(new Location(Utils.toUri(parentFile), TextDocumentServiceImpl.toRange(re.getPosition())));
                }
                refactoring.finished();
                result.complete(locations);
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    private static Range declarationRange(CompilationInfo info, TreePath tp) {
        int[] span;
        Tree t = tp.getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
            span = info.getTreeUtilities().findNameSpan((ClassTree)t);
        } else if (t.getKind() == Tree.Kind.VARIABLE) {
            span = info.getTreeUtilities().findNameSpan((VariableTree)t);
        } else if (t.getKind() == Tree.Kind.METHOD) {
            span = info.getTreeUtilities().findNameSpan((MethodTree)t);
            if (span == null) {
                span = info.getTreeUtilities().findNameSpan((ClassTree)tp.getParentPath().getLeaf());
            }
        } else {
            return null;
        }
        if (span == null) {
            return null;
        }
        return new Range(Utils.createPosition(info.getCompilationUnit().getLineMap(), span[0]), Utils.createPosition(info.getCompilationUnit().getLineMap(), span[1]));
    }

    private static Range toRange(PositionBounds bounds) throws IOException {
        return bounds != null ? new Range(new Position(bounds.getBegin().getLine(), bounds.getBegin().getColumn()), new Position(bounds.getEnd().getLine(), bounds.getEnd().getColumn())) : new Range(new Position(0, 0), new Position(0, 0));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        if (js == null) {
            return CompletableFuture.completedFuture(result);
        }
        try {
            js.runUserActionTask(cc -> {
                int offset;
                List<int[]> spans;
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                class MOHighligther
                extends MarkOccurrencesHighlighterBase {
                    MOHighligther() {
                    }

                    protected void process(CompilationInfo arg0, Document arg1, SchedulerEvent arg2) {
                        throw new UnsupportedOperationException("Should not be called.");
                    }

                    public List<int[]> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
                        return super.processImpl(info, node, doc, caretPosition);
                    }
                }
                if (doc instanceof LineDocument && (spans = new MOHighligther().processImpl((CompilationInfo)cc, node, doc, offset = Utils.getOffset((LineDocument)doc, params.getPosition()))) != null) {
                    for (int[] span : spans) {
                        result.add(new DocumentHighlight(new Range(Utils.createPosition(cc.getCompilationUnit(), span[0]), Utils.createPosition(cc.getCompilationUnit(), span[1]))));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
        if (js == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (Element tel : cc.getTopLevelElements()) {
                    DocumentSymbol ds = this.element2DocumentSymbol((CompilationInfo)cc, tel);
                    if (ds == null) continue;
                    result.add(Either.forRight((Object)ds));
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private DocumentSymbol element2DocumentSymbol(CompilationInfo info, Element el) throws BadLocationException {
        TreePath path = info.getTrees().getPath(el);
        if (path == null) {
            return null;
        }
        Range range = Utils.treeRange(info, path.getLeaf());
        if (range == null) {
            return null;
        }
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        for (Element element : el.getEnclosedElements()) {
            DocumentSymbol ds = this.element2DocumentSymbol(info, element);
            if (ds == null) continue;
            children.add(ds);
        }
        String simpleName = el.getKind() == ElementKind.CONSTRUCTOR ? el.getEnclosingElement().getSimpleName().toString() : el.getSimpleName().toString();
        return new DocumentSymbol(simpleName, Utils.elementKind2SymbolKind(el.getKind()), range, range, null, children);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(final CodeActionParams params) {
        int endOffset;
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Document doc = this.server.getOpenedDocuments().getDocument(params.getTextDocument().getUri());
        if (!(doc instanceof LineDocument)) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        final ArrayList<Either> result = new ArrayList<Either>();
        final Range range = params.getRange();
        final int startOffset = Utils.getOffset((LineDocument)doc, range.getStart());
        if (startOffset == (endOffset = Utils.getOffset((LineDocument)doc, range.getEnd()))) {
            int lineEndOffset;
            int lineStartOffset = LineDocumentUtils.getLineStart((LineDocument)((LineDocument)doc), (int)startOffset);
            try {
                lineEndOffset = LineDocumentUtils.getLineEnd((LineDocument)((LineDocument)doc), (int)endOffset);
            }
            catch (BadLocationException ex2) {
                lineEndOffset = endOffset;
            }
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(params.getContext().getDiagnostics());
            diagnostics.addAll(this.computeDiags(params.getTextDocument().getUri(), startOffset, ErrorProvider.Kind.HINTS, TextDocumentServiceImpl.documentVersion(doc)));
            Map id2Errors = (Map)doc.getProperty("lsp-errors");
            if (id2Errors != null) {
                for (Map.Entry entry : id2Errors.entrySet()) {
                    org.netbeans.api.lsp.Diagnostic err = (org.netbeans.api.lsp.Diagnostic)entry.getValue();
                    if (err.getSeverity() == Diagnostic.Severity.Error ? err.getEndPosition().getOffset() < startOffset || err.getStartPosition().getOffset() > endOffset : err.getEndPosition().getOffset() < lineStartOffset || err.getStartPosition().getOffset() > lineEndOffset) continue;
                    Optional<Diagnostic> diag = diagnostics.stream().filter(d -> ((String)entry.getKey()).equals(d.getCode().getLeft())).findFirst();
                    Diagnostic.LazyCodeActions actions = err.getActions();
                    if (actions == null) continue;
                    for (org.netbeans.api.lsp.CodeAction inputAction : actions.computeCodeActions(ex -> this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage())))) {
                        CodeAction action = new CodeAction(inputAction.getTitle());
                        if (diag.isPresent()) {
                            action.setDiagnostics(Collections.singletonList(diag.get()));
                        }
                        action.setKind(this.kind(err.getSeverity()));
                        if (inputAction.getCommand() != null) {
                            action.setCommand(new Command(inputAction.getCommand().getTitle(), inputAction.getCommand().getCommand()));
                        }
                        if (inputAction.getEdit() != null) {
                            WorkspaceEdit edit = inputAction.getEdit();
                            ArrayList<Either> documentChanges = new ArrayList<Either>();
                            for (Union2 parts : edit.getDocumentChanges()) {
                                if (parts.hasFirst()) {
                                    String docUri = ((TextDocumentEdit)parts.first()).getDocument();
                                    try {
                                        FileObject fo;
                                        FileObject file = Utils.fromUri(docUri);
                                        if (file == null) {
                                            file = Utils.fromUri(params.getTextDocument().getUri());
                                        }
                                        if ((fo = file) == null) continue;
                                        List edits = ((TextDocumentEdit)parts.first()).getEdits().stream().map(te -> new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(fo, te.getStartOffset()), Utils.createPosition(fo, te.getEndOffset())), te.getNewText())).collect(Collectors.toList());
                                        org.eclipse.lsp4j.TextDocumentEdit tde = new org.eclipse.lsp4j.TextDocumentEdit(new VersionedTextDocumentIdentifier(docUri, Integer.valueOf(-1)), edits);
                                        documentChanges.add(Either.forLeft((Object)tde));
                                    }
                                    catch (Exception ex3) {
                                        this.client.logMessage(new MessageParams(MessageType.Error, ex3.getMessage()));
                                    }
                                    continue;
                                }
                                if (parts.second() instanceof ResourceOperation.CreateFile) {
                                    documentChanges.add(Either.forRight((Object)new CreateFile(((ResourceOperation.CreateFile)parts.second()).getNewFile())));
                                    continue;
                                }
                                throw new IllegalStateException(String.valueOf(parts.second()));
                            }
                            action.setEdit(new org.eclipse.lsp4j.WorkspaceEdit(documentChanges));
                        }
                        result.add(Either.forRight((Object)action));
                    }
                }
            }
        }
        CompletableFuture<List<Either<Command, CodeAction>>> resultFuture = new CompletableFuture<List<Either<Command, CodeAction>>>();
        Source source = Source.create((Document)doc);
        BACKGROUND_TASKS.post(() -> {
            try {
                ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        for (CodeActionsProvider codeGenerator : Lookup.getDefault().lookupAll(CodeActionsProvider.class)) {
                            try {
                                for (CodeAction codeAction : codeGenerator.getCodeActions(resultIterator, params)) {
                                    result.add(Either.forRight((Object)codeAction));
                                }
                            }
                            catch (Exception ex) {
                                TextDocumentServiceImpl.this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                            }
                        }
                        CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult());
                        if (cc != null) {
                            cc.toPhase(JavaSource.Phase.RESOLVED);
                            if (!range.getStart().equals((Object)range.getEnd())) {
                                for (ErrorDescription err : IntroduceHint.computeError((CompilationInfo)cc, (int)startOffset, (int)endOffset, new EnumMap(IntroduceKind.class), new EnumMap(IntroduceKind.class), (AtomicBoolean)new AtomicBoolean())) {
                                    for (Fix fix : err.getFixes().getFixes()) {
                                        if (!(fix instanceof IntroduceFixBase)) continue;
                                        try {
                                            org.netbeans.api.java.source.ModificationResult changes = ((IntroduceFixBase)fix).getModificationResult();
                                            if (changes == null) continue;
                                            ArrayList<Either> documentChanges = new ArrayList<Either>();
                                            Set fos = changes.getModifiedFileObjects();
                                            if (fos.size() != 1) continue;
                                            FileObject fileObject = (FileObject)fos.iterator().next();
                                            List diffs = changes.getDifferences(fileObject);
                                            if (diffs != null) {
                                                ArrayList<org.eclipse.lsp4j.TextEdit> edits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
                                                for (ModificationResult.Difference diff : diffs) {
                                                    String newText = diff.getNewText();
                                                    edits.add(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                                                }
                                                documentChanges.add(Either.forLeft((Object)new org.eclipse.lsp4j.TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                                            }
                                            CodeAction codeAction = new CodeAction(fix.getText());
                                            codeAction.setKind("refactor.extract");
                                            codeAction.setEdit(new org.eclipse.lsp4j.WorkspaceEdit(documentChanges));
                                            int renameOffset = ((IntroduceFixBase)fix).getNameOffset(changes);
                                            if (renameOffset >= 0) {
                                                codeAction.setCommand(new Command("Rename", "java.rename.element.at", Collections.singletonList(renameOffset)));
                                            }
                                            result.add(Either.forRight((Object)codeAction));
                                        }
                                        catch (GeneratorUtils.DuplicateMemberException duplicateMemberException) {}
                                    }
                                }
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            finally {
                resultFuture.complete(result);
            }
        });
        return resultFuture;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(final CodeLensParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        String uri = params.getTextDocument().getUri();
        final Source source = this.getSource(uri);
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        final CompletableFuture<List<? extends CodeLens>> result = new CompletableFuture<List<? extends CodeLens>>();
        try {
            ParserManager.parseWhenScanFinished(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parserResult = resultIterator.getParserResult();
                    final ArrayList lens = new ArrayList();
                    final CompilationController cc = CompilationController.get((Parser.Result)parserResult);
                    if (cc != null) {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        final AtomicReference projectConfigurations = new AtomicReference();
                        new TreePathScanner<Void, Void>(){

                            @Override
                            public Void visitMethod(MethodTree tree, Void p) {
                                Element el = cc.getTrees().getElement(this.getCurrentPath());
                                if (el != null && el.getKind() == ElementKind.METHOD && SourceUtils.isMainMethod((ExecutableElement)((ExecutableElement)el))) {
                                    Range range = Utils.treeRange((CompilationInfo)cc, tree);
                                    List<String> arguments = Collections.singletonList(params.getTextDocument().getUri());
                                    String method = el.getSimpleName().toString();
                                    lens.add(new CodeLens(range, new Command(Bundle.LBL_Run(method), TextDocumentServiceImpl.COMMAND_RUN_SINGLE, arguments), null));
                                    lens.add(new CodeLens(range, new Command(Bundle.LBL_Debug(method), TextDocumentServiceImpl.COMMAND_DEBUG_SINGLE, arguments), null));
                                    List configs = projectConfigurations.accumulateAndGet(null, (l, nul) -> l == null ? TextDocumentServiceImpl.this.getProjectConfigurations(source) : l);
                                    for (Pair config : configs) {
                                        String debugConfig;
                                        String runConfig = (String)config.first();
                                        if (runConfig != null) {
                                            lens.add(new CodeLens(range, new Command(Bundle.LBL_RunWith(method, runConfig), TextDocumentServiceImpl.COMMAND_RUN_SINGLE, Arrays.asList(params.getTextDocument().getUri(), null, runConfig)), null));
                                        }
                                        if ((debugConfig = (String)config.second()) == null) continue;
                                        lens.add(new CodeLens(range, new Command(Bundle.LBL_DebugWith(method, debugConfig), TextDocumentServiceImpl.COMMAND_DEBUG_SINGLE, Arrays.asList(params.getTextDocument().getUri(), null, debugConfig)), null));
                                    }
                                }
                                return null;
                            }
                        }.scan(cc.getCompilationUnit(), null);
                    }
                    result.complete(lens);
                }
            });
        }
        catch (ParseException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    private List<Pair<String, String>> getProjectConfigurations(Source source) {
        FileObject fo = source.getFileObject();
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        if (p != null) {
            ProjectConfigurationProvider configProvider = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
            ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
            ArrayList<Pair<String, String>> configDispNames = new ArrayList<Pair<String, String>>();
            if (configProvider != null && actionProvider != null) {
                boolean skippedFirst = false;
                for (ProjectConfiguration configuration : configProvider.getConfigurations()) {
                    if (skippedFirst) {
                        String runConfig = null;
                        String debugConfig = null;
                        Lookup configLookup = Lookups.fixed((Object[])new Object[]{fo, configuration});
                        if (TextDocumentServiceImpl.isConfigurationAction((ProjectConfigurationProvider<ProjectConfiguration>)configProvider, actionProvider, configLookup, "run.single")) {
                            runConfig = configuration.getDisplayName();
                        }
                        if (TextDocumentServiceImpl.isConfigurationAction((ProjectConfigurationProvider<ProjectConfiguration>)configProvider, actionProvider, configLookup, "debug.single")) {
                            debugConfig = configuration.getDisplayName();
                        }
                        if (runConfig == null && debugConfig == null) continue;
                        configDispNames.add((Pair<String, String>)Pair.of((Object)runConfig, (Object)debugConfig));
                        continue;
                    }
                    skippedFirst = true;
                }
            }
            return configDispNames;
        }
        return Collections.emptyList();
    }

    private static boolean isConfigurationAction(ProjectConfigurationProvider<ProjectConfiguration> configProvider, ActionProvider actionProvider, Lookup configLookup, String action) {
        return configProvider.configurationsAffectAction(action) && actionProvider.isActionEnabled(action, configLookup);
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> formatting(DocumentFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> rangeFormatting(DocumentRangeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<Range, PrepareRenameResult>> prepareRename(PrepareRenameParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(null);
        }
        JavaSource source = this.getJavaSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Either<Range, PrepareRenameResult>> result = new CompletableFuture<Either<Range, PrepareRenameResult>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                if (!(doc instanceof LineDocument)) {
                    result.complete(null);
                }
                int pos = Utils.getOffset((LineDocument)doc, params.getPosition());
                TreePath path = cc.getTreeUtilities().pathFor(pos);
                RenameRefactoring ref = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                ref.setNewName("any");
                boolean hasFatalProblem = false;
                for (Problem p = ref.fastCheckParameters(); p != null; p = p.getNext()) {
                    hasFatalProblem |= p.isFatal();
                }
                if (hasFatalProblem) {
                    result.complete(null);
                } else {
                    TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    int d = ts.move(pos);
                    if (ts.moveNext()) {
                        if (d == 0 && ts.token().id() != JavaTokenId.IDENTIFIER) {
                            ts.movePrevious();
                        }
                        Range r = new Range(Utils.createPosition(cc.getCompilationUnit(), ts.offset()), Utils.createPosition(cc.getCompilationUnit(), ts.offset() + ts.token().length()));
                        result.complete(Either.forRight((Object)new PrepareRenameResult(r, ts.token().text().toString())));
                    } else {
                        result.complete(null);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public CompletableFuture<org.eclipse.lsp4j.WorkspaceEdit> rename(RenameParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(new org.eclipse.lsp4j.WorkspaceEdit());
        }
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<org.eclipse.lsp4j.WorkspaceEdit> result = new CompletableFuture<org.eclipse.lsp4j.WorkspaceEdit>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
            if (js == null) {
                result.completeExceptionally(new FileNotFoundException(params.getTextDocument().getUri()));
                return;
            }
            try {
                RenameRefactoring[] refactoring = new RenameRefactoring[1];
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    if (doc instanceof LineDocument) {
                        ElementHandle handle;
                        FileObject f;
                        TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset((LineDocument)doc, params.getPosition()));
                        ArrayList<Object> lookupContent = new ArrayList<Object>();
                        lookupContent.add(TreePathHandle.create((TreePath)path, (CompilationInfo)cc));
                        Element selected = cc.getTrees().getElement(path);
                        if (selected instanceof TypeElement && !((TypeElement)selected).getNestingKind().isNested() && (f = SourceUtils.getFile((ElementHandle)(handle = ElementHandle.create((Element)((TypeElement)selected))), (ClasspathInfo)cc.getClasspathInfo())) != null && selected.getSimpleName().toString().equals(f.getName())) {
                            lookupContent.add(f);
                        }
                        refactoring[0] = new RenameRefactoring(Lookups.fixed((Object[])lookupContent.toArray(new Object[0])));
                        refactoring[0].setNewName(params.getNewName());
                        refactoring[0].setSearchInComments(true);
                    }
                }, true);
                if (cancel.get()) {
                    return;
                }
                cancelCallback[0] = () -> refactoring[0].cancelRequest();
                RefactoringSession session = RefactoringSession.create((String)"Rename");
                Problem p = refactoring[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = refactoring[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = refactoring[0].prepare(session);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                ArrayList<Either> resultChanges = new ArrayList<Either>();
                List transactions = APIAccessor.DEFAULT.getCommits(session);
                ArrayList<org.netbeans.api.java.source.ModificationResult> results = new ArrayList<org.netbeans.api.java.source.ModificationResult>();
                for (Transaction t : transactions) {
                    if (t instanceof RefactoringCommit) {
                        RefactoringCommit c = (RefactoringCommit)t;
                        for (ModificationResult refResult : SPIAccessor.DEFAULT.getTransactions(c)) {
                            if (refResult instanceof JavaModificationResult) {
                                results.add(((JavaModificationResult)refResult).delegate);
                                continue;
                            }
                            throw new IllegalStateException(refResult.getClass().toString());
                        }
                        continue;
                    }
                    throw new IllegalStateException(t.getClass().toString());
                }
                for (org.netbeans.api.java.source.ModificationResult mr : results) {
                    for (FileObject modified : mr.getModifiedFileObjects()) {
                        resultChanges.add(Either.forLeft((Object)new org.eclipse.lsp4j.TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(modified), Integer.valueOf(-1)), TextDocumentServiceImpl.fileModifications(mr, modified, null))));
                    }
                }
                List fileChanges = APIAccessor.DEFAULT.getFileChanges(session);
                for (RefactoringElementImplementation rei : fileChanges) {
                    if (rei instanceof FileRenamePlugin.RenameFile) {
                        String oldURI = params.getTextDocument().getUri();
                        int dot = oldURI.lastIndexOf(46);
                        int slash = oldURI.lastIndexOf(47);
                        String newURI = oldURI.substring(0, slash + 1) + params.getNewName() + oldURI.substring(dot);
                        RenameFile op = new RenameFile(oldURI, newURI);
                        resultChanges.add(Either.forRight((Object)op));
                        continue;
                    }
                    throw new IllegalStateException(rei.getClass().toString());
                }
                for (RefactoringElement refactoringElement : session.getRefactoringElements()) {
                }
                session.finished();
                result.complete(new org.eclipse.lsp4j.WorkspaceEdit(resultChanges));
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        JavaSource source = this.getJavaSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<FoldingRange>> result = new CompletableFuture<List<FoldingRange>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                JavaElementFoldVisitor v = new JavaElementFoldVisitor((CompilationInfo)cc, cc.getCompilationUnit(), cc.getTrees().getSourcePositions(), doc, (JavaElementFoldVisitor.FoldCreator)new JavaElementFoldVisitor.FoldCreator<FoldingRange>(){

                    public FoldingRange createImportsFold(int start, int end) {
                        return this.createFold(start, end, "imports");
                    }

                    public FoldingRange createInnerClassFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createCodeBlockFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createJavadocFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    public FoldingRange createInitialCommentFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    private FoldingRange createFold(int start, int end, String kind) {
                        Position startPos = Utils.createPosition(cc.getCompilationUnit(), start);
                        Position endPos = Utils.createPosition(cc.getCompilationUnit(), end);
                        FoldingRange range = new FoldingRange(startPos.getLine(), endPos.getLine());
                        range.setStartCharacter(Integer.valueOf(startPos.getCharacter()));
                        range.setEndCharacter(Integer.valueOf(endPos.getCharacter()));
                        range.setKind(kind);
                        return range;
                    }
                });
                v.checkInitialFold();
                v.scan((Tree)cc.getCompilationUnit(), null);
                result.complete(v.getFolds());
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        try {
            FileObject file = this.fromURI(params.getTextDocument().getUri(), true);
            if (file == null) {
                return;
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.getDocument();
            String text = params.getTextDocument().getText();
            try {
                if (doc == null) {
                    doc = ec.openDocument();
                }
                if (!text.contentEquals(doc.getText(0, doc.getLength()))) {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, text, null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            this.server.getOpenedDocuments().notifyOpened(params.getTextDocument().getUri(), doc);
            this.server.asyncOpenFileOwner(file).thenRun(() -> this.runDiagnosticTasks(params.getTextDocument().getUri()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didOpen", params);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        Document doc = this.server.getOpenedDocuments().getDocument(uri);
        if (doc != null) {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
                    try {
                        int start = Utils.getOffset((LineDocument)doc, change.getRange().getStart());
                        int end = Utils.getOffset((LineDocument)doc, change.getRange().getEnd());
                        doc.remove(start, end - start);
                        doc.insertString(start, change.getText(), null);
                    }
                    catch (BadLocationException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
        }
        this.runDiagnosticTasks(params.getTextDocument().getUri());
        TextDocumentServiceImpl.reportNotificationDone("didChange", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didClose(DidCloseTextDocumentParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            this.server.getOpenedDocuments().notifyClosed(uri);
            FileObject file = this.fromURI(uri, true);
            if (file == null) {
                return;
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            ec.close();
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didClose", params);
        }
    }

    public void didSave(DidSaveTextDocumentParams arg0) {
    }

    CompletableFuture<List<? extends Location>> superImplementations(String uri, Position position) {
        JavaSource js = this.getJavaSource(uri);
        ArrayList targets = new ArrayList();
        LineMap[] thisFileLineMap = new LineMap[1];
        try {
            if (js != null) {
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    if (doc instanceof LineDocument) {
                        Trees trees;
                        Element resolved;
                        int offset = Utils.getOffset((LineDocument)doc, position);
                        TreeUtilities treeUtilities = cc.getTreeUtilities();
                        TreePath path = treeUtilities.getPathElementOfKind(EnumSet.of(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.METHOD), treeUtilities.pathFor(offset));
                        if (path != null && (resolved = (trees = cc.getTrees()).getElement(path)) != null) {
                            if (resolved.getKind() == ElementKind.METHOD) {
                                Map overriding = new ComputeOverriding(new AtomicBoolean()).process((CompilationInfo)cc);
                                List eds = (List)overriding.get(ElementHandle.create((Element)resolved));
                                if (eds != null) {
                                    for (ElementDescription ed : eds) {
                                        long startPos;
                                        Element el = ed.getHandle().resolve((CompilationInfo)cc);
                                        TreePath tp = trees.getPath(el);
                                        long l = startPos = tp != null && cc.getCompilationUnit() == tp.getCompilationUnit() ? trees.getSourcePositions().getStartPosition(cc.getCompilationUnit(), tp.getLeaf()) : -1L;
                                        if (startPos >= 0L) {
                                            long endPos = trees.getSourcePositions().getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                                            targets.add(new GoToSupport.GoToTarget(cc.getSnapshot().getOriginalOffset((int)startPos), cc.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan((Tree)tp.getLeaf(), (TreeUtilities)treeUtilities), null, null, null, ed.getDisplayName(), true));
                                            continue;
                                        }
                                        TypeElement te = el != null ? cc.getElementUtilities().outermostTypeElement(el) : null;
                                        targets.add(new GoToSupport.GoToTarget(-1, -1, null, ed.getOriginalCPInfo(), ed.getHandle(), TextDocumentServiceImpl.getResourceName(te, ed.getHandle()), ed.getDisplayName(), true));
                                    }
                                }
                            } else if (resolved.getKind().isClass() || resolved.getKind().isInterface()) {
                                ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
                                superTypes.add(((TypeElement)resolved).getSuperclass());
                                superTypes.addAll(((TypeElement)resolved).getInterfaces());
                                for (TypeMirror typeMirror : superTypes) {
                                    long startPos;
                                    if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                                    Element el = ((DeclaredType)typeMirror).asElement();
                                    TreePath tp = trees.getPath(el);
                                    long l = startPos = tp != null && cc.getCompilationUnit() == tp.getCompilationUnit() ? trees.getSourcePositions().getStartPosition(cc.getCompilationUnit(), tp.getLeaf()) : -1L;
                                    if (startPos >= 0L) {
                                        long endPos = trees.getSourcePositions().getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                                        targets.add(new GoToSupport.GoToTarget(cc.getSnapshot().getOriginalOffset((int)startPos), cc.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan((Tree)tp.getLeaf(), (TreeUtilities)treeUtilities), null, null, null, cc.getElementUtilities().getElementName(el, false).toString(), true));
                                        continue;
                                    }
                                    TypeElement te = el != null ? cc.getElementUtilities().outermostTypeElement(el) : null;
                                    targets.add(new GoToSupport.GoToTarget(-1, -1, null, cc.getClasspathInfo(), ElementHandle.create((Element)el), TextDocumentServiceImpl.getResourceName(te, null), cc.getElementUtilities().getElementName(el, false).toString(), true));
                                }
                            }
                            thisFileLineMap[0] = cc.getCompilationUnit().getLineMap();
                        }
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        CompletableFuture[] futures = (CompletableFuture[])targets.stream().map(target -> this.gotoTarget2Location(uri, (GoToSupport.GoToTarget)target, thisFileLineMap[0])).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(value -> {
            ArrayList<Location> locations = new ArrayList<Location>(futures.length);
            for (CompletableFuture future : futures) {
                Location location = future.getNow(null);
                if (location == null) continue;
                locations.add(location);
            }
            return locations;
        });
    }

    private CompletableFuture<Location> gotoTarget2Location(String uri, GoToSupport.GoToTarget target, LineMap lineMap) {
        Location location = null;
        if (target != null && target.success) {
            if (target.offsetToOpen < 0) {
                CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)target.cpInfo, (ElementHandle)target.elementToOpen, (String)target.resourceName);
                return future.thenApply(loc -> {
                    if (loc != null) {
                        FileObject fo = loc.getFileObject();
                        return new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, loc.getStartOffset()), Utils.createPosition(fo, loc.getEndOffset())));
                    }
                    return null;
                });
            }
            int start = target.nameSpan != null ? target.nameSpan[0] : target.offsetToOpen;
            int end = target.nameSpan != null ? target.nameSpan[1] : target.endPos;
            location = new Location(uri, new Range(Utils.createPosition(lineMap, start), Utils.createPosition(lineMap, end)));
        }
        return CompletableFuture.completedFuture(location);
    }

    private void runDiagnosticTasks(String uri) {
        if (this.server.openedProjects().getNow(null) == null) {
            return;
        }
        this.diagnosticTasks.computeIfAbsent(uri, u -> BACKGROUND_TASKS.create(() -> {
            Document originalDoc = this.server.getOpenedDocuments().getDocument(uri);
            long originalVersion = TextDocumentServiceImpl.documentVersion(originalDoc);
            List<Diagnostic> errorDiags = this.computeDiags((String)u, -1, ErrorProvider.Kind.ERRORS, originalVersion);
            if (TextDocumentServiceImpl.documentVersion(originalDoc) == originalVersion) {
                this.publishDiagnostics(uri, errorDiags);
                BACKGROUND_TASKS.create(() -> {
                    List<Diagnostic> hintDiags = this.computeDiags((String)u, -1, ErrorProvider.Kind.HINTS, originalVersion);
                    Document doc = this.server.getOpenedDocuments().getDocument(uri);
                    if (TextDocumentServiceImpl.documentVersion(doc) == originalVersion) {
                        this.publishDiagnostics(uri, hintDiags);
                    }
                }).schedule(500);
            }
        })).schedule(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Diagnostic> computeDiags(String uri, int offset, ErrorProvider.Kind errorKind, final long originalVersion) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        FileObject file = this.fromURI(uri);
        if (file == null) {
            return result;
        }
        try {
            List errors;
            String keyPrefix = this.key(errorKind);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            final StyledDocument doc = ec.openDocument();
            HashMap<String, org.netbeans.api.lsp.Diagnostic> id2Errors = new HashMap<String, org.netbeans.api.lsp.Diagnostic>();
            ErrorProvider errorProvider = (ErrorProvider)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)doc)).lookup(ErrorProvider.class);
            if (errorProvider != null) {
                final ErrorProvider.Context context = new ErrorProvider.Context(file, offset, errorKind);
                class CancelListener
                implements DocumentListener {
                    CancelListener() {
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.checkCancel();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.checkCancel();
                    }

                    private void checkCancel() {
                        if (TextDocumentServiceImpl.documentVersion(doc) != originalVersion) {
                            context.cancel();
                        }
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }
                }
                CancelListener l = new CancelListener();
                try {
                    doc.addDocumentListener(l);
                    l.checkCancel();
                    errors = errorProvider.computeErrors(context);
                }
                finally {
                    doc.removeDocumentListener(l);
                }
            } else {
                errors = null;
            }
            if (errors == null) {
                errors = Collections.emptyList();
            }
            if (TextDocumentServiceImpl.documentVersion(doc) != originalVersion) {
                return result;
            }
            for (org.netbeans.api.lsp.Diagnostic err : errors) {
                String string = err.getCode();
                id2Errors.put(string, err);
            }
            if (offset < 0) {
                doc.putProperty("lsp-errors-" + keyPrefix, id2Errors);
            }
            HashMap<String, org.netbeans.api.lsp.Diagnostic> mergedId2Errors = new HashMap<String, org.netbeans.api.lsp.Diagnostic>();
            for (String k : ERROR_KEYS) {
                Map prevErrors = (Map)doc.getProperty("lsp-errors-" + k);
                if (prevErrors == null) continue;
                mergedId2Errors.putAll(prevErrors);
            }
            for (Map.Entry entry : (offset < 0 ? mergedId2Errors : id2Errors).entrySet()) {
                org.netbeans.api.lsp.Diagnostic err = (org.netbeans.api.lsp.Diagnostic)entry.getValue();
                Diagnostic diag = new Diagnostic(new Range(Utils.createPosition(file, err.getStartPosition().getOffset()), Utils.createPosition(file, err.getEndPosition().getOffset())), err.getDescription());
                switch (err.getSeverity()) {
                    case Error: {
                        diag.setSeverity(DiagnosticSeverity.Error);
                        break;
                    }
                    case Warning: {
                        diag.setSeverity(DiagnosticSeverity.Warning);
                        break;
                    }
                    case Hint: {
                        diag.setSeverity(DiagnosticSeverity.Hint);
                        break;
                    }
                    case Information: {
                        diag.setSeverity(DiagnosticSeverity.Information);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown severity: " + err.getSeverity());
                    }
                }
                diag.setCode((String)entry.getKey());
                result.add(diag);
            }
            if (offset >= 0) {
                mergedId2Errors.putAll(id2Errors);
            }
            doc.putProperty("lsp-errors", mergedId2Errors);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return result;
    }

    private String key(ErrorProvider.Kind errorKind) {
        return errorKind.name().toLowerCase(Locale.ROOT);
    }

    private String kind(Diagnostic.Severity severity) {
        switch (severity) {
            case Hint: {
                return "refactor.rewrite";
            }
        }
        return "quickfix";
    }

    private FileObject fromURI(String uri) {
        return this.fromURI(uri, false);
    }

    private FileObject fromURI(String uri, boolean tryHard) {
        block7: {
            try {
                FileObject file = Utils.fromUri(uri);
                if (tryHard) {
                    if (file != null) {
                        file.refresh(true);
                    } else {
                        URI parentU = BaseUtilities.normalizeURI((URI)URI.create(uri).resolve(".."));
                        FileObject parentF = Utils.fromUri(parentU.toString());
                        if (parentF != null) {
                            parentF.refresh(true);
                            file = Utils.fromUri(uri);
                        }
                    }
                }
                if (file != null && file.isValid()) {
                    return file;
                }
                this.missingFileDiscovered(uri);
            }
            catch (MalformedURLException ex) {
                if (uri.startsWith("untitled:")) break block7;
                LOG.log(Level.WARNING, "Invalid file URL: " + uri, ex);
            }
        }
        return null;
    }

    private void missingFileDiscovered(String uri) {
        if (this.server.getOpenedDocuments().getDocument(uri) != null) {
            return;
        }
        Instant last = this.knownFiles.remove(uri);
        if (last == null) {
            return;
        }
        this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, new ArrayList()));
    }

    private void publishDiagnostics(String uri, List<Diagnostic> mergedDiags) {
        this.knownFiles.put(uri, Instant.now());
        this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, mergedDiags));
    }

    @CheckForNull
    public JavaSource getJavaSource(String fileUri) {
        Document doc = this.server.getOpenedDocuments().getDocument(fileUri);
        if (doc == null) {
            FileObject file = this.fromURI(fileUri);
            if (file == null) {
                return null;
            }
            return JavaSource.forFileObject((FileObject)file);
        }
        return JavaSource.forDocument((Document)doc);
    }

    @CheckForNull
    public Source getSource(String fileUri) {
        Document doc = this.server.getOpenedDocuments().getDocument(fileUri);
        if (doc == null) {
            FileObject file = this.fromURI(fileUri);
            if (file == null) {
                return null;
            }
            return Source.create((FileObject)file);
        }
        return Source.create((Document)doc);
    }

    public static List<org.eclipse.lsp4j.TextEdit> modify2TextEdits(JavaSource js, Task<WorkingCopy> task) throws IOException {
        FileObject[] file = new FileObject[1];
        LineMap[] lm = new LineMap[1];
        org.netbeans.api.java.source.ModificationResult changes = js.runModificationTask(wc -> {
            task.run(wc);
            file[0] = wc.getFileObject();
            lm[0] = wc.getCompilationUnit().getLineMap();
        });
        return TextDocumentServiceImpl.fileModifications(changes, file[0], lm[0]);
    }

    private static List<org.eclipse.lsp4j.TextEdit> fileModifications(org.netbeans.api.java.source.ModificationResult changes, FileObject file, LineMap lm) {
        List diffs = changes.getDifferences(file);
        if (diffs == null) {
            return Collections.emptyList();
        }
        ArrayList<org.eclipse.lsp4j.TextEdit> edits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        IntFunction<Position> offset2Position = lm != null ? pos -> Utils.createPosition(lm, pos) : pos -> Utils.createPosition(file, pos);
        for (ModificationResult.Difference diff : diffs) {
            String newText = diff.getNewText();
            edits.add(new org.eclipse.lsp4j.TextEdit(new Range(offset2Position.apply(diff.getStartPosition().getOffset()), offset2Position.apply(diff.getEndPosition().getOffset())), newText != null ? newText : ""));
        }
        return edits;
    }

    private static String getResourceName(TypeElement te, ElementHandle<?> handle) {
        String qualifiedName = null;
        if (te != null) {
            qualifiedName = te.getQualifiedName().toString();
        } else if (handle != null && (handle.getKind().isClass() || handle.getKind().isInterface())) {
            qualifiedName = handle.getQualifiedName();
        }
        return qualifiedName != null ? qualifiedName.replace('.', '/') + ".class" : null;
    }

    private static long documentVersion(Document doc) {
        Object ver = doc != null ? doc.getProperty("version") : null;
        return ver instanceof Number ? ((Number)ver).longValue() : -1L;
    }

    private static void reportNotificationDone(String s, Object parameter) {
        if (HOOK_NOTIFICATION != null) {
            HOOK_NOTIFICATION.accept(s, parameter);
        }
    }

    private static interface ProduceErrors {
        public List<ErrorDescription> computeErrors(CompilationInfo var1, Document var2) throws IOException;
    }

    public static final class CompletionData {
        public String uri;
        public int index;

        public CompletionData() {
        }

        public CompletionData(String uri, int index) {
            this.uri = uri;
            this.index = index;
        }

        public String toString() {
            return "CompletionData{uri=" + this.uri + ", index=" + this.index + '}';
        }
    }

    public static final class RefreshDocument
    implements ActiveDocumentProvider.IndexingAware {
        private final Set<TextDocumentServiceImpl> delegates = new WeakSet();

        public synchronized void register(TextDocumentServiceImpl delegate) {
            this.delegates.add(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indexingComplete(Set<URL> indexedRoots) {
            TextDocumentServiceImpl[] textDocumentServiceImplArray = this;
            synchronized (this) {
                TextDocumentServiceImpl[] delegates = this.delegates.toArray(new TextDocumentServiceImpl[this.delegates.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (TextDocumentServiceImpl delegate : delegates) {
                    delegate.reRunDiagnostics();
                }
                return;
            }
        }
    }
}

