/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.CodeRefactoring;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaMoveMembersProperties;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.lookup.Lookups;

public final class MoveRefactoring
extends CodeRefactoring {
    private static final String MOVE_REFACTORING_KIND = "refactor.move";
    private static final String MOVE_REFACTORING_COMMAND = "java.refactor.move";
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final Set<String> commands = Collections.singleton("java.refactor.move");
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = MoveRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        String uri = Utils.toUri(info.getFileObject());
        Element element = MoveRefactoring.elementForOffset((CompilationInfo)info, offset);
        if (element != null) {
            QuickPickItem elementItem = new QuickPickItem(MoveRefactoring.createLabel((CompilationInfo)info, element));
            elementItem.setUserData(new CodeActionsProvider.ElementData(element));
            return Collections.singletonList(MoveRefactoring.createCodeAction(Bundle.DN_Move(), MOVE_REFACTORING_KIND, MOVE_REFACTORING_COMMAND, uri, elementItem));
        }
        return Collections.singletonList(MoveRefactoring.createCodeAction(Bundle.DN_Move(), MOVE_REFACTORING_KIND, MOVE_REFACTORING_COMMAND, uri));
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        block11: {
            try {
                if (arguments.size() > 0) {
                    String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
                    QuickPickItem elementItem = arguments.size() > 1 ? (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(1)), QuickPickItem.class) : null;
                    FileObject file = Utils.fromUri(uri);
                    Project project = FileOwnerQuery.getOwner((FileObject)file);
                    HashSet<QuickPickItem> items = new HashSet<QuickPickItem>();
                    if (project != null) {
                        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                            String name = sourceGroup.getDisplayName();
                            FileObject rootFolder = sourceGroup.getRootFolder();
                            if (elementItem == null) {
                                items.add(new QuickPickItem(Bundle.DN_DefaultPackage(), name, null, false, Utils.toUri(rootFolder)));
                            }
                            for (String packageName : ClasspathInfo.create((FileObject)rootFolder).getClassIndex().getPackageNames("", false, EnumSet.of(ClassIndex.SearchScope.SOURCE))) {
                                if (elementItem == null) {
                                    String pkg = "";
                                    for (String part : packageName.split("\\.")) {
                                        if (part.isEmpty()) continue;
                                        pkg = pkg + (pkg.length() == 0 ? part : "." + part);
                                        items.add(new QuickPickItem(pkg, name, null, false, Utils.toUri(rootFolder.getFileObject(pkg.replace('.', '/')))));
                                    }
                                    continue;
                                }
                                items.add(new QuickPickItem(packageName, name, null, false, Utils.toUri(rootFolder.getFileObject(packageName.replace('.', '/')))));
                            }
                        }
                    }
                    ArrayList<QuickPickItem> packages = new ArrayList<QuickPickItem>(items);
                    Collections.sort(packages, (item1, item2) -> {
                        int i = item1.getDescription().compareTo(item2.getDescription());
                        return i == 0 ? item1.getLabel().compareTo(item2.getLabel()) : i;
                    });
                    Consumer<List> f = selectedPackage -> {
                        if (selectedPackage == null || selectedPackage.isEmpty()) return;
                        ClasspathInfo info = ClasspathInfo.create((FileObject)file);
                        TreePathHandle tph = elementItem != null ? TreePathHandle.from((ElementHandle)((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(elementItem.getUserData()), CodeActionsProvider.ElementData.class)).toHandle(), (ClasspathInfo)info) : null;
                        List<QuickPickItem> classes = MoveRefactoring.packageClasses((QuickPickItem)selectedPackage.get(0), tph == null || tph.getKind() == Tree.Kind.CLASS);
                        if (classes.isEmpty()) {
                            if (tph != null) throw new IllegalArgumentException(String.format("No target class found in selected package", new Object[0]));
                            this.move(client, uri, (QuickPickItem)selectedPackage.get(0), ClasspathInfo.create((FileObject)file));
                            return;
                        } else {
                            client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectTargetClass(), false, classes)).thenAccept(selectedClass -> {
                                if (selectedClass != null && !selectedClass.isEmpty()) {
                                    QuickPickItem selected = Bundle.DN_CreateNewClass().equals(((QuickPickItem)selectedClass.get(0)).getLabel()) ? (QuickPickItem)selectedPackage.get(0) : (QuickPickItem)selectedClass.get(0);
                                    this.move(client, tph != null ? tph : uri, selected, info);
                                }
                            });
                        }
                    };
                    if (packages.size() == 1) {
                        f.accept(packages);
                    } else {
                        client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectTargetPackage(), false, packages)).thenAccept(f);
                    }
                    break block11;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (Exception ex) {
                client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    private void move(NbCodeLanguageClient client, Object source, QuickPickItem target, ClasspathInfo info) {
        try {
            org.netbeans.modules.refactoring.api.MoveRefactoring refactoring;
            if (source instanceof String) {
                FileObject file = Utils.fromUri((String)source);
                refactoring = new org.netbeans.modules.refactoring.api.MoveRefactoring(Lookups.fixed((Object[])new Object[]{file}));
                refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{file}));
            } else {
                TreePathHandle tph = (TreePathHandle)source;
                refactoring = new org.netbeans.modules.refactoring.api.MoveRefactoring(Lookups.fixed((Object[])new Object[]{tph}));
                refactoring.getContext().add(tph.getKind() == Tree.Kind.CLASS ? JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{tph.getFileObject()}) : new JavaMoveMembersProperties(new TreePathHandle[]{tph}));
            }
            if (target.getDescription() != null) {
                refactoring.setTarget(Lookups.singleton((Object)new URL((String)target.getUserData())));
            } else {
                ElementHandle handle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(target.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
                refactoring.setTarget(Lookups.singleton((Object)TreePathHandle.from((ElementHandle)handle, (ClasspathInfo)info)));
            }
            client.applyEdit(new ApplyWorkspaceEditParams(this.perform((AbstractRefactoring)refactoring, "Move")));
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }

    private static Element elementForOffset(CompilationInfo info, int offset) throws RuntimeException {
        List topLevelElements = info.getTopLevelElements();
        Trees trees = info.getTrees();
        SourcePositions sourcePositions = trees.getSourcePositions();
        CompilationUnitTree compilationUnit = info.getCompilationUnit();
        for (TypeElement typeElement : topLevelElements) {
            ClassTree topLevelClass = trees.getTree(typeElement);
            long startPosition = sourcePositions.getStartPosition(compilationUnit, topLevelClass);
            long endPosition = sourcePositions.getEndPosition(compilationUnit, topLevelClass);
            if ((long)offset <= startPosition || (long)offset >= endPosition) continue;
            for (Element element : typeElement.getEnclosedElements()) {
                Tree member = trees.getTree(element);
                long startMember = sourcePositions.getStartPosition(compilationUnit, member);
                long endMember = sourcePositions.getEndPosition(compilationUnit, member);
                if ((long)offset <= startMember || (long)offset >= endMember) continue;
                return element;
            }
            return topLevelElements.size() > 1 ? typeElement : null;
        }
        return null;
    }

    private static List<QuickPickItem> packageClasses(QuickPickItem targetPackage, boolean proposeNew) {
        try {
            FileObject fo = Utils.fromUri((String)targetPackage.getUserData());
            ClassPath sourcePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            ClasspathInfo info = ClasspathInfo.create((ClassPath)EMPTY_PATH, (ClassPath)EMPTY_PATH, (ClassPath)sourcePath);
            HashSet<1> searchScopeType = new HashSet<1>(1);
            String packageName = Bundle.DN_DefaultPackage().equals(targetPackage.getLabel()) ? "" : targetPackage.getLabel();
            final Set<String> packageSet = Collections.singleton(packageName);
            searchScopeType.add(new ClassIndex.SearchScopeType(){

                public Set<? extends String> getPackages() {
                    return packageSet;
                }

                public boolean isSources() {
                    return true;
                }

                public boolean isDependencies() {
                    return false;
                }
            });
            Set result = info.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, searchScopeType);
            if (result != null && !result.isEmpty()) {
                ArrayList<QuickPickItem> ret = new ArrayList<QuickPickItem>(result.size() + 1);
                if (proposeNew) {
                    ret.add(new QuickPickItem(Bundle.DN_CreateNewClass()));
                }
                for (ElementHandle elementHandle : result) {
                    String shortName;
                    int idx;
                    String qualifiedName = elementHandle.getQualifiedName();
                    if (!qualifiedName.startsWith(packageName) || fo.getFileObject((idx = (shortName = qualifiedName.substring(packageName.length() + 1)).indexOf(46)) < 0 ? shortName : shortName.substring(0, idx), "java") == null) continue;
                    ret.add(new QuickPickItem(shortName, null, null, false, new CodeActionsProvider.ElementData((ElementHandle<? extends Element>)elementHandle)));
                }
                return ret;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }
}

