/**
 * The DOMImplementation interface provides a number of methods for performing operations that are independent of any particular instance of the document object model.
 */
var DOMImplementation = {
}
/**
 * Creates a DOM Document object of the specified type with its document element. Note that based on the DocumentType given to create the document, the implementation may instantiate specialized Document objects that support additional features than the "Core", such as "HTML" [ DOM Level 2 HTML]. On the other hand, setting the DocumentType after the document was created makes this very unlikely to happen. Alternatively, specialized Document creation methods, such as createHTMLDocument [ DOM Level 2 HTML], can be used to obtain specific types of Document objects.
 * @syntax dOMImplementation.createDocument(namespaceURI, qualifiedName, doctype)
 * @param {String} namespaceURI The namespace URI of the document element to create or null.
 * @param {String} qualifiedName The qualified name of the document element to be created or null.
 * @param {DocumentType} doctype The type of document to be created or null. When doctype is not null, its Node.ownerDocument attribute is set to the document being created.
 * @returns {Document} A new Document object with its document element. If the NamespaceURI, qualifiedName, and doctype are null, the returned Document is empty with no document element.
 */
DOMImplementation.prototype.createDocument = function(namespaceURI,  qualifiedName,  doctype) {};

/**
 * Creates an empty DocumentType node. Entity declarations and notations are not made available. Entity reference expansions and default attribute additions do not occur.
 * @syntax dOMImplementation.createDocumentType(qualifiedName, publicId, systemId)
 * @param {String} qualifiedName The qualified name of the document type to be created.
 * @param {String} publicId The external subset public identifier.
 * @param {String} systemId The external subset system identifier.
 * @returns {DocumentType} A new DocumentType node with Node.ownerDocument set to null.
 */
DOMImplementation.prototype.createDocumentType = function(qualifiedName,  publicId,  systemId) {};

/**
 * Test if the DOM implementation implements a specific feature and version, as specified in DOM Features.
 * @syntax dOMImplementation.hasFeature(feature, version)
 * @param {String} feature The name of the feature to test.
 * @param {String} version This is the version number of the feature to test.
 * @returns {boolean} true if the feature is implemented in the specified version, false otherwise.
 */
DOMImplementation.prototype.hasFeature = function(feature,  version) {};

/**
 * This method returns a specialized object which implements the specialized APIs of the specified feature and version, as specified in DOM Features. The specialized object may also be obtained by using binding-specific casting methods but is not necessarily expected to, as discussed in Mixed DOM Implementations. This method also allow the implementation to provide specialized objects which do not support the DOMImplementation interface.
 * @syntax dOMImplementation.getFeature(feature, version)
 * @param {String} feature The name of the feature requested. Note that any plus sign "+" prepended to the name of the feature will be ignored since it is not significant in the context of this method.
 * @param {String} version This is the version number of the feature to test.
 * @returns {DOMObject} Returns an object which implements the specialized APIs of the specified feature and version, if any, or null if there is no object which implements interfaces associated with that feature. If the DOMObject returned by this method implements the DOMImplementation interface, it must delegate to the primary core DOMImplementation and not return results inconsistent with the primary core DOMImplementation such as hasFeature, getFeature, etc.
 */
DOMImplementation.prototype.getFeature = function(feature,  version) {};

/**
 * Represents the DOMImplementation prototype object.
 * @syntax DOMImplementation.prototype
 * @static
 */
DOMImplementation.prototype;

