/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

public class Scanner {
    protected final String content;
    protected int position;
    protected final int limit;
    protected int line;
    protected char ch0;
    protected char ch1;
    protected char ch2;
    protected char ch3;

    protected Scanner(String string, int n, int n2, int n3) {
        this.content = string;
        this.position = n2;
        this.limit = n2 + n3;
        this.line = n;
        this.reset(this.position);
    }

    Scanner(Scanner scanner, State state) {
        this.content = scanner.content;
        this.position = state.position;
        this.limit = state.limit;
        this.line = state.line;
        this.reset(this.position);
    }

    State saveState() {
        return new State(this.position, this.limit, this.line);
    }

    void restoreState(State state) {
        this.position = state.position;
        this.line = state.line;
        this.reset(this.position);
    }

    protected final boolean atEOF() {
        return this.position == this.limit;
    }

    protected final char charAt(int n) {
        return n < this.limit ? this.content.charAt(n) : (char)'\u0000';
    }

    protected final void reset(int n) {
        this.ch0 = this.charAt(n);
        this.ch1 = this.charAt(n + 1);
        this.ch2 = this.charAt(n + 2);
        this.ch3 = this.charAt(n + 3);
        this.position = n < this.limit ? n : this.limit;
    }

    protected final void skip(int n) {
        if (n == 1 && !this.atEOF()) {
            this.ch0 = this.ch1;
            this.ch1 = this.ch2;
            this.ch2 = this.ch3;
            this.ch3 = this.charAt(this.position + 4);
            ++this.position;
        } else if (n != 0) {
            this.reset(this.position + n);
        }
    }

    static class State {
        public final int position;
        public int limit;
        public final int line;

        State(int n, int n2, int n3) {
            this.position = n;
            this.limit = n2;
            this.line = n3;
        }

        void setLimit(int n) {
            this.limit = n;
        }

        boolean isEmpty() {
            return this.position == this.limit;
        }
    }
}

