/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;

public class ExtendedTableModel
extends SortableTableModel {
    private SortableTableModel realModel;
    private int[] columnsMapping;
    private boolean[] columnsVisibility;
    private int realColumnsCount;
    private int virtualColumnsCount;

    public ExtendedTableModel(SortableTableModel realModel) {
        this.virtualColumnsCount = this.realColumnsCount = realModel.getColumnCount();
        this.realModel = realModel;
        this.columnsMapping = new int[this.realColumnsCount];
        boolean[] initialColumnsVisibility = new boolean[this.realColumnsCount];
        for (int i = 0; i < this.realColumnsCount; ++i) {
            initialColumnsVisibility[i] = true;
        }
        this.setColumnsVisibility(initialColumnsVisibility);
    }

    public Class getColumnClass(int col) {
        return this.realModel.getColumnClass(this.getRealColumn(col));
    }

    @Override
    public int getColumnCount() {
        return this.virtualColumnsCount;
    }

    @Override
    public String getColumnName(int col) {
        return this.realModel.getColumnName(this.getRealColumn(col));
    }

    @Override
    public String getColumnToolTipText(int columnIndex) {
        return this.realModel.getColumnToolTipText(this.getRealColumn(columnIndex));
    }

    public void setColumnsVisibility(boolean[] columnsVisibility) {
        this.columnsVisibility = columnsVisibility;
        this.recomputeColumnsMapping();
    }

    public boolean[] getColumnsVisibility() {
        return this.columnsVisibility;
    }

    @Override
    public boolean getInitialSorting(int column) {
        return this.realModel.getInitialSorting(this.getRealColumn(column));
    }

    public int getRealColumn(int column) {
        return this.columnsMapping[column];
    }

    public void setRealColumnVisibility(int column, boolean visible) {
        if (visible) {
            this.showRealColumn(column);
        } else {
            this.hideRealColumn(column);
        }
    }

    public boolean isRealColumnVisible(int column) {
        return this.columnsVisibility[column];
    }

    @Override
    public int getRowCount() {
        return this.realModel.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.realModel.getValueAt(rowIndex, this.getRealColumn(columnIndex));
    }

    public int getVirtualColumn(int column) {
        for (int i = 0; i < this.virtualColumnsCount; ++i) {
            if (this.getRealColumn(i) != column) continue;
            return i;
        }
        return -1;
    }

    public void hideRealColumn(int column) {
        if (this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = false;
            this.recomputeColumnsMapping();
        }
    }

    public void showRealColumn(int column) {
        if (!this.isRealColumnVisible(column)) {
            this.columnsVisibility[column] = true;
            this.recomputeColumnsMapping();
        }
    }

    @Override
    public void sortByColumn(int column, boolean order) {
        this.realModel.sortByColumn(this.getRealColumn(column), order);
    }

    private void recomputeColumnsMapping() {
        int i;
        this.virtualColumnsCount = 0;
        int virtualColumnIndex = 0;
        for (i = 0; i < this.realColumnsCount; ++i) {
            if (!this.columnsVisibility[i]) continue;
            this.columnsMapping[virtualColumnIndex] = i;
            ++this.virtualColumnsCount;
            ++virtualColumnIndex;
        }
        for (i = virtualColumnIndex; i < this.realColumnsCount; ++i) {
            this.columnsMapping[i] = -1;
        }
        this.fireTableStructureChanged();
        this.realModel.fireTableStructureChanged();
    }
}

