/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.plain;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.Node;

public abstract class AbstractElement
implements Element {
    private CharSequence source;
    private int offset;
    private short length;

    AbstractElement(CharSequence doc, int offset, short length) {
        assert (offset >= 0) : "start offset must be >= 0 !";
        assert (length >= 0) : "element length must be positive!";
        this.offset = offset;
        this.length = length;
        this.source = doc;
    }

    @Override
    public int from() {
        return this.offset;
    }

    @Override
    public int to() {
        return this.offset + this.length;
    }

    protected CharSequence source() {
        return this.source;
    }

    @Override
    public CharSequence image() {
        return this.source.subSequence(this.from(), this.to());
    }

    public String toString() {
        return "[" + this.type().name() + ' ' + this.from() + '-' + this.to() + ']';
    }

    @Override
    public CharSequence id() {
        return this.type().name();
    }

    @Override
    public Node parent() {
        return null;
    }

    @Override
    public Collection<ProblemDescription> problems() {
        return Collections.emptyList();
    }
}

