/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.api.GradleConfiguration;
import org.netbeans.modules.gradle.api.GradleDependency;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.modules.Places;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class GradleArtifactStore {
    private static final String GRADLE_ARTIFACT_STORE_INFO = "gradle/artifact-store-info.ser";
    public static final RequestProcessor RP = new RequestProcessor("Gradle Artifact Store", 1);
    private final Map<String, Set<File>> binaries = new ConcurrentHashMap<String, Set<File>>();
    private final Map<File, File> sources = new ConcurrentHashMap<File, File>();
    private final Map<File, File> javadocs = new ConcurrentHashMap<File, File>();
    private static final GradleArtifactStore INSTANCE = new GradleArtifactStore();
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final RequestProcessor.Task notifyTask = RP.create(new Runnable(){

        @Override
        public void run() {
            GradleArtifactStore.this.cs.fireChange();
        }
    });

    public static GradleArtifactStore getDefault() {
        return INSTANCE;
    }

    public Set<File> getBinaries(String id) {
        Set<File> ret = this.binaries.get(id);
        return ret;
    }

    public File getSources(File binary) {
        File ret = this.sources.get(binary);
        if (ret != null && !ret.exists()) {
            this.sources.remove(binary);
            ret = null;
        }
        if (ret == null && (ret = GradleArtifactStore.checkM2Heuristic(binary, "sources")) != null) {
            this.sources.put(binary, ret);
        }
        return ret;
    }

    public File getJavadoc(File binary) {
        File ret = this.javadocs.get(binary);
        if (ret != null && !ret.exists()) {
            this.javadocs.remove(binary);
            ret = null;
        }
        if (ret == null && (ret = GradleArtifactStore.checkM2Heuristic(binary, "javadoc")) != null) {
            this.javadocs.put(binary, ret);
        }
        return ret;
    }

    void processProject(GradleProject gp) {
        if (gp.getQuality().worseThan(NbGradleProject.Quality.FULL)) {
            return;
        }
        boolean changed = false;
        for (GradleConfiguration conf : gp.getBaseProject().getConfigurations().values()) {
            for (GradleDependency.ModuleDependency module : conf.getModules()) {
                File old;
                Set<File> newBins;
                Set<File> oldBins = this.binaries.get(module.getId());
                if (oldBins != (newBins = module.getArtifacts())) {
                    this.binaries.put(module.getId(), newBins);
                    changed = true;
                }
                if (module.getArtifacts().size() != 1) continue;
                File binary = module.getArtifacts().iterator().next();
                if (module.getSources().size() == 1) {
                    File source = module.getSources().iterator().next();
                    if (binary.isFile() && source.isFile()) {
                        old = this.sources.put(binary, source);
                        changed |= old == null || !old.equals(source);
                    }
                }
                if (module.getJavadoc().size() != 1) continue;
                File javadoc = module.getJavadoc().iterator().next();
                if (!binary.isFile() || !javadoc.isFile()) continue;
                old = this.javadocs.put(binary, javadoc);
                changed |= old == null || !old.equals(javadoc);
            }
        }
        if (changed) {
            this.store();
            this.notifyTask.schedule(1000);
        }
    }

    public void clear() {
        this.sources.clear();
        this.javadocs.clear();
        this.store();
    }

    void verify() {
        if (this.verifyMap(this.sources) || this.verifyMap(this.javadocs)) {
            this.store();
        }
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private boolean verifyMap(Map<File, File> m) {
        boolean changed = false;
        Iterator<Map.Entry<File, File>> it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, File> entry = it.next();
            if (entry.getKey().exists() && entry.getValue().exists()) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    void load() {
        File cache = Places.getCacheSubfile((String)GRADLE_ARTIFACT_STORE_INFO);
        try (ObjectInputStream is = new ObjectInputStream(new FileInputStream(cache));){
            Map bins = (Map)is.readObject();
            Iterator it = bins.entrySet().iterator();
            block11: while (it.hasNext()) {
                Map.Entry entry = it.next();
                for (File f : (Set)entry.getValue()) {
                    if (f.exists()) continue;
                    it.remove();
                    continue block11;
                }
            }
            this.binaries.clear();
            this.binaries.putAll(bins);
            HashMap srcs = (HashMap)is.readObject();
            this.verifyMap(srcs);
            this.sources.clear();
            this.sources.putAll(srcs);
            HashMap docs = (HashMap)is.readObject();
            this.verifyMap(docs);
            this.javadocs.clear();
            this.javadocs.putAll(docs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void store() {
        File cache = Places.getCacheSubfile((String)GRADLE_ARTIFACT_STORE_INFO);
        try (ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(cache));){
            os.writeObject(new HashMap<String, Set<File>>(this.binaries));
            os.writeObject(new HashMap<File, File>(this.sources));
            os.writeObject(new HashMap<File, File>(this.javadocs));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File checkM2Heuristic(File mainJar, String classifier) {
        File ret = null;
        String fname = mainJar.getName();
        StringBuilder guessName = new StringBuilder(fname);
        if (fname.endsWith(".jar")) {
            guessName = guessName.delete(guessName.length() - 4, guessName.length());
            guessName.append('-').append(classifier).append(".jar");
            File guess = new File(mainJar.getParentFile(), guessName.toString());
            if (guess.isFile()) {
                ret = guess;
            }
        }
        return ret;
    }

    public static class Loader
    implements Runnable {
        @Override
        public void run() {
            GradleArtifactStore.getDefault().load();
        }
    }
}

