/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.HyperlinkLocation;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.java.completion.JavaDocumentationTask;
import org.netbeans.modules.java.editor.base.fold.JavaElementFoldVisitor;
import org.netbeans.modules.java.editor.base.semantic.MarkOccurrencesHighlighterBase;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.editor.overridden.ComputeOverriders;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.hints.errors.CreateFixBase;
import org.netbeans.modules.java.hints.errors.ImportClass;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.project.IncompleteClassPath;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TestSuiteInfo;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.plugins.FileRenamePlugin;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;

public class TextDocumentServiceImpl
implements TextDocumentService,
LanguageClientAware {
    private static final Logger LOG = Logger.getLogger(TextDocumentServiceImpl.class.getName());
    private static final RequestProcessor BACKGROUND_TASKS = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private static final RequestProcessor WORKER = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private Map<String, Instant> knownFiles = new HashMap<String, Instant>();
    private final Map<String, Document> openedDocuments = new ConcurrentHashMap<String, Document>();
    private final Map<String, RequestProcessor.Task> diagnosticTasks = new HashMap<String, RequestProcessor.Task>();
    private final LspServerState server;
    private NbCodeLanguageClient client;
    private List<Completion> lastCompletions = null;
    private static final RequestProcessor JAVADOC_WORKER = new RequestProcessor(TextDocumentServiceImpl.class.getName() + ".javadoc", 1);
    private static final String DEFAULT_SORT_TEXT = "\uffff";
    private ConcurrentHashMap<String, Boolean> upToDateTests = new ConcurrentHashMap();
    private static final int DELAY = 500;
    private static final String[] ERROR_KEYS = new String[]{"errors", "hints"};
    static BiConsumer<String, Object> HOOK_NOTIFICATION = null;

    TextDocumentServiceImpl(LspServerState server) {
        this.server = server;
        ((RefreshDocument)Lookup.getDefault().lookup(RefreshDocument.class)).register(this);
    }

    private void reRunDiagnostics() {
        HashSet<String> documents = new HashSet<String>(this.openedDocuments.keySet());
        for (String doc : documents) {
            this.runDiagnoticTasks(doc);
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        this.lastCompletions = new ArrayList<Completion>();
        AtomicInteger index = new AtomicInteger(0);
        CompletionList completionList = new CompletionList();
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
        }
        try {
            String uri = params.getTextDocument().getUri();
            FileObject file = this.fromURI(uri);
            if (file == null) {
                return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            int caret = Utils.getOffset(doc, params.getPosition());
            ArrayList items = new ArrayList();
            Completion.Context context = params.getContext() != null ? new Completion.Context(Completion.TriggerKind.valueOf((String)params.getContext().getTriggerKind().name()), params.getContext().getTriggerCharacter() == null || params.getContext().getTriggerCharacter().isEmpty() ? null : Character.valueOf(params.getContext().getTriggerCharacter().charAt(0))) : null;
            boolean isComplete = Completion.collect((Document)doc, (int)caret, (Completion.Context)context, completion -> {
                List additionalTextEdits;
                TextEdit edit;
                String documentation;
                CompletionItem item = new CompletionItem(completion.getLabel());
                if (completion.getKind() != null) {
                    item.setKind(CompletionItemKind.valueOf((String)completion.getKind().name()));
                }
                if (completion.getTags() != null) {
                    item.setTags(completion.getTags().stream().map(tag -> CompletionItemTag.valueOf((String)tag.name())).collect(Collectors.toList()));
                }
                if (completion.getDetail() != null && completion.getDetail().isDone()) {
                    item.setDetail((String)completion.getDetail().getNow(null));
                }
                if (completion.getDocumentation() != null && completion.getDocumentation().isDone() && (documentation = (String)completion.getDocumentation().getNow(null)) != null) {
                    MarkupContent markup = new MarkupContent();
                    markup.setKind("markdown");
                    markup.setValue(TextDocumentServiceImpl.html2MD(documentation));
                    item.setDocumentation(markup);
                }
                if (completion.isPreselect()) {
                    item.setPreselect(Boolean.valueOf(true));
                }
                item.setSortText(completion.getSortText());
                item.setFilterText(completion.getFilterText());
                item.setInsertText(completion.getInsertText());
                if (completion.getInsertTextFormat() != null) {
                    item.setInsertTextFormat(InsertTextFormat.valueOf((String)completion.getInsertTextFormat().name()));
                }
                if ((edit = completion.getTextEdit()) != null) {
                    item.setTextEdit(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, edit.getStartOffset()), Utils.createPosition(file, edit.getEndOffset())), edit.getNewText()));
                }
                if (completion.getAdditionalTextEdits() != null && completion.getAdditionalTextEdits().isDone() && (additionalTextEdits = (List)completion.getAdditionalTextEdits().getNow(null)) != null && !additionalTextEdits.isEmpty()) {
                    item.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, ed.getStartOffset()), Utils.createPosition(file, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
                }
                if (completion.getCommitCharacters() != null) {
                    item.setCommitCharacters(completion.getCommitCharacters().stream().map(ch -> ch.toString()).collect(Collectors.toList()));
                }
                this.lastCompletions.add((Completion)completion);
                item.setData((Object)new CompletionData(uri, index.getAndIncrement()));
                items.add(item);
            });
            if (!isComplete) {
                completionList.setIsIncomplete(true);
            }
            completionList.setItems(items);
            return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem ci) {
        JsonObject rawData = (JsonObject)ci.getData();
        if (rawData != null) {
            FileObject file;
            CompletionData data = (CompletionData)new Gson().fromJson((JsonElement)rawData, CompletionData.class);
            Completion completion = this.lastCompletions.get(data.index);
            if (completion != null && (file = this.fromURI(data.uri)) != null) {
                CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
                JAVADOC_WORKER.post(() -> {
                    if (completion.getDetail() != null) {
                        try {
                            String detail = (String)completion.getDetail().get();
                            if (detail != null) {
                                ci.setDetail(detail);
                            }
                        }
                        catch (Exception detail) {
                            // empty catch block
                        }
                    }
                    if (completion.getDocumentation() != null) {
                        try {
                            String documentation = (String)completion.getDocumentation().get();
                            if (documentation != null) {
                                MarkupContent markup = new MarkupContent();
                                markup.setKind("markdown");
                                markup.setValue(TextDocumentServiceImpl.html2MD(documentation));
                                ci.setDocumentation(markup);
                            }
                        }
                        catch (Exception documentation) {
                            // empty catch block
                        }
                    }
                    if (completion.getAdditionalTextEdits() != null) {
                        try {
                            List additionalTextEdits = (List)completion.getAdditionalTextEdits().get();
                            if (additionalTextEdits != null && !additionalTextEdits.isEmpty()) {
                                ci.setAdditionalTextEdits(additionalTextEdits.stream().map(ed -> new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(file, ed.getStartOffset()), Utils.createPosition(file, ed.getEndOffset())), ed.getNewText())).collect(Collectors.toList()));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    result.complete(ci);
                });
                return result;
            }
        }
        return CompletableFuture.completedFuture(ci);
    }

    public static String html2MD(String html) {
        int idx = html.indexOf("<p id=\"not-found\">");
        return FlexmarkHtmlConverter.builder().build().convert(idx >= 0 ? html.substring(0, idx) : html).replaceAll("<br />[ \n]*$", "");
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            String uri = params.getTextDocument().getUri();
            FileObject file = this.fromURI(uri);
            if (file == null) {
                return CompletableFuture.completedFuture(null);
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            final JavaDocumentationTask task = JavaDocumentationTask.create((int)Utils.getOffset(doc, params.getPosition()), null, (JavaDocumentationTask.DocumentationFactory)new JavaDocumentationTask.DocumentationFactory<Future<String>>(){

                public Future<String> create(CompilationInfo compilationInfo, Element element, Callable<Boolean> cancel) {
                    return ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element, cancel).getTextAsync();
                }
            }, () -> false);
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    task.run(resultIterator);
                }
            });
            final Future futureJavadoc = (Future)task.getDocumentation();
            CompletableFuture<Hover> result = new CompletableFuture<Hover>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return futureJavadoc != null && futureJavadoc.cancel(mayInterruptIfRunning) && super.cancel(mayInterruptIfRunning);
                }
            };
            JAVADOC_WORKER.post(() -> {
                try {
                    String javadoc;
                    String string = javadoc = futureJavadoc != null ? (String)futureJavadoc.get() : null;
                    if (javadoc != null) {
                        MarkupContent markup = new MarkupContent();
                        markup.setKind("markdown");
                        markup.setValue(TextDocumentServiceImpl.html2MD(javadoc));
                        result.complete(new Hover(markup));
                    } else {
                        result.complete(null);
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    result.completeExceptionally(ex);
                }
            });
            return result;
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        try {
            FileObject file;
            String uri = params.getTextDocument().getUri();
            Document doc = this.openedDocuments.get(uri);
            if (doc != null && (file = Utils.fromUri(uri)) != null) {
                int offset = Utils.getOffset(doc, params.getPosition());
                return HyperlinkLocation.resolve((Document)doc, (int)offset).thenApply(locs -> Either.forLeft(locs.stream().map(location -> {
                    FileObject fo = location.getFileObject();
                    return new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, location.getStartOffset()), Utils.createPosition(fo, location.getEndOffset())));
                }).collect(Collectors.toList())));
            }
        }
        catch (MalformedURLException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        String uri = params.getTextDocument().getUri();
        JavaSource js = this.getJavaSource(uri);
        if (js == null) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        ArrayList targets = new ArrayList();
        LineMap[] thisFileLineMap = new LineMap[1];
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = Utils.getOffset(doc, params.getPosition());
                Element el = null;
                GoToSupport.Context context = GoToSupport.resolveContext((CompilationInfo)cc, (Document)doc, (int)offset, (boolean)false, (boolean)false);
                if (context == null) {
                    TreePath tp = cc.getTreeUtilities().pathFor(offset);
                    if (tp.getLeaf().getKind() == Tree.Kind.MODIFIERS) {
                        tp = tp.getParentPath();
                    }
                    int[] elementNameSpan = null;
                    switch (tp.getLeaf().getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            elementNameSpan = cc.getTreeUtilities().findNameSpan((ClassTree)tp.getLeaf());
                            break;
                        }
                        case METHOD: {
                            elementNameSpan = cc.getTreeUtilities().findNameSpan((MethodTree)tp.getLeaf());
                        }
                    }
                    if (elementNameSpan != null && offset <= elementNameSpan[1]) {
                        el = cc.getTrees().getElement(tp);
                    }
                } else if (EnumSet.of(ElementKind.METHOD, ElementKind.ANNOTATION_TYPE, ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE).contains((Object)context.resolved.getKind())) {
                    el = context.resolved;
                }
                if (el != null) {
                    List overridingMethods;
                    TypeElement type = el.getKind() == ElementKind.METHOD ? (TypeElement)el.getEnclosingElement() : (TypeElement)el;
                    ExecutableElement method = el.getKind() == ElementKind.METHOD ? (ExecutableElement)el : null;
                    Map overriding = new ComputeOverriders(new AtomicBoolean()).process((CompilationInfo)cc, type, method, true);
                    List list = overridingMethods = overriding != null ? (List)overriding.get(ElementHandle.create((Element)el)) : null;
                    if (overridingMethods != null) {
                        for (ElementDescription ed : overridingMethods) {
                            long startPos;
                            Element elm = ed.getHandle().resolve((CompilationInfo)cc);
                            TreePath tp = cc.getTrees().getPath(elm);
                            long l = startPos = tp != null && cc.getCompilationUnit() == tp.getCompilationUnit() ? cc.getTrees().getSourcePositions().getStartPosition(cc.getCompilationUnit(), tp.getLeaf()) : -1L;
                            if (startPos >= 0L) {
                                long endPos = cc.getTrees().getSourcePositions().getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                                targets.add(new GoToSupport.GoToTarget(cc.getSnapshot().getOriginalOffset((int)startPos), cc.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan((Tree)tp.getLeaf(), (TreeUtilities)cc.getTreeUtilities()), null, null, null, ed.getDisplayName(), true));
                                continue;
                            }
                            TypeElement te = elm != null ? cc.getElementUtilities().outermostTypeElement(elm) : null;
                            targets.add(new GoToSupport.GoToTarget(-1, -1, null, ed.getOriginalCPInfo(), ed.getHandle(), TextDocumentServiceImpl.getResourceName(te, ed.getHandle()), ed.getDisplayName(), true));
                        }
                    }
                }
                thisFileLineMap[0] = cc.getCompilationUnit().getLineMap();
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        CompletableFuture[] futures = (CompletableFuture[])targets.stream().map(target -> this.gotoTarget2Location(uri, (GoToSupport.GoToTarget)target, thisFileLineMap[0])).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(value -> {
            ArrayList<Location> locations = new ArrayList<Location>(futures.length);
            for (CompletableFuture future : futures) {
                Location location = future.getNow(null);
                if (location == null) continue;
                locations.add(location);
            }
            return Either.forLeft(locations);
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        Project[] projects = this.server.openedProjects().getNow(null);
        if (projects == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<List<? extends Location>> result = new CompletableFuture<List<? extends Location>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
            if (js == null) {
                result.complete(new ArrayList());
                return;
            }
            try {
                WhereUsedQuery[] query = new WhereUsedQuery[1];
                ArrayList<Location> locations = new ArrayList<Location>();
                js.runUserActionTask(cc -> {
                    Element decl;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset(doc, params.getPosition()));
                    if (params.getContext().isIncludeDeclaration() && (decl = cc.getTrees().getElement(path)) != null) {
                        TreePath declPath = cc.getTrees().getPath(decl);
                        if (declPath != null && cc.getCompilationUnit() == declPath.getCompilationUnit()) {
                            Range range = TextDocumentServiceImpl.declarationRange((CompilationInfo)cc, declPath);
                            if (range != null) {
                                locations.add(new Location(Utils.toUri(cc.getFileObject()), range));
                            }
                        } else {
                            JavaSource source;
                            ElementHandle declHandle = ElementHandle.create((Element)decl);
                            FileObject sourceFile = SourceUtils.getFile((ElementHandle)declHandle, (ClasspathInfo)cc.getClasspathInfo());
                            JavaSource javaSource = source = sourceFile != null ? JavaSource.forFileObject((FileObject)sourceFile) : null;
                            if (source != null) {
                                source.runUserActionTask(nestedCC -> {
                                    Range range;
                                    TreePath declPath2;
                                    nestedCC.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    Element declHandle2 = declHandle.resolve((CompilationInfo)nestedCC);
                                    TreePath treePath = declPath2 = declHandle2 != null ? nestedCC.getTrees().getPath(declHandle2) : null;
                                    if (declPath2 != null && (range = TextDocumentServiceImpl.declarationRange((CompilationInfo)nestedCC, declPath2)) != null) {
                                        locations.add(new Location(Utils.toUri(nestedCC.getFileObject()), range));
                                    }
                                }, true);
                            }
                        }
                    }
                    query[0] = new WhereUsedQuery(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                }, true);
                if (cancel.get()) {
                    return;
                }
                ArrayList<FileObject> sourceRoots = new ArrayList<FileObject>();
                for (Project project : projects) {
                    Sources sources = ProjectUtils.getSources((Project)project);
                    for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
                        sourceRoots.add(sourceGroup.getRootFolder());
                    }
                }
                if (!sourceRoots.isEmpty()) {
                    query[0].getContext().add((Object)Scope.create(sourceRoots, null, null));
                }
                cancelCallback[0] = () -> query[0].cancelRequest();
                RefactoringSession refactoring = RefactoringSession.create((String)"FindUsages");
                Problem p = query[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = query[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = query[0].prepare(refactoring);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                for (RefactoringElement re : refactoring.getRefactoringElements()) {
                    if (cancel.get()) {
                        return;
                    }
                    locations.add(new Location(Utils.toUri(re.getParentFile()), TextDocumentServiceImpl.toRange(re.getPosition())));
                }
                refactoring.finished();
                result.complete(locations);
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    private static Range declarationRange(CompilationInfo info, TreePath tp) {
        int[] span;
        Tree t = tp.getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
            span = info.getTreeUtilities().findNameSpan((ClassTree)t);
        } else if (t.getKind() == Tree.Kind.VARIABLE) {
            span = info.getTreeUtilities().findNameSpan((VariableTree)t);
        } else if (t.getKind() == Tree.Kind.METHOD) {
            span = info.getTreeUtilities().findNameSpan((MethodTree)t);
            if (span == null) {
                span = info.getTreeUtilities().findNameSpan((ClassTree)tp.getParentPath().getLeaf());
            }
        } else {
            return null;
        }
        if (span == null) {
            return null;
        }
        return new Range(Utils.createPosition(info.getCompilationUnit().getLineMap(), span[0]), Utils.createPosition(info.getCompilationUnit().getLineMap(), span[1]));
    }

    private static Range toRange(PositionBounds bounds) throws IOException {
        return new Range(new Position(bounds.getBegin().getLine(), bounds.getBegin().getColumn()), new Position(bounds.getEnd().getLine(), bounds.getEnd().getColumn()));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        if (js == null) {
            return CompletableFuture.completedFuture(result);
        }
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = Utils.getOffset(doc, params.getPosition());
                class MOHighligther
                extends MarkOccurrencesHighlighterBase {
                    MOHighligther() {
                    }

                    protected void process(CompilationInfo arg0, Document arg1, SchedulerEvent arg2) {
                        throw new UnsupportedOperationException("Should not be called.");
                    }

                    public List<int[]> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
                        return super.processImpl(info, node, doc, caretPosition);
                    }
                }
                List<int[]> spans = new MOHighligther().processImpl((CompilationInfo)cc, node, doc, offset);
                if (spans != null) {
                    for (int[] span : spans) {
                        result.add(new DocumentHighlight(new Range(Utils.createPosition(cc.getCompilationUnit(), span[0]), Utils.createPosition(cc.getCompilationUnit(), span[1]))));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
        if (js == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (Element tel : cc.getTopLevelElements()) {
                    DocumentSymbol ds = this.element2DocumentSymbol((CompilationInfo)cc, tel);
                    if (ds == null) continue;
                    result.add(Either.forRight((Object)ds));
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private DocumentSymbol element2DocumentSymbol(CompilationInfo info, Element el) throws BadLocationException {
        TreePath path = info.getTrees().getPath(el);
        if (path == null) {
            return null;
        }
        Range range = Utils.treeRange(info, path.getLeaf());
        if (range == null) {
            return null;
        }
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        for (Element element : el.getEnclosedElements()) {
            DocumentSymbol ds = this.element2DocumentSymbol(info, element);
            if (ds == null) continue;
            children.add(ds);
        }
        String simpleName = el.getKind() == ElementKind.CONSTRUCTOR ? el.getEnclosingElement().getSimpleName().toString() : el.getSimpleName().toString();
        return new DocumentSymbol(simpleName, Utils.elementKind2SymbolKind(el.getKind()), range, range, null, children);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Document doc = this.openedDocuments.get(params.getTextDocument().getUri());
        if (doc == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (js == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Map id2Errors = (Map)doc.getProperty("lsp-errors");
        ArrayList<Either> result = new ArrayList<Either>();
        if (id2Errors != null) {
            for (Diagnostic diag : params.getContext().getDiagnostics()) {
                ErrorDescription err = (ErrorDescription)id2Errors.get(diag.getCode().getLeft());
                if (err == null) {
                    this.client.logMessage(new MessageParams(MessageType.Log, "Cannot resolve error, code: " + (String)diag.getCode().getLeft()));
                    continue;
                }
                TreePathHandle[] topLevelHandle = new TreePathHandle[1];
                LazyFixList lfl = err.getFixes();
                if (lfl instanceof CreatorBasedLazyFixList) {
                    try {
                        js.runUserActionTask(cc -> {
                            cc.toPhase(JavaSource.Phase.RESOLVED);
                            ((CreatorBasedLazyFixList)lfl).compute((CompilationInfo)cc, new AtomicBoolean());
                            topLevelHandle[0] = TreePathHandle.create((TreePath)new TreePath(cc.getCompilationUnit()), (CompilationInfo)cc);
                        }, true);
                    }
                    catch (IOException ex) {
                        this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    }
                }
                List<Fix> fixes = this.sortFixes(lfl.getFixes());
                for (Fix f : fixes) {
                    if (f instanceof IncompleteClassPath.ResolveFix) {
                        CodeAction action = new CodeAction(f.getText());
                        action.setDiagnostics(Collections.singletonList(diag));
                        action.setKind("quickfix");
                        action.setCommand(new Command(f.getText(), "java.build.workspace"));
                        result.add(Either.forRight((Object)action));
                    }
                    if (f instanceof ImportClass.FixImport) {
                        final String text = f.getText();
                        CharSequence sortText = ((ImportClass.FixImport)f).getSortText();
                        final ElementHandle toImport = ((ImportClass.FixImport)f).getToImport();
                        f = new JavaFix(topLevelHandle[0], sortText != null ? sortText.toString() : null){

                            protected String getText() {
                                return text;
                            }

                            protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
                                Element resolved = toImport.resolve((CompilationInfo)ctx.getWorkingCopy());
                                if (resolved == null) {
                                    return;
                                }
                                WorkingCopy copy = ctx.getWorkingCopy();
                                CompilationUnitTree cut = GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Collections.singleton(resolved));
                                copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)cut);
                            }
                        }.toEditorFix();
                    }
                    if (f instanceof JavaFixImpl) {
                        try {
                            JavaFix jf = ((JavaFixImpl)f).jf;
                            List<org.eclipse.lsp4j.TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                                wc.toPhase(JavaSource.Phase.RESOLVED);
                                HashMap resourceContentChanges = new HashMap();
                                JavaFixImpl.Accessor.INSTANCE.process(jf, wc, true, resourceContentChanges, new ArrayList());
                            }));
                            TextDocumentEdit te = new TextDocumentEdit(new VersionedTextDocumentIdentifier(params.getTextDocument().getUri(), Integer.valueOf(-1)), edits);
                            CodeAction action = new CodeAction(f.getText());
                            action.setDiagnostics(Collections.singletonList(diag));
                            action.setKind("quickfix");
                            action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)te))));
                            result.add(Either.forRight((Object)action));
                        }
                        catch (IOException ex) {
                            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                        }
                    }
                    if (!(f instanceof CreateFixBase)) continue;
                    try {
                        CreateFixBase cf = (CreateFixBase)f;
                        org.netbeans.api.java.source.ModificationResult changes = cf.getModificationResult();
                        ArrayList<Either> documentChanges = new ArrayList<Either>();
                        Set newFiles = changes.getNewFiles();
                        if (newFiles.size() > 1) {
                            throw new IllegalStateException();
                        }
                        String newFilePath = null;
                        for (File newFile : newFiles) {
                            newFilePath = newFile.getPath();
                            documentChanges.add(Either.forRight((Object)new CreateFile(newFilePath)));
                        }
                        block11: for (FileObject fileObject : changes.getModifiedFileObjects()) {
                            List diffs = changes.getDifferences(fileObject);
                            if (diffs == null) continue;
                            ArrayList<org.eclipse.lsp4j.TextEdit> edits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
                            for (ModificationResult.Difference diff : diffs) {
                                String newText = diff.getNewText();
                                if (diff.getKind() == ModificationResult.Difference.Kind.CREATE) {
                                    if (newFilePath == null) continue block11;
                                    documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(newFilePath, Integer.valueOf(-1)), Collections.singletonList(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(fileObject, 0), Utils.createPosition(fileObject, 0)), newText != null ? newText : "")))));
                                    continue block11;
                                }
                                edits.add(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                            }
                            documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                        }
                        if (documentChanges.isEmpty()) continue;
                        CodeAction codeAction = new CodeAction(f.getText());
                        codeAction.setKind("quickfix");
                        codeAction.setEdit(new WorkspaceEdit(documentChanges));
                        result.add(Either.forRight((Object)codeAction));
                    }
                    catch (IOException ex) {
                        this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    }
                }
            }
        }
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (CodeGenerator codeGenerator : Lookup.getDefault().lookupAll(CodeGenerator.class)) {
                    for (CodeAction codeAction : codeGenerator.getCodeActions((CompilationInfo)cc, params)) {
                        result.add(Either.forRight((Object)codeAction));
                    }
                }
                Range range = params.getRange();
                if (!range.getStart().equals((Object)range.getEnd())) {
                    for (ErrorDescription err : IntroduceHint.computeError((CompilationInfo)cc, (int)Utils.getOffset(doc, range.getStart()), (int)Utils.getOffset(doc, range.getEnd()), new EnumMap(IntroduceKind.class), new EnumMap(IntroduceKind.class), (AtomicBoolean)new AtomicBoolean())) {
                        for (Fix fix : err.getFixes().getFixes()) {
                            if (!(fix instanceof IntroduceFixBase)) continue;
                            try {
                                org.netbeans.api.java.source.ModificationResult changes = ((IntroduceFixBase)fix).getModificationResult();
                                if (changes == null) continue;
                                ArrayList<Either> documentChanges = new ArrayList<Either>();
                                Set fos = changes.getModifiedFileObjects();
                                if (fos.size() != 1) continue;
                                FileObject fileObject = (FileObject)fos.iterator().next();
                                List diffs = changes.getDifferences(fileObject);
                                if (diffs != null) {
                                    ArrayList<org.eclipse.lsp4j.TextEdit> edits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
                                    for (ModificationResult.Difference diff : diffs) {
                                        String newText = diff.getNewText();
                                        edits.add(new org.eclipse.lsp4j.TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                                    }
                                    documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                                }
                                CodeAction codeAction = new CodeAction(fix.getText());
                                codeAction.setKind("refactor.extract");
                                codeAction.setEdit(new WorkspaceEdit(documentChanges));
                                int renameOffset = ((IntroduceFixBase)fix).getNameOffset(changes);
                                if (renameOffset >= 0) {
                                    codeAction.setCommand(new Command("Rename", "java.rename.element.at", Collections.singletonList(renameOffset)));
                                }
                                result.add(Either.forRight((Object)codeAction));
                            }
                            catch (GeneratorUtils.DuplicateMemberException duplicateMemberException) {}
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private List<Fix> sortFixes(Collection<Fix> fixes) {
        ArrayList<Fix> result = new ArrayList<Fix>(fixes);
        Collections.sort(result, new FixComparator());
        return result;
    }

    private static CharSequence getSortText(Fix f) {
        if (f instanceof EnhancedFix) {
            return ((EnhancedFix)f).getSortText();
        }
        return DEFAULT_SORT_TEXT;
    }

    private static int compareText(CharSequence text1, CharSequence text2) {
        int len = Math.min(text1.length(), text2.length());
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = text1.charAt(i);
            if (ch1 == (ch2 = text2.charAt(i))) continue;
            return ch1 - ch2;
        }
        return text1.length() - text2.length();
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(final CodeLensParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        String uri = params.getTextDocument().getUri();
        JavaSource source = this.getJavaSource(uri);
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<? extends CodeLens>> result = new CompletableFuture<List<? extends CodeLens>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                if (!this.upToDateTests.getOrDefault(uri, Boolean.FALSE).booleanValue()) {
                    ArrayList testMethods = new ArrayList();
                    for (ComputeTestMethods.Factory methodsFactory : Lookup.getDefault().lookupAll(ComputeTestMethods.Factory.class)) {
                        testMethods.addAll(methodsFactory.create().computeTestMethods((CompilationInfo)cc));
                    }
                    if (!testMethods.isEmpty()) {
                        String testClassName = null;
                        ArrayList<TestSuiteInfo.TestCaseInfo> tests = new ArrayList<TestSuiteInfo.TestCaseInfo>(testMethods.size());
                        for (TestMethodController.TestMethod testMethod : testMethods) {
                            if (testClassName == null) {
                                testClassName = testMethod.getTestClassName();
                            }
                            String id = testMethod.getTestClassName() + ':' + testMethod.method().getMethodName();
                            String string = testMethod.getTestClassName() + '.' + testMethod.method().getMethodName();
                            int line = Utils.createPosition(cc.getCompilationUnit(), testMethod.start().getOffset()).getLine();
                            tests.add(new TestSuiteInfo.TestCaseInfo(id, testMethod.method().getMethodName(), string, uri, line, "loaded", null));
                        }
                        Integer line = null;
                        Trees trees = cc.getTrees();
                        for (Tree tree : cc.getCompilationUnit().getTypeDecls()) {
                            Element element = trees.getElement(trees.getPath(cc.getCompilationUnit(), tree));
                            if (element == null || !element.getKind().isClass() || !((TypeElement)element).getQualifiedName().contentEquals(testClassName)) continue;
                            line = Utils.createPosition(cc.getCompilationUnit(), (int)trees.getSourcePositions().getStartPosition(cc.getCompilationUnit(), tree)).getLine();
                            break;
                        }
                        this.client.notifyTestProgress(new TestProgressParams(uri, new TestSuiteInfo(testClassName, uri, line, "loaded", tests)));
                        this.upToDateTests.put(uri, Boolean.TRUE);
                    }
                }
                final ArrayList lens = new ArrayList();
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitMethod(MethodTree tree, Void p) {
                        Element el = cc.getTrees().getElement(this.getCurrentPath());
                        if (el != null && el.getKind() == ElementKind.METHOD && SourceUtils.isMainMethod((ExecutableElement)((ExecutableElement)el))) {
                            Range range = Utils.treeRange((CompilationInfo)cc, tree);
                            List<String> arguments = Collections.singletonList(params.getTextDocument().getUri());
                            lens.add(new CodeLens(range, new Command("Run main", "java.run.single", arguments), null));
                            lens.add(new CodeLens(range, new Command("Debug main", "java.debug.single", arguments), null));
                        }
                        return null;
                    }
                }.scan(cc.getCompilationUnit(), null);
                result.complete(lens);
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> formatting(DocumentFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> rangeFormatting(DocumentRangeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends org.eclipse.lsp4j.TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<Range, PrepareRenameResult>> prepareRename(PrepareRenameParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Either.forLeft(null));
        }
        JavaSource source = this.getJavaSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Either.forLeft(null));
        }
        CompletableFuture<Either<Range, PrepareRenameResult>> result = new CompletableFuture<Either<Range, PrepareRenameResult>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int pos = Utils.getOffset(doc, params.getPosition());
                TreePath path = cc.getTreeUtilities().pathFor(pos);
                RenameRefactoring ref = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                ref.setNewName("any");
                boolean hasFatalProblem = false;
                for (Problem p = ref.fastCheckParameters(); p != null; p = p.getNext()) {
                    hasFatalProblem |= p.isFatal();
                }
                if (hasFatalProblem) {
                    result.complete(null);
                } else {
                    TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    int d = ts.move(pos);
                    if (ts.moveNext()) {
                        if (d == 0 && ts.token().id() != JavaTokenId.IDENTIFIER) {
                            ts.movePrevious();
                        }
                        Range r = new Range(Utils.createPosition(cc.getCompilationUnit(), ts.offset()), Utils.createPosition(cc.getCompilationUnit(), ts.offset() + ts.token().length()));
                        result.complete(Either.forRight((Object)new PrepareRenameResult(r, ts.token().text().toString())));
                    } else {
                        result.complete(null);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(new WorkspaceEdit());
        }
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<WorkspaceEdit> result = new CompletableFuture<WorkspaceEdit>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getJavaSource(params.getTextDocument().getUri());
            if (js == null) {
                result.completeExceptionally(new FileNotFoundException(params.getTextDocument().getUri()));
                return;
            }
            try {
                RenameRefactoring[] refactoring = new RenameRefactoring[1];
                js.runUserActionTask(cc -> {
                    ElementHandle handle;
                    FileObject f;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset(doc, params.getPosition()));
                    ArrayList<Object> lookupContent = new ArrayList<Object>();
                    lookupContent.add(TreePathHandle.create((TreePath)path, (CompilationInfo)cc));
                    Element selected = cc.getTrees().getElement(path);
                    if (selected instanceof TypeElement && !((TypeElement)selected).getNestingKind().isNested() && (f = SourceUtils.getFile((ElementHandle)(handle = ElementHandle.create((Element)((TypeElement)selected))), (ClasspathInfo)cc.getClasspathInfo())) != null && selected.getSimpleName().toString().equals(f.getName())) {
                        lookupContent.add(f);
                    }
                    refactoring[0] = new RenameRefactoring(Lookups.fixed((Object[])lookupContent.toArray(new Object[0])));
                    refactoring[0].setNewName(params.getNewName());
                    refactoring[0].setSearchInComments(true);
                }, true);
                if (cancel.get()) {
                    return;
                }
                cancelCallback[0] = () -> refactoring[0].cancelRequest();
                RefactoringSession session = RefactoringSession.create((String)"Rename");
                Problem p = refactoring[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = refactoring[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = refactoring[0].prepare(session);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                ArrayList<Either> resultChanges = new ArrayList<Either>();
                List transactions = APIAccessor.DEFAULT.getCommits(session);
                ArrayList<org.netbeans.api.java.source.ModificationResult> results = new ArrayList<org.netbeans.api.java.source.ModificationResult>();
                for (Transaction t : transactions) {
                    if (t instanceof RefactoringCommit) {
                        RefactoringCommit c = (RefactoringCommit)t;
                        for (ModificationResult refResult : SPIAccessor.DEFAULT.getTransactions(c)) {
                            if (refResult instanceof JavaModificationResult) {
                                results.add(((JavaModificationResult)refResult).delegate);
                                continue;
                            }
                            throw new IllegalStateException(refResult.getClass().toString());
                        }
                        continue;
                    }
                    throw new IllegalStateException(t.getClass().toString());
                }
                for (org.netbeans.api.java.source.ModificationResult mr : results) {
                    for (FileObject modified : mr.getModifiedFileObjects()) {
                        resultChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(params.getTextDocument().getUri(), Integer.valueOf(-1)), TextDocumentServiceImpl.fileModifications(mr, modified, null))));
                    }
                }
                List fileChanges = APIAccessor.DEFAULT.getFileChanges(session);
                for (RefactoringElementImplementation rei : fileChanges) {
                    if (rei instanceof FileRenamePlugin.RenameFile) {
                        String oldURI = params.getTextDocument().getUri();
                        int dot = oldURI.lastIndexOf(46);
                        int slash = oldURI.lastIndexOf(47);
                        String newURI = oldURI.substring(0, slash + 1) + params.getNewName() + oldURI.substring(dot);
                        RenameFile op = new RenameFile(oldURI, newURI);
                        resultChanges.add(Either.forRight((Object)op));
                        continue;
                    }
                    throw new IllegalStateException(rei.getClass().toString());
                }
                for (RefactoringElement refactoringElement : session.getRefactoringElements()) {
                }
                session.finished();
                result.complete(new WorkspaceEdit(resultChanges));
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        JavaSource source = this.getJavaSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<FoldingRange>> result = new CompletableFuture<List<FoldingRange>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                JavaElementFoldVisitor v = new JavaElementFoldVisitor((CompilationInfo)cc, cc.getCompilationUnit(), cc.getTrees().getSourcePositions(), doc, (JavaElementFoldVisitor.FoldCreator)new JavaElementFoldVisitor.FoldCreator<FoldingRange>(){

                    public FoldingRange createImportsFold(int start, int end) {
                        return this.createFold(start, end, "imports");
                    }

                    public FoldingRange createInnerClassFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createCodeBlockFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createJavadocFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    public FoldingRange createInitialCommentFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    private FoldingRange createFold(int start, int end, String kind) {
                        Position startPos = Utils.createPosition(cc.getCompilationUnit(), start);
                        Position endPos = Utils.createPosition(cc.getCompilationUnit(), end);
                        FoldingRange range = new FoldingRange(startPos.getLine(), endPos.getLine());
                        range.setStartCharacter(Integer.valueOf(startPos.getCharacter()));
                        range.setEndCharacter(Integer.valueOf(endPos.getCharacter()));
                        range.setKind(kind);
                        return range;
                    }
                });
                v.checkInitialFold();
                v.scan((Tree)cc.getCompilationUnit(), null);
                result.complete(v.getFolds());
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        try {
            FileObject file = this.fromURI(params.getTextDocument().getUri(), true);
            if (file == null) {
                return;
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.getDocument();
            String text = params.getTextDocument().getText();
            try {
                if (doc == null) {
                    doc = ec.openDocument();
                }
                if (!text.contentEquals(doc.getText(0, doc.getLength()))) {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, text, null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            this.openedDocuments.put(params.getTextDocument().getUri(), doc);
            this.server.asyncOpenFileOwner(file).thenRun(() -> this.runDiagnoticTasks(params.getTextDocument().getUri()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didOpen", params);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        this.upToDateTests.put(uri, Boolean.FALSE);
        Document doc = this.openedDocuments.get(uri);
        if (doc != null) {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
                    try {
                        int start = Utils.getOffset(doc, change.getRange().getStart());
                        int end = Utils.getOffset(doc, change.getRange().getEnd());
                        doc.remove(start, end - start);
                        doc.insertString(start, change.getText(), null);
                    }
                    catch (BadLocationException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
        }
        this.runDiagnoticTasks(params.getTextDocument().getUri());
        TextDocumentServiceImpl.reportNotificationDone("didChange", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didClose(DidCloseTextDocumentParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            this.upToDateTests.remove(uri);
            this.openedDocuments.remove(uri);
            FileObject file = this.fromURI(uri, true);
            if (file == null) {
                return;
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            ec.close();
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didClose", params);
        }
    }

    public void didSave(DidSaveTextDocumentParams arg0) {
    }

    CompletableFuture<List<? extends Location>> superImplementations(String uri, Position position) {
        JavaSource js = this.getJavaSource(uri);
        ArrayList targets = new ArrayList();
        LineMap[] thisFileLineMap = new LineMap[1];
        try {
            if (js != null) {
                js.runUserActionTask(cc -> {
                    Trees trees;
                    Element resolved;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    int offset = Utils.getOffset(doc, position);
                    TreeUtilities treeUtilities = cc.getTreeUtilities();
                    TreePath path = treeUtilities.getPathElementOfKind(EnumSet.of(Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.METHOD), treeUtilities.pathFor(offset));
                    if (path != null && (resolved = (trees = cc.getTrees()).getElement(path)) != null) {
                        if (resolved.getKind() == ElementKind.METHOD) {
                            Map overriding = new ComputeOverriding(new AtomicBoolean()).process((CompilationInfo)cc);
                            List eds = (List)overriding.get(ElementHandle.create((Element)resolved));
                            if (eds != null) {
                                for (ElementDescription ed : eds) {
                                    long startPos;
                                    Element el = ed.getHandle().resolve((CompilationInfo)cc);
                                    TreePath tp = trees.getPath(el);
                                    long l = startPos = tp != null && cc.getCompilationUnit() == tp.getCompilationUnit() ? trees.getSourcePositions().getStartPosition(cc.getCompilationUnit(), tp.getLeaf()) : -1L;
                                    if (startPos >= 0L) {
                                        long endPos = trees.getSourcePositions().getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                                        targets.add(new GoToSupport.GoToTarget(cc.getSnapshot().getOriginalOffset((int)startPos), cc.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan((Tree)tp.getLeaf(), (TreeUtilities)treeUtilities), null, null, null, ed.getDisplayName(), true));
                                        continue;
                                    }
                                    TypeElement te = el != null ? cc.getElementUtilities().outermostTypeElement(el) : null;
                                    targets.add(new GoToSupport.GoToTarget(-1, -1, null, ed.getOriginalCPInfo(), ed.getHandle(), TextDocumentServiceImpl.getResourceName(te, ed.getHandle()), ed.getDisplayName(), true));
                                }
                            }
                        } else if (resolved.getKind().isClass() || resolved.getKind().isInterface()) {
                            ArrayList<? extends TypeMirror> superTypes = new ArrayList<TypeMirror>();
                            superTypes.add(((TypeElement)resolved).getSuperclass());
                            superTypes.addAll(((TypeElement)resolved).getInterfaces());
                            for (TypeMirror typeMirror : superTypes) {
                                long startPos;
                                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                                Element el = ((DeclaredType)typeMirror).asElement();
                                TreePath tp = trees.getPath(el);
                                long l = startPos = tp != null && cc.getCompilationUnit() == tp.getCompilationUnit() ? trees.getSourcePositions().getStartPosition(cc.getCompilationUnit(), tp.getLeaf()) : -1L;
                                if (startPos >= 0L) {
                                    long endPos = trees.getSourcePositions().getEndPosition(cc.getCompilationUnit(), tp.getLeaf());
                                    targets.add(new GoToSupport.GoToTarget(cc.getSnapshot().getOriginalOffset((int)startPos), cc.getSnapshot().getOriginalOffset((int)endPos), GoToSupport.getNameSpan((Tree)tp.getLeaf(), (TreeUtilities)treeUtilities), null, null, null, cc.getElementUtilities().getElementName(el, false).toString(), true));
                                    continue;
                                }
                                TypeElement te = el != null ? cc.getElementUtilities().outermostTypeElement(el) : null;
                                targets.add(new GoToSupport.GoToTarget(-1, -1, null, cc.getClasspathInfo(), ElementHandle.create((Element)el), TextDocumentServiceImpl.getResourceName(te, null), cc.getElementUtilities().getElementName(el, false).toString(), true));
                            }
                        }
                        thisFileLineMap[0] = cc.getCompilationUnit().getLineMap();
                    }
                }, true);
            }
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        CompletableFuture[] futures = (CompletableFuture[])targets.stream().map(target -> this.gotoTarget2Location(uri, (GoToSupport.GoToTarget)target, thisFileLineMap[0])).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(value -> {
            ArrayList<Location> locations = new ArrayList<Location>(futures.length);
            for (CompletableFuture future : futures) {
                Location location = future.getNow(null);
                if (location == null) continue;
                locations.add(location);
            }
            return locations;
        });
    }

    private CompletableFuture<Location> gotoTarget2Location(String uri, GoToSupport.GoToTarget target, LineMap lineMap) {
        Location location = null;
        if (target != null && target.success) {
            if (target.offsetToOpen < 0) {
                CompletableFuture future = ElementOpen.getLocation((ClasspathInfo)target.cpInfo, (ElementHandle)target.elementToOpen, (String)target.resourceName);
                return future.thenApply(loc -> {
                    if (loc != null) {
                        FileObject fo = loc.getFileObject();
                        return new Location(Utils.toUri(fo), new Range(Utils.createPosition(fo, loc.getStartOffset()), Utils.createPosition(fo, loc.getEndOffset())));
                    }
                    return null;
                });
            }
            int start = target.nameSpan != null ? target.nameSpan[0] : target.offsetToOpen;
            int end = target.nameSpan != null ? target.nameSpan[1] : target.endPos;
            location = new Location(uri, new Range(Utils.createPosition(lineMap, start), Utils.createPosition(lineMap, end)));
        }
        return CompletableFuture.completedFuture(location);
    }

    private void runDiagnoticTasks(String uri) {
        if (this.server.openedProjects().getNow(null) == null) {
            return;
        }
        this.diagnosticTasks.computeIfAbsent(uri, u -> BACKGROUND_TASKS.create(() -> {
            this.computeDiags((String)u, (info, doc) -> {
                ErrorHintsProvider ehp = new ErrorHintsProvider();
                return ehp.computeErrors(info, doc, "text/x-java");
            }, "errors", false);
            BACKGROUND_TASKS.create(() -> this.computeDiags((String)u, (info, doc) -> {
                Set disabled = Utilities.disableErrors((FileObject)info.getFileObject());
                if (disabled.size() == Severity.values().length) {
                    return Collections.emptyList();
                }
                return new HintsInvoker(HintsSettings.getGlobalSettings(), new AtomicBoolean()).computeHints(info).stream().filter(ed -> !disabled.contains(ed.getSeverity())).collect(Collectors.toList());
            }, "hints", true)).schedule(500);
        })).schedule(500);
    }

    private void computeDiags(final String uri, final ProduceErrors produceErrors, final String keyPrefix, boolean update) {
        try {
            FileObject file = this.fromURI(uri);
            if (file == null) {
                return;
            }
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            final StyledDocument doc = ec.openDocument();
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator it) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)it.getParserResult());
                    if (cc != null) {
                        cc.toPhase(JavaSource.Phase.RESOLVED);
                        HashMap<String, ErrorDescription> id2Errors = new HashMap<String, ErrorDescription>();
                        ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
                        int idx = 0;
                        List<Object> errors = produceErrors.computeErrors((CompilationInfo)cc, doc);
                        if (errors == null) {
                            errors = Collections.emptyList();
                        }
                        for (ErrorDescription err : errors) {
                            Diagnostic diag = new Diagnostic(new Range(Utils.createPosition(cc.getCompilationUnit(), err.getRange().getBegin().getOffset()), Utils.createPosition(cc.getCompilationUnit(), err.getRange().getEnd().getOffset())), err.getDescription());
                            switch (err.getSeverity()) {
                                case ERROR: {
                                    diag.setSeverity(DiagnosticSeverity.Error);
                                    break;
                                }
                                case VERIFIER: 
                                case WARNING: {
                                    diag.setSeverity(DiagnosticSeverity.Warning);
                                    break;
                                }
                                case HINT: {
                                    diag.setSeverity(DiagnosticSeverity.Hint);
                                    break;
                                }
                                default: {
                                    diag.setSeverity(DiagnosticSeverity.Information);
                                }
                            }
                            String id = keyPrefix + ":" + idx++ + "-" + err.getId();
                            diag.setCode(id);
                            id2Errors.put(id, err);
                            diags.add(diag);
                        }
                        doc.putProperty("lsp-errors-" + keyPrefix, id2Errors);
                        doc.putProperty("lsp-errors-diags-" + keyPrefix, diags);
                        HashMap mergedId2Errors = new HashMap();
                        ArrayList mergedDiags = new ArrayList();
                        for (String k : ERROR_KEYS) {
                            List prevDiags;
                            Map prevErrors = (Map)doc.getProperty("lsp-errors-" + k);
                            if (prevErrors != null) {
                                mergedId2Errors.putAll(prevErrors);
                            }
                            if ((prevDiags = (List)doc.getProperty("lsp-errors-diags-" + k)) == null) continue;
                            mergedDiags.addAll(prevDiags);
                        }
                        doc.putProperty("lsp-errors", mergedId2Errors);
                        doc.putProperty("lsp-errors-diags", mergedDiags);
                        TextDocumentServiceImpl.this.publishDiagnostics(uri, mergedDiags);
                    }
                }
            });
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private FileObject fromURI(String uri) {
        return this.fromURI(uri, false);
    }

    private FileObject fromURI(String uri, boolean tryHard) {
        try {
            FileObject file = Utils.fromUri(uri);
            if (tryHard) {
                if (file != null) {
                    file.refresh(true);
                } else {
                    URI parentU = URI.create(uri).resolve("..").normalize();
                    FileObject parentF = Utils.fromUri(parentU.toString());
                    if (parentF != null) {
                        parentF.refresh(true);
                        file = Utils.fromUri(uri);
                    }
                }
            }
            if (file != null && file.isValid()) {
                return file;
            }
            this.missingFileDiscovered(uri);
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.WARNING, "Invalid file URL: " + uri, ex);
        }
        return null;
    }

    private void missingFileDiscovered(String uri) {
        if (this.openedDocuments.get(uri) != null) {
            return;
        }
        Instant last = this.knownFiles.remove(uri);
        if (last == null) {
            return;
        }
        this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, new ArrayList()));
    }

    private void publishDiagnostics(String uri, List<Diagnostic> mergedDiags) {
        this.knownFiles.put(uri, Instant.now());
        this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, mergedDiags));
    }

    @CheckForNull
    public JavaSource getJavaSource(String fileUri) {
        Document doc = this.openedDocuments.get(fileUri);
        if (doc == null) {
            FileObject file = this.fromURI(fileUri);
            if (file == null) {
                return null;
            }
            return JavaSource.forFileObject((FileObject)file);
        }
        return JavaSource.forDocument((Document)doc);
    }

    @CheckForNull
    public Source getSource(String fileUri) {
        Document doc = this.openedDocuments.get(fileUri);
        if (doc == null) {
            FileObject file = this.fromURI(fileUri);
            if (file == null) {
                return null;
            }
            return Source.create((FileObject)file);
        }
        return Source.create((Document)doc);
    }

    public static List<org.eclipse.lsp4j.TextEdit> modify2TextEdits(JavaSource js, Task<WorkingCopy> task) throws IOException {
        FileObject[] file = new FileObject[1];
        LineMap[] lm = new LineMap[1];
        org.netbeans.api.java.source.ModificationResult changes = js.runModificationTask(wc -> {
            task.run(wc);
            file[0] = wc.getFileObject();
            lm[0] = wc.getCompilationUnit().getLineMap();
        });
        return TextDocumentServiceImpl.fileModifications(changes, file[0], lm[0]);
    }

    private static List<org.eclipse.lsp4j.TextEdit> fileModifications(org.netbeans.api.java.source.ModificationResult changes, FileObject file, LineMap lm) {
        List diffs = changes.getDifferences(file);
        if (diffs == null) {
            return Collections.emptyList();
        }
        ArrayList<org.eclipse.lsp4j.TextEdit> edits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        IntFunction<Position> offset2Position = lm != null ? pos -> Utils.createPosition(lm, pos) : pos -> Utils.createPosition(file, pos);
        for (ModificationResult.Difference diff : diffs) {
            String newText = diff.getNewText();
            edits.add(new org.eclipse.lsp4j.TextEdit(new Range(offset2Position.apply(diff.getStartPosition().getOffset()), offset2Position.apply(diff.getEndPosition().getOffset())), newText != null ? newText : ""));
        }
        return edits;
    }

    private static String getResourceName(TypeElement te, ElementHandle<?> handle) {
        String qualifiedName = null;
        if (te != null) {
            qualifiedName = te.getQualifiedName().toString();
        } else if (handle != null && (handle.getKind().isClass() || handle.getKind().isInterface())) {
            qualifiedName = handle.getQualifiedName();
        }
        return qualifiedName != null ? qualifiedName.replace('.', '/') + ".class" : null;
    }

    private static void reportNotificationDone(String s, Object parameter) {
        if (HOOK_NOTIFICATION != null) {
            HOOK_NOTIFICATION.accept(s, parameter);
        }
    }

    private static interface ProduceErrors {
        public List<ErrorDescription> computeErrors(CompilationInfo var1, Document var2) throws IOException;
    }

    private static final class FixComparator
    implements Comparator<Fix> {
        private FixComparator() {
        }

        @Override
        public int compare(Fix o1, Fix o2) {
            return TextDocumentServiceImpl.compareText(TextDocumentServiceImpl.getSortText(o1), TextDocumentServiceImpl.getSortText(o2));
        }
    }

    public static final class CompletionData {
        public String uri;
        public int index;

        public CompletionData() {
        }

        public CompletionData(String uri, int index) {
            this.uri = uri;
            this.index = index;
        }

        public String toString() {
            return "CompletionData{uri=" + this.uri + ", index=" + this.index + '}';
        }
    }

    public static final class RefreshDocument
    implements ActiveDocumentProvider.IndexingAware {
        private final Set<TextDocumentServiceImpl> delegates = new WeakSet();

        public synchronized void register(TextDocumentServiceImpl delegate) {
            this.delegates.add(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indexingComplete(Set<URL> indexedRoots) {
            TextDocumentServiceImpl[] textDocumentServiceImplArray = this;
            synchronized (this) {
                TextDocumentServiceImpl[] delegates = this.delegates.toArray(new TextDocumentServiceImpl[this.delegates.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (TextDocumentServiceImpl delegate : delegates) {
                    delegate.reRunDiagnostics();
                }
                return;
            }
        }
    }
}

