/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.JLabel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public abstract class SaveableSectionInnerPanel
extends SectionInnerPanel {
    private EnterKeyListener listener;

    public SaveableSectionInnerPanel(SectionView view) {
        super(view);
    }

    protected boolean isClient(Node node) {
        Client client = (Client)node.getLookup().lookup(Client.class);
        if (client != null) {
            return true;
        }
        JaxWsService service = (JaxWsService)node.getLookup().lookup(JaxWsService.class);
        return service != null && !service.isServiceProvider();
    }

    protected void setModelDirty(WSDLModel model) {
        try {
            ModelSource ms = model.getModelSource();
            FileObject fo = (FileObject)ms.getLookup().lookup(FileObject.class);
            DataObject wsdlDO = DataObject.find((FileObject)fo);
            if (!wsdlDO.isModified()) {
                wsdlDO.setModified(true);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    protected void disableEnterKey() {
        Component[] components = this.getComponents();
        this.listener = new EnterKeyListener();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!component.isFocusable() || component instanceof JLabel) continue;
            KeyListener kl = (KeyListener)WeakListeners.create(KeyListener.class, (EventListener)this.listener, (Object)component);
            component.addKeyListener(kl);
        }
    }

    public abstract void save();

    public boolean jaxwsIsDirty() {
        return false;
    }

    public abstract boolean wsdlIsDirty();

    private static class EnterKeyListener
    extends KeyAdapter {
        private EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
            }
        }
    }
}

