/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.customizer.RunJarPanel;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.runjar.PropertySplitter;

public final class MavenExecuteUtils {
    public static final String RUN_EXPLICIT_PROCESSED = "NbIde.ExplicitParametersApplied";
    public static final String RUN_VM_PARAMS = "exec.vmArgs";
    public static final String RUN_MAIN_CLASS = "exec.mainClass";
    public static final String RUN_APP_PARAMS = "exec.appArgs";
    public static final String RUN_PARAMS = "exec.args";
    public static final String RUN_WORKDIR = "exec.workingdir";
    private static final String RUN_VM_PARAMS_TOKEN = "${exec.vmArgs}";
    private static final String RUN_APP_PARAMS_TOKEN = "${exec.appArgs}";
    private static final String RUN_MAIN_CLASS_TOKEN = "${exec.mainClass}";
    static final String PACKAGE_CLASS_NAME_TOKEN = "${packageClassName}";
    public static final String EXEC_ARGS_CLASSPATH_TOKEN = "-classpath %classpath";
    public static final String DEFAULT_EXEC_ARGS_CLASSPATH = "-classpath %classpath ${packageClassName}";
    static final String DEFAULT_DEBUG_PARAMS = "-agentlib:jdwp=transport=dt_socket,server=n,address=${jpda.address}";
    static final String DEFAULT_EXEC_ARGS_CLASSPATH2 = "${exec.vmArgs} -classpath %classpath ${exec.mainClass} ${exec.appArgs}";
    public static final String PROFILE_CMD = "profile";

    public static String[] splitCommandLine(String line) {
        if (line == null) {
            return new String[0];
        }
        String l = line.trim();
        if (l.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String part : MavenExecuteUtils.propertySplitter(l, true)) {
            result.add(part);
        }
        return result.toArray(new String[result.size()]);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static String doesNotSpecifyCustomExecArgs(NetbeansActionMapping mapp) {
        return MavenExecuteUtils.doesNotSpecifyCustomExecArgs(true, mapp.getProperties());
    }

    private static boolean equalsOrIncludes(boolean exact, String text, String toFind) {
        if (exact) {
            return text.equals(toFind);
        }
        return text.contains(toFind);
    }

    public static String doesNotSpecifyCustomExecArgs(boolean exact, Map<? extends String, ? extends String> props) {
        String mainClass;
        String execArgs = props.get(RUN_PARAMS);
        String replacedMainClass = props.get(RUN_MAIN_CLASS);
        boolean secondTry = replacedMainClass != null && execArgs.contains(PACKAGE_CLASS_NAME_TOKEN);
        String template = DEFAULT_EXEC_ARGS_CLASSPATH;
        if (MavenExecuteUtils.equalsOrIncludes(exact, execArgs, template)) {
            return template;
        }
        if (secondTry && MavenExecuteUtils.equalsOrIncludes(exact, execArgs, template = template.replace(PACKAGE_CLASS_NAME_TOKEN, replacedMainClass))) {
            return template;
        }
        template = DEFAULT_EXEC_ARGS_CLASSPATH2;
        if (!MavenExecuteUtils.equalsOrIncludes(exact, execArgs, template)) {
            if (!secondTry) {
                return null;
            }
            if (!MavenExecuteUtils.equalsOrIncludes(exact, execArgs, template = template.replace(PACKAGE_CLASS_NAME_TOKEN, replacedMainClass))) {
                return null;
            }
        }
        if (!exact) {
            return template;
        }
        if (MavenExecuteUtils.isNullOrEmpty(props.get(RUN_APP_PARAMS)) && MavenExecuteUtils.isNullOrEmpty(props.get(RUN_VM_PARAMS)) && ((mainClass = props.get(RUN_MAIN_CLASS)) == null || "".equals(mainClass) || PACKAGE_CLASS_NAME_TOKEN.equals(mainClass))) {
            return template;
        }
        return null;
    }

    public static ExecutionEnvHelper createExecutionEnvHelper(NbMavenProjectImpl project, NetbeansActionMapping run, NetbeansActionMapping debug, NetbeansActionMapping profile, ActionToGoalMapping goalMappings) {
        return new ExecutionEnvHelper(project, run, debug, profile, goalMappings);
    }

    public static String joinParameters(String ... params) {
        if (params == null) {
            return "";
        }
        return MavenExecuteUtils.joinParameters(Arrays.asList(params));
    }

    private static boolean isQuoteChar(char c) {
        return c == '\'' || c == '\"';
    }

    public static String joinParameters(List<String> params) {
        StringBuilder sb = new StringBuilder();
        for (String s : params) {
            char c;
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (s.length() > 1 && MavenExecuteUtils.isQuoteChar(c = s.charAt(0)) && s.charAt(s.length() - 1) == c) {
                sb.append(s);
                continue;
            }
            if (!s.contains(" ")) {
                sb.append(s.replace("'", "\\'").replace("\"", "\\\""));
                continue;
            }
            sb.append("\"").append(s.replace("\"", "\\\"")).append("\"");
        }
        return sb.toString();
    }

    public static List<String> extractDebugJVMOptions(String argLine) {
        Iterable<String> split = MavenExecuteUtils.propertySplitter(argLine, true);
        ArrayList<String> toRet = new ArrayList<String>();
        for (String arg : split) {
            if ("-Xdebug".equals(arg) || "-Djava.compiler=none".equals(arg) || "-Xnoagent".equals(arg) || arg.startsWith("-Xrunjdwp") || arg.equals("-agentlib:jdwp") || arg.startsWith("-agentlib:jdwp=") || arg.trim().length() == 0) continue;
            toRet.add(arg);
        }
        return toRet;
    }

    public static String[] splitAll(String argline, boolean filterClassPath) {
        String args;
        String jvm = argline == null ? null : MavenExecuteUtils.splitJVMParams(argline, false);
        String mainClazz = argline == null ? null : MavenExecuteUtils.splitMainClass(argline);
        String string = args = argline == null ? null : MavenExecuteUtils.splitParams(argline);
        if (filterClassPath && jvm != null && jvm.contains(EXEC_ARGS_CLASSPATH_TOKEN)) {
            jvm = jvm.replace(EXEC_ARGS_CLASSPATH_TOKEN, "");
        }
        if (mainClazz != null && mainClazz.equals(PACKAGE_CLASS_NAME_TOKEN)) {
            mainClazz = "";
        }
        return new String[]{jvm != null ? jvm : "", mainClazz != null ? mainClazz : "", args != null ? args : ""};
    }

    public static String splitJVMParams(String line) {
        return MavenExecuteUtils.splitJVMParams(line, false);
    }

    @NonNull
    public static String splitJVMParams(String line, boolean newLines) {
        PropertySplitter ps = new PropertySplitter(line);
        ps.setSeparator(' ');
        String s = ps.nextPair();
        String jvms = "";
        while (s != null) {
            if (s.startsWith("-") || s.startsWith("\"-") || s.contains("%classpath")) {
                jvms = s.contains("%classpath") ? jvms + " " + s : jvms + (jvms.isEmpty() ? "" : (newLines ? "\n" : " ")) + s;
            } else {
                if (s.equals(PACKAGE_CLASS_NAME_TOKEN) || s.equals(RUN_MAIN_CLASS_TOKEN) || s.matches("[\\w]+[\\.]{0,1}[\\w\\.]*")) break;
                jvms = jvms + " " + s;
            }
            s = ps.nextPair();
        }
        return jvms.trim();
    }

    @NonNull
    public static String splitMainClass(String line) {
        PropertySplitter ps = new PropertySplitter(line);
        ps.setSeparator(' ');
        String s = ps.nextPair();
        while (s != null) {
            if (s.startsWith("-") || s.contains("%classpath")) {
                s = ps.nextPair();
                continue;
            }
            if (s.equals(PACKAGE_CLASS_NAME_TOKEN) || s.equals(RUN_MAIN_CLASS_TOKEN) || s.matches("[\\w]+[\\.]{0,1}[\\w\\.]*")) {
                return s;
            }
            Logger.getLogger(RunJarPanel.class.getName()).fine("failed splitting main class from=" + line);
            s = ps.nextPair();
        }
        return "";
    }

    @NonNull
    public static String splitParams(String line) {
        int argsIndex = line.indexOf("%args");
        if (argsIndex > -1) {
            return line.substring(argsIndex + "%args".length()).trim();
        }
        String main = MavenExecuteUtils.splitMainClass(line);
        if (main.isEmpty()) {
            return "";
        }
        int i = line.indexOf(main);
        if (i > -1) {
            return line.substring(i + main.length()).trim();
        }
        return "";
    }

    public static Iterable<String> propertySplitter(String line) {
        return MavenExecuteUtils.propertySplitter(line, true);
    }

    public static Iterable<String> propertySplitter(final String line, final boolean outputQuotes) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                class SplitIt
                implements Iterator<String> {
                    private final PropertySplitter spl;
                    private String nextPair;
                    final /* synthetic */ String val$line;
                    final /* synthetic */ boolean val$outputQuotes;

                    public SplitIt() {
                        this.val$line = string;
                        this.val$outputQuotes = bl;
                        this.spl = new PropertySplitter(this.val$line);
                        this.spl.setSeparator(' ');
                        this.spl.setOutputQuotes(this.val$outputQuotes);
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.nextPair == null) {
                            this.nextPair = this.spl.nextPair();
                        }
                        return this.nextPair != null;
                    }

                    @Override
                    public String next() {
                        if (this.nextPair == null) {
                            this.nextPair = this.spl.nextPair();
                        }
                        String s = this.nextPair;
                        this.nextPair = null;
                        if (s != null) {
                            return s;
                        }
                        throw new NoSuchElementException();
                    }
                }
                return new SplitIt(line, outputQuotes);
            }
        };
    }

    public static final class ExecutionEnvHelper {
        private final ActionToGoalMapping goalMappings;
        private final NbMavenProjectImpl project;
        private String oldAllParams;
        private String oldVmParams;
        private String oldAppParams;
        private String oldWorkDir;
        private String oldMainClass;
        private boolean currentRun;
        private boolean currentDebug;
        private boolean currentProfile;
        private String vmParams;
        private String appParams;
        private String workDir;
        private String mainClass;
        private NetbeansActionMapping run;
        private NetbeansActionMapping debug;
        private NetbeansActionMapping profile;
        private boolean mergedConfig;
        private boolean modified;

        ExecutionEnvHelper(NbMavenProjectImpl project, NetbeansActionMapping run, NetbeansActionMapping debug, NetbeansActionMapping profile, ActionToGoalMapping goalMappings) {
            this.project = project;
            this.goalMappings = goalMappings;
            this.run = run;
            this.debug = debug;
            this.profile = profile;
        }

        private String fallbackParams(String paramName, boolean stripDebug) {
            String val;
            String string = val = this.run != null ? this.run.getProperties().get(paramName) : null;
            if (val == null && this.debug != null && (val = this.debug.getProperties().get(paramName)) != null && stripDebug) {
                val = String.join((CharSequence)" ", MavenExecuteUtils.extractDebugJVMOptions(val));
            }
            if (val == null && this.profile != null) {
                val = this.profile.getProperties().get(paramName);
            }
            return val == null ? "" : val.trim();
        }

        private String appendIfNotEmpty(String a, String b) {
            if (a == null || a.isEmpty()) {
                return b;
            }
            if (b == null || b.isEmpty()) {
                return a;
            }
            return a + " " + b;
        }

        public ActionToGoalMapping getGoalMappings() {
            return this.goalMappings;
        }

        public boolean isModified() {
            return this.modified;
        }

        public boolean isValid() {
            return this.currentRun && this.currentDebug && this.currentProfile;
        }

        public boolean isCurrentRun() {
            return this.currentRun;
        }

        public boolean isCurrentDebug() {
            return this.currentDebug;
        }

        public boolean isCurrentProfile() {
            return this.currentProfile;
        }

        public void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public void setVmParams(String vmParams) {
            this.vmParams = vmParams;
        }

        public void setAppParams(String appParams) {
            this.appParams = appParams;
        }

        public NbMavenProjectImpl getProject() {
            return this.project;
        }

        public String getWorkDir() {
            return this.oldWorkDir;
        }

        public void setWorkDir(String workDir) {
            this.workDir = workDir;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public NetbeansActionMapping getRun() {
            return this.run;
        }

        public NetbeansActionMapping getProfile() {
            return this.profile;
        }

        public String getAllParams() {
            return this.oldAllParams;
        }

        public String getVmParams() {
            return this.vmParams;
        }

        public String getAppParams() {
            return this.appParams;
        }

        private NetbeansActionMapping getMapping(String a) {
            NetbeansActionMapping m = ActionToGoalUtils.getDefaultMapping(a, this.project);
            return m;
        }

        public void loadFromProject() {
            if (this.run == null) {
                this.run = this.getMapping("run");
            }
            if (this.debug == null) {
                this.debug = this.getMapping("debug");
            }
            if (this.profile == null) {
                this.profile = this.getMapping(MavenExecuteUtils.PROFILE_CMD);
            }
            this.currentRun = this.checkNewMapping(this.run);
            this.currentDebug = this.checkNewMapping(this.debug);
            this.currentProfile = this.checkNewMapping(this.profile);
            this.oldWorkDir = this.fallbackParams(MavenExecuteUtils.RUN_WORKDIR, false);
            this.oldAllParams = this.fallbackParams(MavenExecuteUtils.RUN_PARAMS, false);
            this.oldVmParams = this.fallbackParams(MavenExecuteUtils.RUN_VM_PARAMS, true);
            this.oldAppParams = this.fallbackParams(MavenExecuteUtils.RUN_APP_PARAMS, false);
            this.oldMainClass = this.fallbackParams(MavenExecuteUtils.RUN_MAIN_CLASS, false);
            this.mergedConfig = this.oldVmParams.isEmpty() && this.oldAppParams.isEmpty() && this.oldMainClass.isEmpty();
            this.appendVMParamsFromOldParams();
            this.addAppParamsFromOldParams();
            this.loadMainClass();
            this.workDir = this.oldWorkDir;
            this.vmParams = this.oldVmParams;
            this.appParams = this.oldAppParams;
            this.mainClass = this.oldMainClass;
        }

        private String eraseTokens(String original, boolean withNewlines, String ... tokens) {
            StringBuilder sb = new StringBuilder();
            for (String p : tokens) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(Pattern.quote(p));
                if (!withNewlines) continue;
                sb.append("\\n?");
            }
            return original.replaceAll(sb.toString(), "").trim();
        }

        private void appendVMParamsFromOldParams() {
            String oldSplitVMParams = MavenExecuteUtils.splitJVMParams(this.oldAllParams, true);
            if (!oldSplitVMParams.isEmpty()) {
                oldSplitVMParams = this.eraseTokens(oldSplitVMParams, true, MavenExecuteUtils.EXEC_ARGS_CLASSPATH_TOKEN, MavenExecuteUtils.RUN_VM_PARAMS_TOKEN);
                this.oldVmParams = this.appendIfNotEmpty(this.oldVmParams, oldSplitVMParams);
            }
        }

        private void addAppParamsFromOldParams() {
            String p = MavenExecuteUtils.splitParams(this.oldAllParams);
            if (!p.isEmpty()) {
                p = this.eraseTokens(p, false, MavenExecuteUtils.RUN_APP_PARAMS_TOKEN);
                this.oldAppParams = this.appendIfNotEmpty(this.oldAppParams, p);
            }
        }

        private void loadMainClass() {
            if (this.oldMainClass.trim().isEmpty()) {
                this.oldMainClass = MavenExecuteUtils.splitMainClass(this.oldAllParams);
            }
            if (MavenExecuteUtils.PACKAGE_CLASS_NAME_TOKEN.equals(this.oldMainClass) || MavenExecuteUtils.RUN_MAIN_CLASS_TOKEN.equals(this.oldMainClass)) {
                this.oldMainClass = "";
            }
        }

        private boolean checkNewMapping(NetbeansActionMapping map) {
            if (map == null || map.getGoals() == null) {
                return false;
            }
            for (String goal : map.getGoals()) {
                String execArgs;
                if (!goal.matches("org\\.codehaus\\.mojo\\:exec-maven-plugin\\:(.)+\\:exec") && goal.indexOf("exec:exec") <= -1 || map.getProperties() == null) continue;
                if (map.getProperties().containsKey(MavenExecuteUtils.RUN_PARAMS) && (execArgs = map.getProperties().get(MavenExecuteUtils.RUN_PARAMS)).contains("-classpath")) {
                    return true;
                }
                if (!map.getProperties().containsKey(MavenExecuteUtils.RUN_VM_PARAMS) || !(execArgs = map.getProperties().get(MavenExecuteUtils.RUN_VM_PARAMS)).contains("-classpath")) continue;
                return true;
            }
            return false;
        }

        public void applyToMappings() {
            if (!(this.currentRun || this.currentDebug || this.currentProfile)) {
                return;
            }
            if (this.currentRun) {
                this.updateAction(this.run, "");
            }
            if (this.currentDebug) {
                this.updateAction(this.debug, MavenExecuteUtils.DEFAULT_DEBUG_PARAMS);
            }
            if (this.currentProfile) {
                this.updateAction(this.profile, "");
            }
        }

        private void updateAction(NetbeansActionMapping mapping, String debuVMArgs) {
            String oneLineVMParams;
            String newVMParams;
            String newMainClass;
            boolean changed = false;
            if (!this.oldWorkDir.equals(this.workDir)) {
                mapping.addProperty(MavenExecuteUtils.RUN_WORKDIR, this.workDir);
                changed = true;
            }
            if (!this.oldAppParams.equals(this.appParams)) {
                mapping.addProperty(MavenExecuteUtils.RUN_APP_PARAMS, this.appParams);
                changed = true;
            }
            if ((newMainClass = this.mainClass).trim().length() == 0) {
                newMainClass = MavenExecuteUtils.PACKAGE_CLASS_NAME_TOKEN;
            }
            if (!this.oldMainClass.equals(newMainClass)) {
                mapping.addProperty(MavenExecuteUtils.RUN_MAIN_CLASS, newMainClass);
                changed = true;
            }
            if (!this.workDir.equals(this.oldWorkDir)) {
                mapping.addProperty(MavenExecuteUtils.RUN_WORKDIR, this.workDir);
                changed = true;
            }
            if (!this.oldVmParams.equals(newVMParams = this.appendIfNotEmpty(oneLineVMParams = this.vmParams.replace('\n', ' '), debuVMArgs))) {
                mapping.addProperty(MavenExecuteUtils.RUN_VM_PARAMS, newVMParams);
                changed = true;
            }
            if (changed) {
                Map<String, String> props = mapping.getProperties();
                if (mapping.getProperties().get(MavenExecuteUtils.RUN_VM_PARAMS) == null) {
                    mapping.addProperty(MavenExecuteUtils.RUN_VM_PARAMS, this.vmParams);
                }
                if (mapping.getProperties().get(MavenExecuteUtils.RUN_APP_PARAMS) == null) {
                    mapping.addProperty(MavenExecuteUtils.RUN_APP_PARAMS, this.appParams);
                }
                if (mapping.getProperties().get(MavenExecuteUtils.RUN_MAIN_CLASS) == null) {
                    mapping.addProperty(MavenExecuteUtils.RUN_MAIN_CLASS, newMainClass);
                }
                mapping.addProperty(MavenExecuteUtils.RUN_PARAMS, MavenExecuteUtils.DEFAULT_EXEC_ARGS_CLASSPATH2);
            }
            if (changed) {
                ModelHandle2.setUserActionMapping(mapping, this.goalMappings);
                this.modified = true;
            }
        }
    }
}

