/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.ui.ConsoleDataDisplayer;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.openide.util.RequestProcessor;

public class HudsonConsoleDataProvider
extends BuilderConnector.ConsoleDataProvider {
    private static final Logger LOG = Logger.getLogger(HudsonConsoleDataProvider.class.getName());
    private boolean stopped = false;

    @Override
    public void showConsole(final HudsonJobBuild build, final ConsoleDataDisplayer displayer) {
        new RequestProcessor(build.getUrl() + "console").post(new Runnable(){

            @Override
            public void run() {
                HudsonConsoleDataProvider.this.showBuildConsole(build.getJob(), build.getUrl(), build.getDisplayName(), displayer);
            }
        });
    }

    @Override
    public void showConsole(final HudsonMavenModuleBuild moduleBuild, final ConsoleDataDisplayer displayer) {
        new RequestProcessor(moduleBuild.getUrl() + "console").post(new Runnable(){

            @Override
            public void run() {
                HudsonConsoleDataProvider.this.showBuildConsole(moduleBuild.getBuild().getJob(), moduleBuild.getUrl(), moduleBuild.getDisplayName(), displayer);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"OS_OPEN_STREAM"})
    public void showBuildConsole(HudsonJob job, String url, String displayName, ConsoleDataDisplayer displayer) {
        LOG.log(Level.FINE, "{0} started", url);
        displayer.open();
        int start = 0;
        String urlPrefix = url + "progressiveLog?start=";
        boolean running = job.getLastBuild() > job.getLastCompletedBuild();
        try {
            while (!this.stopped) {
                LOG.log(Level.FINE, "{0} polling", url);
                URLConnection conn = new ConnectionBuilder().job(job).url(urlPrefix + start).header("Accept-Encoding", "gzip").connection();
                boolean moreData = Boolean.parseBoolean(conn.getHeaderField("X-More-Data"));
                LOG.log(Level.FINE, "{0} retrieving text from {1}", new Object[]{url, start});
                start = conn.getHeaderFieldInt("X-Text-Size", start);
                try (InputStream is = conn.getInputStream();){
                    String line;
                    InputStream isToUse = is;
                    if ("gzip".equals(conn.getContentEncoding())) {
                        LOG.log(Level.FINE, "{0} using GZIP", url);
                        isToUse = new GZIPInputStream(is);
                    }
                    BufferedReader r = new BufferedReader(new InputStreamReader(isToUse, "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        boolean success = displayer.writeLine(line);
                        if (success) continue;
                        LOG.log(Level.FINE, "{0} stopped", url);
                        this.stopped = true;
                        break;
                    }
                }
                if (!moreData) {
                    LOG.log(Level.FINE, "{0} EOF", url);
                    if (running) {
                        LOG.fine("was running, will resynchronize");
                        HudsonInstance instance = job.getInstance();
                        if (instance instanceof HudsonInstanceImpl) {
                            ((HudsonInstanceImpl)instance).synchronize(false);
                        }
                    }
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException x) {
                    LOG.log(Level.FINE, "{0} interrupted", url);
                    break;
                }
            }
        }
        catch (IOException x) {
            LOG.log(Level.INFO, null, x);
        }
        displayer.close();
    }
}

