/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui.actions;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.testng.api.TestNGSupport;
import org.netbeans.modules.testng.api.TestNGUtils;
import org.netbeans.modules.testng.spi.TestConfig;
import org.netbeans.modules.testng.spi.TestNGSupportImplementation;
import org.netbeans.modules.testng.ui.actions.Bundle;
import org.netbeans.modules.testng.ui.actions.TestClassInfoTask;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public class DebugTestClassAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(DebugTestClassAction.class.getName());

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Lookup l = activatedNodes[0].getLookup();
        FileObject fo = (FileObject)l.lookup(FileObject.class);
        if (fo != null) {
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            return TestNGSupport.isActionSupported((TestNGSupport.Action)TestNGSupport.Action.DEBUG_TEST, (Project)p);
        }
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        Lookup l = activatedNodes[0].getLookup();
        FileObject fo = (FileObject)l.lookup(FileObject.class);
        EditorCookie ec = (EditorCookie)l.lookup(EditorCookie.class);
        if (fo == null && ec == null) {
            throw new UnsupportedOperationException();
        }
        TestClassInfoTask task = null;
        if (ec != null) {
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes.length > 0) {
                int cursor = panes[0].getCaret().getDot();
                JavaSource js = JavaSource.forDocument((Document)panes[0].getDocument());
                if (js == null) {
                    return;
                }
                task = new TestClassInfoTask(cursor);
                try {
                    js.runUserActionTask((Task)task, true);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
                fo = (FileObject)js.getFileObjects().iterator().next();
            }
        } else {
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js == null) {
                return;
            }
            task = new TestClassInfoTask(0);
            try {
                js.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fo);
        TestNGSupportImplementation.TestExecutor exec = TestNGSupport.findTestNGSupport((Project)p).createExecutor(p);
        TestConfig conf = TestNGUtils.getTestConfig((FileObject)fo, (boolean)false, (String)task.getPackageName(), (String)task.getClassName(), null);
        try {
            exec.execute(TestNGSupport.Action.DEBUG_TEST, conf);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    public String getName() {
        return Bundle.CTL_DebugTestClassAction();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.testng.ui.actions.DebugTestClassAction");
    }

    protected boolean asynchronous() {
        return false;
    }
}

