/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.HolderTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.ListTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.swing.outline.RowModel;
import org.openide.util.NbBundle;

public class TypeRowModel
implements RowModel {
    private ClassLoader classLoader;

    public TypeRowModel(ClassLoader loader) {
        this.classLoader = loader;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Object.class;
            }
        }
        return String.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return NbBundle.getMessage(this.getClass(), (String)"PARAM_NAME");
            }
            case 1: {
                return NbBundle.getMessage(this.getClass(), (String)"PARAM_VALUE");
            }
        }
        return "";
    }

    public Object getValueFor(Object inNode, int column) {
        if (null == inNode) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return null;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        switch (column) {
            case 0: {
                return data.getTypeName();
            }
            case 1: {
                return data.getTypeValue();
            }
        }
        return "";
    }

    public boolean isCellEditable(Object inNode, int column) {
        if (null == inNode) {
            return false;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return false;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                if (!data.isAssignable()) {
                    return false;
                }
                String typeClass = data.getTypeClass();
                if (ReflectionHelper.isSimpleType(typeClass, this.classLoader)) {
                    return !typeClass.equalsIgnoreCase("java.util.Calendar");
                }
                return ReflectionHelper.isEnumeration(typeClass, this.classLoader);
            }
        }
        return false;
    }

    public void setValueFor(Object inNode, int column, Object value) {
        if (null == inNode) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)inNode;
        if (null == node.getUserObject()) {
            return;
        }
        TypeNodeData data = (TypeNodeData)node.getUserObject();
        if (column != 1) {
            return;
        }
        data.setTypeValue(value);
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (null != parentNode && parentNode instanceof ListTypeTreeNode) {
            ((ListTypeTreeNode)parentNode).updateValueFromChildren(data);
        } else if (null != parentNode && parentNode instanceof StructureTypeTreeNode) {
            ((StructureTypeTreeNode)parentNode).updateValueFromChildren(data);
        } else if (null != parentNode && parentNode instanceof HolderTypeTreeNode) {
            ((HolderTypeTreeNode)parentNode).updateValueFromChildren(data);
        }
    }
}

