/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf;

import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.spi.CommentHandler;

public class JspCommentHandler
extends CommentHandler.DefaultCommentHandler {
    public int[] getAdjustedBlocks(final Document doc, int from, int to) {
        final int[] bounds = new int[]{from, to};
        final boolean[] inScriptlet = new boolean[]{false, false};
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Token t;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                TokenSequence ts = th.tokenSequence(JspTokenId.language());
                assert (ts != null) : "Not called on a JSP file!";
                ts.move(bounds[0]);
                if (ts.moveNext() && JspCommentHandler.this.isScriptletOrDelimiter(t = ts.token())) {
                    inScriptlet[0] = true;
                    while (ts.moveNext() && ts.offset() <= bounds[1]) {
                        t = ts.token();
                        if (JspCommentHandler.this.isScriptletOrDelimiter(t)) continue;
                        bounds[0] = ts.offset();
                        inScriptlet[0] = false;
                        break;
                    }
                }
                ts.move(bounds[1]);
                if (ts.moveNext()) {
                    t = ts.token();
                    if (t.id() == JspTokenId.COMMENT) {
                        do {
                            bounds[1] = bounds[1] + ts.token().length();
                        } while (ts.moveNext() && ts.token().id() == JspTokenId.COMMENT);
                    }
                    if (JspCommentHandler.this.isScriptletOrDelimiter(t)) {
                        inScriptlet[1] = true;
                        while (ts.movePrevious() && ts.offset() + ts.token().length() > bounds[0]) {
                            t = ts.token();
                            if (JspCommentHandler.this.isScriptletOrDelimiter(t)) continue;
                            bounds[1] = ts.offset() + t.length();
                            inScriptlet[1] = false;
                            break;
                        }
                    }
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(task);
        } else {
            task.run();
        }
        if (inScriptlet[0] && inScriptlet[1]) {
            return new int[0];
        }
        return new int[]{bounds[0], bounds[1]};
    }

    private boolean isScriptletOrDelimiter(Token t) {
        if (t.id() == JspTokenId.SCRIPTLET) {
            return true;
        }
        return t.id() == JspTokenId.SYMBOL2 && (CharSequenceUtilities.equals((CharSequence)"<%", (Object)t.text()) || CharSequenceUtilities.equals((CharSequence)"%>", (Object)t.text()));
    }

    public String getCommentStartDelimiter() {
        return "<%--";
    }

    public String getCommentEndDelimiter() {
        return "--%>";
    }
}

