/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui.browser;

import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.ClientProjectEnhancedBrowserImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BrowserConfigurationPanel
extends JPanel {
    private JCheckBox jAutoRefreshCheckBox;
    private JCheckBox jHighlightSelectionCheckBox;

    public BrowserConfigurationPanel(ClientSideProject project, ClientProjectEnhancedBrowserImpl cfg, WebBrowser browser) {
        this.initComponents();
        if (!browser.hasNetBeansIntegration()) {
            if (browser.getBrowserFamily() == BrowserFamilyId.CHROME) {
                this.jAutoRefreshCheckBox.setText(NbBundle.getMessage(BrowserConfigurationPanel.class, (String)"BrowserConfigurationPanel.jAutoRefreshCheckBox.chrome.text"));
            } else {
                this.jAutoRefreshCheckBox.setVisible(false);
            }
            this.jHighlightSelectionCheckBox.setVisible(false);
        }
        this.jAutoRefreshCheckBox.setSelected(cfg.isAutoRefresh());
        this.jHighlightSelectionCheckBox.setSelected(cfg.isHighlightSelectionEnabled());
    }

    public boolean isAutoRefresh() {
        return this.jAutoRefreshCheckBox.isSelected();
    }

    public boolean isHighlightSelection() {
        return this.jHighlightSelectionCheckBox.isSelected();
    }

    private void initComponents() {
        this.jAutoRefreshCheckBox = new JCheckBox();
        this.jHighlightSelectionCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.jAutoRefreshCheckBox, (String)NbBundle.getMessage(BrowserConfigurationPanel.class, (String)"BrowserConfigurationPanel.jAutoRefreshCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jHighlightSelectionCheckBox, (String)NbBundle.getMessage(BrowserConfigurationPanel.class, (String)"BrowserConfigurationPanel.jHighlightSelectionCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jAutoRefreshCheckBox).addComponent(this.jHighlightSelectionCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jAutoRefreshCheckBox).addGap(0, 0, 0).addComponent(this.jHighlightSelectionCheckBox)));
    }
}

