/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.source.ui.JavaSymbolProvider;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class WorkspaceServiceImpl
implements WorkspaceService,
LanguageClientAware {
    private static final RequestProcessor WORKER = new RequestProcessor(WorkspaceServiceImpl.class.getName(), 1, false, false);
    private NbCodeLanguageClient client;
    private static final String INIT = "<init>";

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        String command;
        switch (command = params.getCommand()) {
            case "graalvm.pause.script": {
                ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
                am.doAction((Object)"pauseInGraalScript");
                return CompletableFuture.completedFuture(true);
            }
            case "java.build.workspace": {
                CommandProgress progressOfCompilation = new CommandProgress();
                Lookup ctx = Lookups.singleton((Object)((Object)progressOfCompilation));
                for (Project prj : OpenProjects.getDefault().getOpenProjects()) {
                    ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                    if (ap == null || !ap.isActionEnabled("build", Lookup.EMPTY)) continue;
                    ap.invokeAction("rebuild", ctx);
                }
                progressOfCompilation.checkStatus();
                return progressOfCompilation.getFinishFuture();
            }
        }
        for (CodeGenerator codeGenerator : Lookup.getDefault().lookupAll(CodeGenerator.class)) {
            if (!codeGenerator.getCommands().contains(command)) continue;
            return codeGenerator.processCommand(this.client, command, params.getArguments());
        }
        throw new UnsupportedOperationException("Command not supported: " + params.getCommand());
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        String query = params.getQuery();
        if (query.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        System.err.println("query=" + query);
        boolean exact = false;
        if (query.endsWith(" ")) {
            query = query.substring(0, query.length() - 1);
            exact = true;
        }
        String queryFin = query;
        boolean exactFin = exact;
        final AtomicBoolean cancel = new AtomicBoolean();
        CompletableFuture<List<? extends SymbolInformation>> result = new CompletableFuture<List<? extends SymbolInformation>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            try {
                final ArrayList symbols = new ArrayList();
                JavaSymbolProvider.ResultHandler handler = new JavaSymbolProvider.ResultHandler(){
                    private Map type2Idents;

                    public void setHighlightText(String text) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runRoot(FileObject root, ClassIndexImpl ci, JavaSymbolProvider.ResultHandler.Exec exec) throws IOException, InterruptedException {
                        ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
                        try {
                            this.type2Idents = new HashMap();
                            exec.run();
                            HashMap<FileObject, Map> sources = new HashMap<FileObject, Map>();
                            for (Map.Entry e : this.type2Idents.entrySet()) {
                                FileObject sourceFile = SourceUtils.getFile((ElementHandle)((ElementHandle)e.getKey()), (ClasspathInfo)cpInfo);
                                sources.computeIfAbsent(sourceFile, s -> new HashMap()).put(e.getKey(), e.getValue());
                            }
                            if (!sources.isEmpty()) {
                                JavaSource.create((ClasspathInfo)cpInfo, sources.keySet()).runUserActionTask(cc -> {
                                    if (JavaSource.Phase.ELEMENTS_RESOLVED.compareTo((Enum)cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED)) > 0) {
                                        return;
                                    }
                                    for (Map.Entry e : ((Map)sources.get(cc.getFileObject())).entrySet()) {
                                        TypeElement te = (TypeElement)((ElementHandle)e.getKey()).resolve((CompilationInfo)cc);
                                        if (te == null) continue;
                                        for (String ident : (List)e.getValue()) {
                                            TreePath path;
                                            if (ident.equals(WorkspaceServiceImpl.getSimpleName(te, null, false)) && (path = cc.getTrees().getPath(te)) != null) {
                                                String string = te.getSimpleName().toString();
                                                ElementKind kind = te.getKind();
                                                SymbolInformation symbol = new SymbolInformation(string, Utils.elementKind2SymbolKind(kind), WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path), te.getQualifiedName().toString());
                                                symbol.setDeprecated(Boolean.valueOf(false));
                                                symbols.add(symbol);
                                            }
                                            for (Element element : te.getEnclosedElements()) {
                                                TreePath path2;
                                                if (!ident.equals(WorkspaceServiceImpl.getSimpleName(element, te, false)) || (path2 = cc.getTrees().getPath(element)) == null) continue;
                                                Pair name = JavaSymbolProvider.getDisplayName((Element)element, (Element)te);
                                                String symbolName = (String)name.first() + (name.second() != null ? (String)name.second() : "");
                                                ElementKind kind = element.getKind();
                                                SymbolInformation symbol = new SymbolInformation(symbolName, Utils.elementKind2SymbolKind(kind), WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path2), te.getQualifiedName().toString());
                                                symbol.setDeprecated(Boolean.valueOf(false));
                                                symbols.add(symbol);
                                            }
                                        }
                                    }
                                }, true);
                            }
                        }
                        finally {
                            this.type2Idents = null;
                        }
                    }

                    public void handleResult(ElementHandle<TypeElement> owner, String ident, boolean caseSensitive) {
                        this.type2Idents.computeIfAbsent(owner, s -> new ArrayList()).add(ident);
                    }
                };
                JavaSymbolProvider.doComputeSymbols((SearchType)WorkspaceServiceImpl.getSearchType(queryFin, exactFin, false, null, null), (String)queryFin, (JavaSymbolProvider.ResultHandler)handler, (boolean)true, (AtomicBoolean)cancel);
                Collections.sort(symbols, (i1, i2) -> i1.getName().compareToIgnoreCase(i2.getName()));
                result.complete(symbols);
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
        return result;
    }

    private Location tree2Location(CompilationInfo info, TreePath path) {
        return new Location(Utils.toUri(info.getFileObject()), Utils.treeRange(info, path.getLeaf()));
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static SearchType getSearchType(@NonNull String text, boolean exact, boolean isCaseSensitive, @NullAllowed String camelCaseSeparator, @NullAllowed String camelCasePart) {
        int wildcard = WorkspaceServiceImpl.containsWildCard(text);
        if (exact) {
            return SearchType.EXACT_NAME;
        }
        if (wildcard != -1) {
            return isCaseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP;
        }
        if (WorkspaceServiceImpl.isAllUpper(text) && text.length() > 1 || Queries.isCamelCase((String)text, (String)camelCaseSeparator, (String)camelCasePart)) {
            return isCaseSensitive ? SearchType.CAMEL_CASE : SearchType.CASE_INSENSITIVE_CAMEL_CASE;
        }
        return isCaseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX;
    }

    @NonNull
    private static String getSimpleName(@NonNull Element element, @NullAllowed Element enclosingElement, boolean caseSensitive) {
        String result = element.getSimpleName().toString();
        if (enclosingElement != null && INIT.equals(result)) {
            result = enclosingElement.getSimpleName().toString();
        }
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        return result;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams arg0) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams arg0) {
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    private static final class CommandProgress
    extends ActionProgress {
        private final CompletableFuture<Object> commandFinished = new CompletableFuture();
        private int running;
        private int success;
        private int failure;

        private CommandProgress() {
        }

        protected synchronized void started() {
            ++this.running;
        }

        public synchronized void finished(boolean ok) {
            if (ok) {
                ++this.success;
            } else {
                ++this.failure;
            }
            this.checkStatus();
        }

        final synchronized void checkStatus() {
            if (this.running <= this.success + this.failure) {
                this.commandFinished.complete(this.failure == 0);
            }
        }

        CompletableFuture<Object> getFinishFuture() {
            return this.commandFinished;
        }
    }
}

