/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.run.TargetExecutor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AntActionInstance
extends AbstractAction
implements InstanceCookie,
Presenter.Menu,
Presenter.Toolbar,
ChangeListener,
PropertyChangeListener {
    private boolean inited;
    private final AntProjectCookie proj;

    public AntActionInstance(AntProjectCookie proj) {
        this.proj = proj;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public Class instanceClass() {
        return AntActionInstance.class;
    }

    public String instanceName() {
        FileObject fo = this.proj.getFileObject();
        if (fo != null) {
            return fo.getName();
        }
        return "";
    }

    public Object instanceCreate() {
        this.init();
        return this;
    }

    private void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.proj.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.proj));
        OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjects.getDefault()));
    }

    @Override
    public void actionPerformed(ActionEvent ignore) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                TargetExecutor exec = new TargetExecutor(AntActionInstance.this.proj, null);
                try {
                    exec.execute();
                }
                catch (IOException ioe) {
                    AntModule.err.notify((Throwable)ioe);
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        if (this.proj.getFile() == null) {
            return false;
        }
        Element root = this.proj.getProjectElement();
        if (root == null) {
            return false;
        }
        NodeList nl = root.getElementsByTagName("ant");
        if (nl.getLength() == 1) {
            Project owner;
            FileObject fo;
            String dir;
            Element ant = (Element)nl.item(0);
            String antfile = ant.getAttribute("antfile");
            if (antfile.length() == 0 && (dir = ant.getAttribute("dir")).length() > 0) {
                antfile = dir + File.separatorChar + "build.xml";
            }
            if (antfile.length() > 0 && (fo = FileUtil.toFileObject((File)new File(antfile))) != null && (owner = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                return Arrays.asList(OpenProjects.getDefault().getOpenProjects()).contains(owner);
            }
        }
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
        assert (false);
    }

    @Override
    public Object getValue(String key) {
        if ("Name".equals(key)) {
            Element el = this.proj.getProjectElement();
            if (el != null) {
                String pname = el.getAttribute("name");
                return Actions.cutAmpersand((String)pname);
            }
        } else {
            if ("SmallIcon".equals(key)) {
                try {
                    return new ImageIcon(new URL("nbresloc:/org/apache/tools/ant/module/resources/AntIcon.gif"));
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if ("MnemonicKey".equals(key)) {
                String pname;
                int idx;
                Element el = this.proj.getProjectElement();
                if (el != null && (idx = Mnemonics.findMnemonicAmpersand((String)(pname = el.getAttribute("name")))) != -1) {
                    return (int)pname.charAt(idx + 1);
                }
                return 0;
            }
        }
        return super.getValue(key);
    }

    public JMenuItem getMenuPresenter() {
        class AntMenuItem
        extends JMenuItem
        implements DynamicMenuContent {
            public AntMenuItem() {
                super(AntActionInstance.this);
            }

            public JComponent[] getMenuPresenters() {
                JComponent[] jComponentArray;
                if (this.isEnabled()) {
                    JComponent[] jComponentArray2 = new JComponent[1];
                    jComponentArray = jComponentArray2;
                    jComponentArray2[0] = this;
                } else {
                    jComponentArray = new JComponent[]{};
                }
                return jComponentArray;
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                return this.getMenuPresenters();
            }
        }
        return new AntMenuItem();
    }

    public Component getToolbarPresenter() {
        class AntButton
        extends JButton
        implements PropertyChangeListener {
            public AntButton() {
                super(AntActionInstance.this);
                this.setVisible(this.isEnabled());
                AntActionInstance.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)AntActionInstance.this));
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    this.setVisible(this.isEnabled());
                }
            }
        }
        return new AntButton();
    }

    @Override
    public void stateChanged(ChangeEvent ignore) {
        this.firePropertyChange("Name", null, this.getValue("Name"));
        this.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        this.firePropertyChange("MnemonicKey", null, this.getValue("MnemonicKey"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange("enabled", null, this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
    }
}

