/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.io.IOException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.editors.EnumEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JTableSelectionModelEditor
extends EnumEditor
implements FormCodeAwareEditor,
XMLPropertyEditor {
    private FormProperty property;
    private static final String XML_TABLE_SELECTION_MODEL = "JTableSelectionModel";
    private static final String ATTR_SELECTION_MODE = "selectionMode";

    public JTableSelectionModelEditor() {
        super(new Object[]{NbBundle.getMessage(JTableSelectionModelEditor.class, (String)"JTableSelectionModelEditor_DEFAULT"), new Object(), "", NbBundle.getMessage(JTableSelectionModelEditor.class, (String)"JTableSelectionModelEditor_SINGLE_SELECTION"), JTableSelectionModelEditor.createListSelectionModel(0), "ListSelectionModel.SINGLE_SELECTION", NbBundle.getMessage(JTableSelectionModelEditor.class, (String)"JTableSelectionModelEditor_SINGLE_INTERVAL_SELECTION"), JTableSelectionModelEditor.createListSelectionModel(1), "ListSelectionModel.SINGLE_INTERVAL_SELECTION", NbBundle.getMessage(JTableSelectionModelEditor.class, (String)"JTableSelectionModelEditor_MULTIPLE_INTERVAL_SELECTION"), JTableSelectionModelEditor.createListSelectionModel(2), "ListSelectionModel.MULTIPLE_INTERVAL_SELECTION"}, false);
    }

    private static ListSelectionModel createListSelectionModel(int selectionMode) {
        DefaultListSelectionModel model = new DefaultListSelectionModel();
        model.setSelectionMode(selectionMode);
        return model;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof ListSelectionModel)) {
            value = this.property.getDefaultValue();
        }
        super.setValue(value);
    }

    @Override
    public String getSourceCode() {
        String code = super.getJavaInitializationString();
        if (code != null) {
            RADProperty prop = (RADProperty)this.property;
            RADComponent comp = prop.getRADComponent();
            CodeVariable var = comp.getCodeExpression().getVariable();
            String varName = var == null ? null : var.getName();
            varName = varName == null ? "" : varName + ".";
            code = varName + "setSelectionMode(" + code + ");\n";
        }
        return code;
    }

    @Override
    public void setContext(FormModel formModel, FormProperty property) {
        this.property = property;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB61, FormModel.FormVersion.NB61);
    }

    @Override
    public void readFromXML(Node element) throws IOException {
        Object value;
        NamedNodeMap attributes = element.getAttributes();
        Object[] values = this.getEnumerationValues();
        Node node = attributes.getNamedItem(ATTR_SELECTION_MODE);
        int selectionMode = Integer.valueOf(node.getNodeValue());
        switch (selectionMode) {
            case 0: {
                value = values[4];
                break;
            }
            case 1: {
                value = values[7];
                break;
            }
            case 2: {
                value = values[10];
                break;
            }
            default: {
                value = values[1];
            }
        }
        this.setValue(value);
    }

    @Override
    public Node storeToXML(Document doc) {
        Object value = this.getValue();
        int selectionMode = -1;
        Object[] values = this.getEnumerationValues();
        if (values[4].equals(value)) {
            selectionMode = 0;
        } else if (values[7].equals(value)) {
            selectionMode = 1;
        } else if (values[10].equals(value)) {
            selectionMode = 2;
        }
        Element el = null;
        el = doc.createElement(XML_TABLE_SELECTION_MODEL);
        el.setAttribute(ATTR_SELECTION_MODE, Integer.toString(selectionMode));
        return el;
    }
}

