/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import org.netbeans.modules.docker.api.DockerContainer;
import org.netbeans.modules.docker.api.DockerEntity;
import org.netbeans.modules.docker.api.DockerTag;

public final class DockerUtils {
    public static final String DOCKER_FILE = "Dockerfile";

    private DockerUtils() {
    }

    public static String getShortId(DockerEntity identifiable) {
        String id = identifiable.getId();
        int index = id.indexOf(58);
        if (index >= 0) {
            id = id.substring(index + 1);
        }
        if (id.length() > 12) {
            return id.substring(0, 12);
        }
        return id;
    }

    public static String getImage(DockerTag tag) {
        String id = tag.getTag();
        if (id.equals("<none>:<none>")) {
            id = tag.getImage().getId();
        }
        return id;
    }

    public static String getTag(String repository, String tag) {
        if (repository == null) {
            return "<none>:<none>";
        }
        if (tag == null) {
            return repository + ":latest";
        }
        return repository + ":" + tag;
    }

    public static DockerContainer.Status getContainerStatus(String status) {
        if (status == null) {
            return DockerContainer.Status.STOPPED;
        }
        if (!status.startsWith("Up")) {
            return DockerContainer.Status.STOPPED;
        }
        if (!status.contains("Paused")) {
            return DockerContainer.Status.RUNNING;
        }
        return DockerContainer.Status.PAUSED;
    }
}

