/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.PipelineStatistic;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.WorkerThreadImpl;
import java.nio.channels.SelectionKey;
import java.util.LinkedList;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedListPipeline
extends LinkedList<Task>
implements Pipeline {
    protected int waitingThreads = 0;
    protected int maxThreads = 20;
    protected int minThreads = 5;
    protected int minSpareThreads = 2;
    protected int port = 8080;
    protected int threadCount = 0;
    protected String name;
    protected int priority = 5;
    protected boolean isStarted = false;
    protected transient WorkerThreadImpl[] workerThreads;
    protected int maxQueueSizeInBytes = -1;
    protected int threadsIncrement = 1;
    protected int threadsTimeout = 30;
    protected transient PipelineStatistic pipelineStat;

    public LinkedListPipeline() {
    }

    public LinkedListPipeline(int maxThreads, int minThreads, String name, int port, int priority) {
        this.maxThreads = maxThreads;
        this.port = port;
        this.name = name;
        this.minThreads = minThreads;
        this.priority = priority;
        if (minThreads < this.minSpareThreads) {
            this.minSpareThreads = minThreads;
        }
    }

    public LinkedListPipeline(int maxThreads, int minThreads, String name, int port) {
        this(maxThreads, minThreads, name, port, 5);
    }

    @Override
    public synchronized void initPipeline() {
        if (this.minThreads > this.maxThreads) {
            this.minThreads = this.maxThreads;
        }
        this.workerThreads = new WorkerThreadImpl[this.maxThreads];
        this.increaseWorkerThread(this.minThreads, false);
    }

    @Override
    public synchronized void startPipeline() {
        if (!this.isStarted) {
            for (int i = 0; i < this.minThreads; ++i) {
                this.workerThreads[i].start();
            }
            this.isStarted = true;
        }
    }

    @Override
    public synchronized void stopPipeline() {
        if (this.isStarted) {
            for (int i = 0; i < this.threadCount; ++i) {
                this.workerThreads[i].terminate();
            }
            this.isStarted = false;
        }
        this.notifyAll();
    }

    protected void increaseWorkerThread(int increment, boolean startThread) {
        int currentCount = this.threadCount;
        int increaseCount = this.threadCount + increment;
        for (int i = currentCount; i < increaseCount; ++i) {
            WorkerThreadImpl workerThread = new WorkerThreadImpl(this, this.name + "WorkerThread-" + (this.port > 0 ? new String(this.port + "-") : "") + i);
            workerThread.setPriority(this.priority);
            if (startThread) {
                workerThread.start();
            }
            this.workerThreads[i] = workerThread;
            ++this.threadCount;
        }
    }

    @Override
    public synchronized boolean interruptThread(long threadID) {
        ThreadGroup threadGroup = this.workerThreads[0].getThreadGroup();
        Thread[] threads = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threads);
        for (Thread thread : threads) {
            if (thread == null || thread.getId() != threadID || Thread.State.RUNNABLE == thread.getState()) continue;
            try {
                thread.interrupt();
                return true;
            }
            catch (Throwable t) {
                SelectorThread.logger().log(Level.FINEST, "", t);
            }
        }
        return false;
    }

    @Override
    public synchronized void addTask(Task task) {
        int queueSize = this.size();
        if (this.pipelineStat != null) {
            this.pipelineStat.gather(queueSize);
        }
        if (this.maxQueueSizeInBytes != -1 && this.maxQueueSizeInBytes <= queueSize) {
            SelectorThread st = task.getSelectorThread();
            st.cancelKey(task.getSelectionKey());
            SelectorThread.logger().log(Level.WARNING, "Maximum connections queued reached (max-pending-count) " + this.maxQueueSizeInBytes + ". Dropping requests until queued connections have been freed up.");
            st.returnTask(task);
            return;
        }
        this.addLast(task);
        this.notify();
        if (this.threadCount < this.maxThreads && this.waitingThreads < queueSize + 1) {
            int left = this.maxThreads - this.threadCount;
            if (this.threadsIncrement > left) {
                this.threadsIncrement = left;
            }
            this.increaseWorkerThread(this.threadsIncrement, true);
        }
    }

    @Override
    public synchronized Task getTask() {
        if (this.size() - this.waitingThreads <= 0) {
            try {
                ++this.waitingThreads;
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread();
                Thread.interrupted();
            }
            --this.waitingThreads;
        }
        return (Task)this.poll();
    }

    @Override
    public boolean expireKey(SelectionKey key) {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() - this.waitingThreads <= 0;
    }

    @Override
    public synchronized int getWaitingThread() {
        return this.waitingThreads;
    }

    @Override
    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @Override
    public synchronized int getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public synchronized int getCurrentThreadCount() {
        return this.threadCount;
    }

    @Override
    public synchronized int getCurrentThreadsBusy() {
        return this.threadCount - this.waitingThreads;
    }

    @Override
    public synchronized int getMaxSpareThreads() {
        return this.maxThreads;
    }

    @Override
    public synchronized int getMinSpareThreads() {
        return this.minSpareThreads;
    }

    @Override
    public synchronized void setMinSpareThreads(int minSpareThreads) {
        this.minSpareThreads = minSpareThreads;
    }

    @Override
    public synchronized void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized String getName() {
        return this.name + this.port;
    }

    @Override
    public synchronized void setPort(int port) {
        this.port = port;
    }

    @Override
    public synchronized void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @Override
    public String toString() {
        return "name: " + this.name + " maxThreads: " + this.maxThreads + " type: " + this.getClass().getName();
    }

    @Override
    public synchronized void setThreadsIncrement(int threadsIncrement) {
        this.threadsIncrement = threadsIncrement;
    }

    @Override
    public synchronized void setThreadsTimeout(int threadsTimeout) {
        this.threadsTimeout = threadsTimeout;
    }

    public synchronized int getTaskQueuedCount() {
        return this.size();
    }

    @Override
    public synchronized void setQueueSizeInBytes(int maxQueueSizeInBytesCount) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytesCount;
    }

    public synchronized int getQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    @Override
    public void setPipelineStatistic(PipelineStatistic pipelineStatistic) {
        this.pipelineStat = pipelineStatistic;
    }

    @Override
    public PipelineStatistic getPipelineStatistic() {
        return this.pipelineStat;
    }
}

