/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class JavadocQuery
implements JavadocForBinaryQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;

    public JavadocQuery(AntProjectHelper helper, PropertyEvaluator eval, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.eval = eval;
        this.aux = aux;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        Element data = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/4", true);
        if (data != null) {
            for (Element cu : XMLUtil.findSubElements((Element)data)) {
                assert (cu.getLocalName().equals("compilation-unit")) : cu;
                boolean rightCU = false;
                for (Element builtTo : XMLUtil.findSubElements((Element)cu)) {
                    URL url;
                    if (!builtTo.getLocalName().equals("built-to")) continue;
                    String rawtext = XMLUtil.findText((Node)builtTo);
                    assert (rawtext != null);
                    String evaltext = this.eval.evaluate(rawtext);
                    if (evaltext == null || (url = this.evalTextToURL(evaltext)) == null || !url.equals(binaryRoot)) continue;
                    rightCU = true;
                    break;
                }
                if (!rightCU) continue;
                ArrayList<URL> resultURLs = new ArrayList<URL>();
                for (Element javadocTo : XMLUtil.findSubElements((Element)cu)) {
                    if (!javadocTo.getLocalName().equals("javadoc-built-to")) continue;
                    String rawtext = XMLUtil.findText((Node)javadocTo);
                    assert (rawtext != null);
                    String evaltext = this.eval.evaluate(rawtext);
                    if (evaltext == null) continue;
                    resultURLs.add(this.evalTextToURL(evaltext));
                }
                if (resultURLs.size() == 0) {
                    return null;
                }
                return new FixedResult(resultURLs);
            }
        }
        return null;
    }

    private URL evalTextToURL(String evaltext) {
        File location = this.helper.resolveFile(evaltext);
        return FileUtil.urlForArchiveOrDir((File)location);
    }

    private static final class FixedResult
    implements JavadocForBinaryQuery.Result {
        private final List<URL> urls;

        public FixedResult(List<URL> urls) {
            this.urls = urls;
        }

        public URL[] getRoots() {
            return this.urls.toArray(new URL[this.urls.size()]);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

