/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class HudsonInstanceProperties
extends HashMap<String, String> {
    private static final RequestProcessor RP = new RequestProcessor(HudsonInstanceProperties.class);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public HudsonInstanceProperties(String name, String url, String sync) {
        this.put("name", name);
        this.put("url", url);
        this.put("sync_time", sync);
    }

    public HudsonInstanceProperties(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public final synchronized String put(String key, String value) {
        String o = super.put(key, value);
        this.pcs.firePropertyChange(key, o, value);
        if (key.equals("name")) {
            this.loadPreferences();
        }
        this.updatePreferences(key);
        return o;
    }

    @Override
    public synchronized String remove(Object key) {
        String o = (String)super.remove((String)key);
        this.pcs.firePropertyChange((String)key, o, null);
        this.updatePreferences((String)key);
        return o;
    }

    public final boolean isPersisted() {
        String pers = (String)this.get("persisted");
        return pers == null || "true".equals(pers);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public List<PropertyChangeListener> getCurrentListeners() {
        return Arrays.asList(this.pcs.getPropertyChangeListeners());
    }

    public static List<String> split(String prop) {
        if (prop != null && prop.trim().length() > 0) {
            String[] escaped = prop.split("(?<!/)/(?!/)");
            ArrayList<String> list = new ArrayList<String>(escaped.length);
            for (String e : escaped) {
                list.add(e.replace("//", "/"));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static String join(List<String> pieces) {
        StringBuilder b = new StringBuilder();
        for (String piece : pieces) {
            assert (!piece.startsWith("/") && !piece.endsWith("/")) : piece;
            String escaped = piece.replace("/", "//");
            if (b.length() > 0) {
                b.append('/');
            }
            b.append(escaped);
        }
        return b.toString();
    }

    public Preferences getPreferences() {
        String nodeName = this.getNodeName();
        if (nodeName != null) {
            return HudsonManagerImpl.instancePrefs().node(nodeName);
        }
        return null;
    }

    private boolean hasPreferences() {
        String nodeName = this.getNodeName();
        if (nodeName != null) {
            try {
                return HudsonManagerImpl.instancePrefs().nodeExists(nodeName);
            }
            catch (BackingStoreException ex) {
                return false;
            }
        }
        return false;
    }

    private String getNodeName() {
        String name = (String)this.get("name");
        if (name != null && !name.isEmpty()) {
            return HudsonManagerImpl.simplifyServerLocation(name, true);
        }
        return null;
    }

    private void updatePreferences(final String ... keys) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Preferences prefs = HudsonInstanceProperties.this.getPreferences();
                if (prefs != null) {
                    for (String key : keys) {
                        String val = (String)HudsonInstanceProperties.this.get(key);
                        if (val == null) {
                            prefs.remove(key);
                            continue;
                        }
                        prefs.put(key, val);
                    }
                }
            }
        });
    }

    private void loadPreferences() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Preferences prefs;
                if (HudsonInstanceProperties.this.hasPreferences() && (prefs = HudsonInstanceProperties.this.getPreferences()) != null) {
                    try {
                        String[] keys;
                        for (String key : keys = prefs.keys()) {
                            String val;
                            if ("name".equals(key) || "url".equals(key) || (val = prefs.get(key, null)) == null) continue;
                            HudsonInstanceProperties.this.put(key, val);
                        }
                    }
                    catch (BackingStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }
}

