/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.payara.common.BasicTask;
import org.netbeans.modules.payara.common.CommonServerSupport;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.CommandStopCluster;
import org.netbeans.modules.payara.tooling.admin.CommandStopDAS;
import org.netbeans.modules.payara.tooling.admin.CommandStopInstance;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

public class StopTask
extends BasicTask<TaskState> {
    private final CommonServerSupport support;

    public StopTask(CommonServerSupport support, TaskStateListener ... stateListener) {
        super(support.getInstance(), stateListener);
        this.support = support;
    }

    @Override
    public TaskState call() {
        Logger.getLogger("payara").log(Level.FINEST, "StopTask.call() called on thread \"{0}\"", Thread.currentThread().getName());
        long start = System.currentTimeMillis();
        String host = this.instance.getProperty("host");
        if (host == null || host.length() == 0) {
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            int port = Integer.valueOf(this.instance.getProperty("adminPort"));
            if (port < 0 || port > 65535) {
                return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
        }
        catch (NumberFormatException ex) {
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        String target = Util.computeTarget(this.instance.getProperties());
        if (!Util.isDefaultOrServerTarget(this.instance.getProperties())) {
            return this.stopClusterOrInstance(target);
        }
        ResultString result = CommandStopDAS.stopDAS((PayaraServer)this.instance);
        if (TaskState.FAILED.equals((Object)result.getState())) {
            this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_STOP_SERVER_FAILED", this.instanceName);
        }
        this.fireOperationStateChanged(TaskState.RUNNING, TaskEvent.CMD_RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        BasicTask.StateChange stateChange = this.waitShutDown();
        if (stateChange != null) {
            return stateChange.fireOperationStateChanged();
        }
        return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
    }

    private TaskState stopClusterOrInstance(String target) {
        ResultString result = CommandStopCluster.stopCluster((PayaraServer)this.instance, (String)target);
        if (TaskState.FAILED.equals((Object)result.getState()) && TaskState.FAILED.equals((Object)(result = CommandStopInstance.stopInstance((PayaraServer)this.instance, (String)target)).getState())) {
            return this.fireOperationStateChanged(TaskState.FAILED, TaskEvent.CMD_FAILED, "MSG_STOP_TARGET_FAILED", this.instanceName, target);
        }
        return this.fireOperationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
    }
}

