/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

public class MetaCharset
extends AbstractDatatype {
    public static final MetaCharset THE_INSTANCE = new MetaCharset();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        char c;
        int i;
        String lower = MetaCharset.toAsciiLowerCase(literal);
        if (!lower.startsWith("text/html;")) {
            throw this.newDatatypeException("The legacy encoding declaration did not start with ", "text/html;", ".");
        }
        if (lower.length() == 10) {
            throw this.newDatatypeException("The legacy encoding declaration ended prematurely.");
        }
        int offset = 10;
        block4: for (i = 10; i < lower.length(); ++i) {
            c = lower.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    ++offset;
                    continue block4;
                }
                case 'c': {
                    break block4;
                }
                default: {
                    throw this.newDatatypeException("The legacy encoding declaration did not start with space characters or ", "charset=", " after the semicolon.  Found \u201c" + c + "\u201d instead.");
                }
            }
        }
        if (!lower.startsWith("charset=", offset)) {
            throw this.newDatatypeException("The legacy encoding declarationdid not contain ", "charset=", " after the semicolon.");
        }
        if (lower.length() == (offset += 8)) {
            throw this.newDatatypeException("The empty string is not a valid character encoding name.");
        }
        for (i = offset; i < lower.length(); ++i) {
            c = lower.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '-' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '+' || c == '_' || c == '`' || c == '{' || c == '}' || c == '~' || c == '^') continue;
            throw this.newDatatypeException("The legacy encoding contained ", c, ", which is not a valid character in an encoding name.");
        }
        String encodingName = lower.substring(offset);
        if (!"utf-8".equals(encodingName)) {
            throw this.newDatatypeException("\u201ccharset=\u201d must be followed by \u201cutf-8\u201d.");
        }
    }

    @Override
    public String getName() {
        return "legacy character encoding declaration";
    }
}

