/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InvalidObjectException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorExpression;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAWatchFactory;
import org.netbeans.modules.debugger.jpda.ui.models.Bundle;
import org.netbeans.modules.debugger.jpda.ui.models.JPDAWatchRefreshModel;
import org.netbeans.modules.debugger.jpda.ui.models.LocalsTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class WatchesModel
implements TreeModel,
JPDAWatchRefreshModel {
    private static final String PROP_SHOW_PINNED_WATCHES = "showPinnedWatches";
    private static final Properties PROPERTIES = Properties.getDefault().getProperties("debugger").getProperties("watchesProps");
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(119) >= 0;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private Vector<ModelListener> listeners = new Vector();
    private ContextProvider lookupProvider;
    private final Map<Watch, JPDAWatchEvaluating> watchToValue = new WeakHashMap<Watch, JPDAWatchEvaluating>();
    private final JPDAWatch EMPTY_WATCH;
    private LocalsTreeModel localsTreeModel;

    public WatchesModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.lookupProvider = lookupProvider;
        this.EMPTY_WATCH = new EmptyWatch();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Watch[] fws;
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            if (PROPERTIES.getBoolean(PROP_SHOW_PINNED_WATCHES, false)) {
                to = Math.min(ws.length, to);
                from = Math.min(ws.length, from);
                fws = new Watch[to - from];
                System.arraycopy(ws, from, fws, 0, to - from);
            } else {
                int numwatches = 0;
                for (Watch w : ws) {
                    if (w.getPin() != null) continue;
                    ++numwatches;
                }
                to = Math.min(numwatches, to);
                from = Math.min(numwatches, from);
                fws = new Watch[to - from];
                numwatches = 0;
                for (int i = 0; i < ws.length; ++i) {
                    Watch w = ws[i];
                    if (w.getPin() != null) continue;
                    if (numwatches >= from) {
                        fws[numwatches++] = w;
                    } else {
                        ++numwatches;
                    }
                    if (numwatches >= to) break;
                }
            }
            int k = fws.length;
            Object[] jws = new JPDAWatch[k + 1];
            for (int i = 0; i < k; ++i) {
                JPDAWatchEvaluating jw = this.watchToValue.get(fws[i]);
                if (jw == null) {
                    jw = new JPDAWatchEvaluating(this, fws[i], this.debugger);
                    this.watchToValue.put(fws[i], jw);
                }
                jws[i] = jw;
            }
            jws[k] = this.EMPTY_WATCH;
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return jws;
        }
        return this.getLocalsTreeModel().getChildren(parent, from, to);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return Integer.MAX_VALUE;
        }
        return this.getLocalsTreeModel().getChildrenCount(node);
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof JPDAWatchEvaluating) {
            JPDAWatchEvaluating jwe = (JPDAWatchEvaluating)node;
            if (!jwe.getWatch().isEnabled()) {
                return true;
            }
            if (!jwe.isCurrent()) {
                return false;
            }
            JPDAWatch jw = jwe.getEvaluatedWatch();
            if (jw instanceof AbstractVariable) {
                return !(((AbstractVariable)jw).getInnerValue() instanceof ObjectReference);
            }
        }
        if (node == this.EMPTY_WATCH) {
            return true;
        }
        return this.getLocalsTreeModel().isLeaf(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeChanged() {
        Map<Watch, JPDAWatchEvaluating> map = this.watchToValue;
        synchronized (map) {
            Iterator<JPDAWatchEvaluating> it = this.watchToValue.values().iterator();
            while (it.hasNext()) {
                it.next().setEvaluated(null);
            }
        }
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    private void fireWatchesChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    @Override
    public void fireTableValueChangedChanged(Object node, String propertyName) {
        ((JPDAWatchEvaluating)node).setEvaluated(null);
        this.fireTableValueChangedComputed(node, propertyName);
    }

    void fireTableValueChangedComputed(Object node, String propertyName) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, node, propertyName));
        }
    }

    @Override
    public void fireChildrenChanged(Object node) {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node, 8));
        }
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    LocalsTreeModel getLocalsTreeModel() {
        if (this.localsTreeModel == null) {
            this.localsTreeModel = (LocalsTreeModel)this.lookupProvider.lookupFirst("LocalsView", TreeModel.class);
        }
        return this.localsTreeModel;
    }

    private final class EmptyWatch
    implements JPDAWatch {
        private EmptyWatch() {
        }

        public String getExpression() {
            return "";
        }

        public void setExpression(String expr) {
            String infoStr = NbBundle.getBundle(WatchesModel.class).getString("CTL_WatchesModel_Empty_Watch_Hint");
            infoStr = "<" + infoStr + ">";
            if (expr == null || expr.trim().length() == 0 || infoStr.equals(expr)) {
                return;
            }
            DebuggerManager.getDebuggerManager().createWatch(expr);
            Vector v = (Vector)WatchesModel.this.listeners.clone();
            int k = v.size();
            for (int i = 0; i < k; ++i) {
                ((ModelListener)v.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)WatchesModel.this, (Object)this));
            }
        }

        public void remove() {
        }

        public String getType() {
            return "";
        }

        public String getValue() {
            return "";
        }

        public String getExceptionDescription() {
            return null;
        }

        public void setValue(String value) throws InvalidExpressionException {
        }

        public String getToStringValue() throws InvalidExpressionException {
            return "";
        }

        public void setFromMirrorObject(Object obj) throws InvalidObjectException {
            throw new InvalidObjectException("EmptyWatch");
        }

        public Object createMirrorObject() {
            return null;
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<WatchesModel> model;
        private WeakReference<JPDADebuggerImpl> debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesModel tm, JPDADebuggerImpl debugger) {
            this.model = new WeakReference<WatchesModel>(tm);
            this.debugger = new WeakReference<JPDADebuggerImpl>(debugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
            PROPERTIES.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private WatchesModel getModel() {
            WatchesModel m = (WatchesModel)this.model.get();
            if (m == null) {
                this.destroy();
            }
            return m;
        }

        public void watchAdded(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            m.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            WatchesModel m = this.getModel();
            if (m == null) {
                return;
            }
            if (evt.getSource() != PROPERTIES || !WatchesModel.PROP_SHOW_PINNED_WATCHES.equals(propName)) {
                if (!("state".equals(propName) || "expression".equals(propName) || "enabled".equals(propName) || "currentCallStackFrame".equals(propName))) {
                    return;
                }
                if ("state".equals(propName) && m.debugger.getState() == 4) {
                    this.destroy();
                    return;
                }
                if (m.debugger.getState() == 2 || "currentCallStackFrame".equals(propName) && m.debugger.getCurrentCallStackFrame() == null) {
                    return;
                }
                if (evt.getSource() instanceof Watch) {
                    Object node;
                    Map map = m.watchToValue;
                    synchronized (map) {
                        node = m.watchToValue.get(evt.getSource());
                    }
                    if (node != null) {
                        m.fireTableValueChangedChanged(node, null);
                        return;
                    }
                }
            }
            if (this.task == null) {
                this.task = m.debugger.getRequestProcessor().create(new Runnable(){

                    @Override
                    public void run() {
                        WatchesModel m;
                        if (verbose) {
                            System.out.println("WM do task " + Listener.this.task);
                        }
                        if ((m = Listener.this.getModel()) != null) {
                            m.fireTreeChanged();
                        }
                    }
                });
                if (verbose) {
                    System.out.println("WM  create task " + this.task);
                }
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            JPDADebugger d = (JPDADebugger)this.debugger.get();
            if (d != null) {
                d.removePropertyChangeListener((PropertyChangeListener)this);
            }
            Watch[] ws = DebuggerManager.getDebuggerManager().getWatches();
            int k = ws.length;
            for (int i = 0; i < k; ++i) {
                ws[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("WM cancel old task " + this.task);
                }
                this.task = null;
            }
        }
    }

    public static class JPDAWatchEvaluating
    extends AbstractObjectVariable
    implements JPDAWatch,
    Variable,
    Refreshable,
    PropertyChangeListener {
        private JPDAWatchRefreshModel model;
        private Watch w;
        private JPDADebuggerImpl debugger;
        private JPDAWatch evaluatedWatch;
        private EvaluatorExpression expression;
        private final boolean[] evaluating = new boolean[]{false};
        private int cloneNumber = 1;

        public JPDAWatchEvaluating(JPDAWatchRefreshModel model, Watch w, JPDADebuggerImpl debugger) {
            this(model, w, debugger, 0);
        }

        private JPDAWatchEvaluating(JPDAWatchRefreshModel model, Watch w, JPDADebuggerImpl debugger, int cloneNumber) {
            super(debugger, null, cloneNumber > 0 ? w + "_clone" + cloneNumber : "" + w);
            this.model = model;
            this.w = w;
            this.debugger = debugger;
            if (w.isEnabled()) {
                this.parseExpression(w.getExpression());
            }
            if (cloneNumber == 0) {
                debugger.varChangeSupport.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)debugger.varChangeSupport));
            }
        }

        public Watch getWatch() {
            return this.w;
        }

        private void parseExpression(String exprStr) {
            this.expression = new EvaluatorExpression(exprStr);
        }

        EvaluatorExpression getParsedExpression() {
            return this.expression;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEvaluated(JPDAWatch evaluatedWatch) {
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                this.evaluatedWatch = evaluatedWatch;
            }
            if (evaluatedWatch != null) {
                this.setInnerValue(((AbstractVariable)evaluatedWatch).getInnerValue());
            } else {
                this.setInnerValue(null);
            }
            try {
                if (this.model.isLeaf(this)) {
                    this.model.fireChildrenChanged(this);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }

        synchronized JPDAWatch getEvaluatedWatch() {
            return this.evaluatedWatch;
        }

        public void expressionChanged() {
            this.setEvaluated(null);
            if (this.w.isEnabled()) {
                this.parseExpression(this.w.getExpression());
            }
        }

        public synchronized String getExceptionDescription() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExceptionDescription();
            }
            return null;
        }

        public synchronized String getExpression() {
            if (this.evaluatedWatch != null) {
                return this.evaluatedWatch.getExpression();
            }
            return this.w.getExpression();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getToStringValue() throws InvalidExpressionException {
            String e;
            JPDAWatch evaluatedWatch;
            if (!this.w.isEnabled()) {
                return Bundle.CTL_WatchDisabled();
            }
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                evaluatedWatch = this.evaluatedWatch;
            }
            if (evaluatedWatch == null) {
                JPDAWatch[] watchRef = new JPDAWatch[]{null};
                this.getValue(watchRef);
                evaluatedWatch = watchRef[0];
            }
            if ((e = evaluatedWatch.getExceptionDescription()) != null) {
                throw new InvalidExpressionException(e);
            }
            return evaluatedWatch.getToStringValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getType() {
            JPDAWatch evaluatedWatch;
            JPDAWatchEvaluating jPDAWatchEvaluating = this;
            synchronized (jPDAWatchEvaluating) {
                evaluatedWatch = this.evaluatedWatch;
            }
            if (evaluatedWatch == null) {
                JPDAWatch[] watchRef = new JPDAWatch[]{null};
                this.getValue(watchRef);
                evaluatedWatch = watchRef[0];
            }
            if (evaluatedWatch == null) {
                return "";
            }
            return evaluatedWatch.getType();
        }

        public String getValue() {
            return this.getValue(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getValue(JPDAWatch[] watchRef) {
            if (!this.w.isEnabled()) {
                return Bundle.CTL_WatchDisabled();
            }
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                Value v;
                Object expr;
                JPDAWatch jw;
                block28: {
                    if (this.evaluating[0]) {
                        try {
                            this.evaluating.wait();
                        }
                        catch (InterruptedException iex) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return null;
                        }
                    }
                    JPDAWatchEvaluating iex = this;
                    synchronized (iex) {
                        if (this.evaluatedWatch != null) {
                            if (watchRef == null) return this.evaluatedWatch.getValue();
                            watchRef[0] = this.evaluatedWatch;
                            // MONITOREXIT @DISABLED, blocks:[9, 25, 10] lbl17 : MonitorExitStatement: MONITOREXIT : iex
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return this.evaluatedWatch.getValue();
                        }
                    }
                    this.evaluating[0] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    jw = null;
                    try {
                        expr = this.getParsedExpression();
                        if (expr != null) break block28;
                        this.parseExpression(this.w.getExpression());
                        expr = this.getParsedExpression();
                    }
                    catch (InvalidExpressionException e222222) {
                        jw = JPDAWatchFactory.createJPDAWatch((JPDADebuggerImpl)this.debugger, (Watch)this.w, (Throwable)e222222);
                        {
                            catch (Throwable throwable) {
                                if (jw instanceof AbstractVariable) {
                                    ((AbstractVariable)jw).addPropertyChangeListener((PropertyChangeListener)this);
                                }
                                this.setEvaluated(jw);
                                if (watchRef != null) {
                                    watchRef[0] = jw;
                                }
                                boolean[] blArray2 = this.evaluating;
                                synchronized (this.evaluating) {
                                    this.evaluating[0] = false;
                                    this.evaluating.notifyAll();
                                    // ** MonitorExit[var9_11] (shouldn't be in output)
                                    throw throwable;
                                }
                            }
                        }
                        if (jw instanceof AbstractVariable) {
                            ((AbstractVariable)jw).addPropertyChangeListener((PropertyChangeListener)this);
                        }
                        this.setEvaluated(jw);
                        if (watchRef != null) {
                            watchRef[0] = jw;
                        }
                        boolean[] e222222 = this.evaluating;
                        synchronized (this.evaluating) {
                            this.evaluating[0] = false;
                            this.evaluating.notifyAll();
                            // ** MonitorExit[e] (shouldn't be in output)
                            return jw.getValue();
                        }
                        catch (RuntimeException ex) {
                            jw = JPDAWatchFactory.createJPDAWatch((JPDADebuggerImpl)this.debugger, (Watch)this.w, (Throwable)ex);
                            throw ex;
                            catch (Error err) {
                                jw = JPDAWatchFactory.createJPDAWatch((JPDADebuggerImpl)this.debugger, (Watch)this.w, (Throwable)err);
                                throw err;
                            }
                        }
                    }
                }
                if ((jw = JPDAWatchFactory.createJPDAWatch((JPDADebuggerImpl)this.debugger, (Watch)this.w, (Value)(v = this.debugger.evaluateIn(expr)))) instanceof AbstractVariable) {
                    ((AbstractVariable)jw).addPropertyChangeListener((PropertyChangeListener)this);
                }
                this.setEvaluated(jw);
                if (watchRef != null) {
                    watchRef[0] = jw;
                }
                expr = this.evaluating;
                synchronized (this.evaluating) {
                    this.evaluating[0] = false;
                    this.evaluating.notifyAll();
                    // ** MonitorExit[expr /* !! */ ] (shouldn't be in output)
                    return jw.getValue();
                }
            }
        }

        public synchronized void remove() {
            if (this.evaluatedWatch != null) {
                this.evaluatedWatch.remove();
            } else {
                this.w.remove();
            }
        }

        public void setExpression(String expression) {
            this.w.setExpression(expression);
            this.expressionChanged();
        }

        public synchronized void setValue(String value) throws InvalidExpressionException {
            if (this.evaluatedWatch == null) {
                throw new InvalidExpressionException("Can not set value while evaluating.");
            }
            this.evaluatedWatch.setValue(value);
        }

        protected synchronized void setValue(Value value) throws InvalidExpressionException {
            if (this.evaluatedWatch != null) {
                try {
                    Method setValueMethod = this.evaluatedWatch.getClass().getDeclaredMethod("setValue", Value.class);
                    setValueMethod.setAccessible(true);
                    setValueMethod.invoke((Object)this.evaluatedWatch, value);
                }
                catch (Exception ex) {
                    throw new InvalidExpressionException((Throwable)ex);
                }
            } else {
                throw new InvalidExpressionException("Can not set value while evaluating.");
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JPDAWatchEvaluating) {
                return;
            }
            this.model.fireTableValueChangedChanged(this, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refresh() throws RefreshFailedException {
            boolean[] blArray = this.evaluating;
            synchronized (this.evaluating) {
                if (this.evaluating[0]) {
                    try {
                        this.evaluating.wait();
                    }
                    catch (InterruptedException iex) {
                        throw new RefreshFailedException(iex.getLocalizedMessage());
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public synchronized boolean isCurrent() {
            if (!this.w.isEnabled()) {
                return true;
            }
            return this.evaluatedWatch != null;
        }

        public JPDAWatchEvaluating clone() {
            JPDAWatchEvaluating clon = new JPDAWatchEvaluating(this.model, this.w, this.debugger, this.cloneNumber++);
            clon.setEvaluated(this.evaluatedWatch);
            return clon;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " '" + this.w.getExpression() + "' " + (this.w.isEnabled() ? "enabled." : "disabled.");
        }
    }
}

