/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509Certificate;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class X509CertificateResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(X509CertificateResolver.class.getName());

    public PublicKey engineLookupAndResolvePublicKey(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineLookupResolveX509Certificate(element, string2, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String string2, StorageResolver storageResolver) throws KeyResolverException {
        try {
            Element[] elementArray = XMLUtils.selectDsNodes(element.getFirstChild(), "X509Certificate");
            if (elementArray == null || elementArray.length == 0) {
                Element element2 = XMLUtils.selectDsNode(element.getFirstChild(), "X509Data", 0);
                if (element2 != null) {
                    return this.engineLookupResolveX509Certificate(element2, string2, storageResolver);
                }
                return null;
            }
            for (int i = 0; i < elementArray.length; ++i) {
                XMLX509Certificate xMLX509Certificate = new XMLX509Certificate(elementArray[i], string2);
                X509Certificate x509Certificate = xMLX509Certificate.getX509Certificate();
                if (x509Certificate == null) continue;
                return x509Certificate;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String string2, StorageResolver storageResolver) {
        return null;
    }
}

