/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.Bundle;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.ModuleInfoUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.operations.Operations;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ActionProviderImpl
implements ActionProvider {
    public static final String BUILD_WITH_DEPENDENCIES = "build-with-dependencies";
    private final org.netbeans.api.project.Project proj;
    public static final String COMMAND_RUN_MAIN = "run.single.main";
    public static final String COMMAND_DEBUG_MAIN = "debug.single.main";
    public static final String COMMAND_PROFILE_MAIN = "profile.single.main";
    public static final String COMMAND_INTEGRATION_TEST_SINGLE = "integration-test.single";
    public static final String COMMAND_DEBUG_INTEGRATION_TEST_SINGLE = "debug.integration-test.single";
    private static final String[] supported = new String[]{"build", "build-with-dependencies", "clean", "rebuild", "javadoc", "test", "test.single", "run.single.method", "debug.single.method", "run", "run.single", "debug", "debug.single", "debug.test.single", "debug.fix", "profile", "profile.single", "profile.test.single", "delete", "rename", "move", "copy"};
    private static final RequestProcessor RP = new RequestProcessor(ActionProviderImpl.class.getName(), 3);
    private static final Logger LOG = Logger.getLogger(ActionProviderImpl.class.getName());
    private static final String SUREFIRE_VERSION_SAFE = "2.15";
    private static final String SUREFIRE_VERSION_SAFE_5 = "2.22.0";
    private static final String JUNIT_VERSION_SAFE = "4.11";
    private static final String SHOW_SUREFIRE_WARNING = "showSurefireWarning";
    private static final String SHOW_COMPILER_TOO_OLD_WARNING = "showCompilerTooOldWarning";

    public ActionProviderImpl(org.netbeans.api.project.Project proj) {
        this.proj = proj;
    }

    public String[] getSupportedActions() {
        HashSet<String> supp = new HashSet<String>();
        supp.addAll(Arrays.asList(supported));
        for (MavenActionsProvider mavenActionsProvider : ActionToGoalUtils.actionProviders(this.proj)) {
            Set<String> added = mavenActionsProvider.getSupportedDefaultActions();
            if (added == null) continue;
            supp.addAll(added);
        }
        return supp.toArray(new String[0]);
    }

    private boolean usingSurefire28() {
        String v = PluginPropertyUtils.getPluginVersion(((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.8")) >= 0;
    }

    private boolean usingSurefire2_22() {
        String v = PluginPropertyUtils.getPluginVersion(((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion(SUREFIRE_VERSION_SAFE_5)) >= 0;
    }

    private boolean usingJUnit4() {
        for (Artifact a : ((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifacts()) {
            String version;
            if (!"junit".equals(a.getGroupId()) || !"junit".equals(a.getArtifactId()) && !"junit-dep".equals(a.getArtifactId()) || (version = a.getVersion()) == null || new ComparableVersion(version).compareTo(new ComparableVersion("4.8")) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean usingJUnit5() {
        return ((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifacts().stream().anyMatch(a -> "org.junit.jupiter".equals(a.getGroupId()) && "junit-jupiter-engine".equals(a.getArtifactId()));
    }

    private boolean usingTestNG() {
        for (Artifact a : ((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifacts()) {
            if (!"org.testng".equals(a.getGroupId()) || !"testng".equals(a.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    boolean runSingleMethodEnabled() {
        return this.usingSurefire28() && (this.usingJUnit4() || this.usingTestNG()) || this.usingSurefire2_22() && this.usingJUnit5();
    }

    public void invokeAction(String action, Lookup lookup) {
        this.invokeAction(action, lookup, true);
    }

    private void invokeAction(final String action, final Lookup lookup, boolean checkCompiler) {
        ActionConvertor convertor;
        if (!this.checkSurefire(action) || checkCompiler && !this.checkCompilerPlugin(action)) {
            return;
        }
        if ("delete".equals(action)) {
            DefaultProjectOperations.performDefaultDeleteOperation((org.netbeans.api.project.Project)this.proj);
            return;
        }
        if ("copy".equals(action)) {
            DefaultProjectOperations.performDefaultCopyOperation((org.netbeans.api.project.Project)this.proj);
            return;
        }
        if ("move".equals(action)) {
            DefaultProjectOperations.performDefaultMoveOperation((org.netbeans.api.project.Project)this.proj);
            return;
        }
        if ("rename".equals(action)) {
            Operations.renameProject((NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class));
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ActionProviderImpl.this.invokeAction(action, lookup, false);
                }
            });
            return;
        }
        Collection convertors = this.proj.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator iterator = convertors.iterator();
        while (iterator.hasNext() && (convertedAction = (convertor = (ActionConvertor)iterator.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        ProxyLookup enhanced = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{ActionProviderImpl.replacements(this.proj, convertedAction, lookup)})});
        RunConfig rc = ActionToGoalUtils.createRunConfig(convertedAction, (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), (Lookup)enhanced);
        if (rc == null) {
            Logger.getLogger(ActionProviderImpl.class.getName()).log(Level.INFO, "No handling for action: {0}. Ignoring.", action);
        } else {
            ActionProviderImpl.setupTaskName(action, rc, lookup);
            final ActionProgress listener = ActionProgress.start((Lookup)lookup);
            final ExecutorTask task = RunUtils.run(rc);
            if (task != null) {
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task t) {
                        listener.finished(task.result() == 0);
                    }
                });
            } else {
                listener.finished(false);
            }
        }
    }

    private boolean checkSurefire(String action) {
        if ((action.equals("run.single.method") || action.equals("debug.single.method")) && !this.runSingleMethodEnabled()) {
            final boolean ju5 = this.usingJUnit5();
            if (NbPreferences.forModule(ActionProviderImpl.class).getBoolean(SHOW_SUREFIRE_WARNING, true)) {
                WarnPanel pnl = new WarnPanel(ju5 ? Bundle.TXT_Run_Single_method5() : Bundle.TXT_Run_Single_method());
                Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)pnl, Bundle.TIT_RequiresUpdateOfPOM(), 0));
                if (pnl.disabledWarning()) {
                    NbPreferences.forModule(ActionProviderImpl.class).putBoolean(SHOW_SUREFIRE_WARNING, false);
                }
                if (o == NotifyDescriptor.YES_OPTION) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            String surefireVersion = null;
                            String junitVersion = null;
                            if (ju5 && !ActionProviderImpl.this.usingSurefire2_22()) {
                                surefireVersion = ActionProviderImpl.SUREFIRE_VERSION_SAFE_5;
                            } else if (!ActionProviderImpl.this.usingSurefire28()) {
                                surefireVersion = ActionProviderImpl.SUREFIRE_VERSION_SAFE;
                            }
                            if (!ju5) {
                                junitVersion = ActionProviderImpl.this.usingJUnit4() || ActionProviderImpl.this.usingTestNG() ? null : ActionProviderImpl.JUNIT_VERSION_SAFE;
                            }
                            Utilities.performPOMModelOperations((FileObject)ActionProviderImpl.this.proj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new UpdateSurefireOperation(surefireVersion, junitVersion)));
                        }
                    });
                    return false;
                }
            }
            StatusDisplayer.getDefault().setStatusText(ju5 ? Bundle.run_single_method_disabled5() : Bundle.run_single_method_disabled());
            return false;
        }
        return true;
    }

    private boolean checkCompilerPlugin(String action) {
        if ((action.equals("build") || action.equals("debug") || action.equals("profile") || action.equals("rebuild") || action.equals("run") || action.equals("test")) && !ModuleInfoUtils.checkModuleInfoAndCompilerFit(this.proj) && NbPreferences.forModule(ActionProviderImpl.class).getBoolean(SHOW_COMPILER_TOO_OLD_WARNING, true)) {
            ProjectInformation info = ProjectUtils.getInformation((org.netbeans.api.project.Project)this.proj);
            WarnPanel pnl = new WarnPanel(Bundle.TXT_CompilerTooOld(info.getDisplayName()));
            Object o = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)pnl, Bundle.TIT_RequiresUpdateOfPOM(), 0));
            if (pnl.disabledWarning()) {
                NbPreferences.forModule(ActionProviderImpl.class).putBoolean(SHOW_COMPILER_TOO_OLD_WARNING, false);
            }
            if (o == NotifyDescriptor.YES_OPTION) {
                RequestProcessor.getDefault().post(() -> Utilities.performPOMModelOperations((FileObject)this.proj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new UpdateCompilerOperation())));
                return false;
            }
        }
        return true;
    }

    public static Map<String, String> replacements(org.netbeans.api.project.Project proj, String action, Lookup lookup) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (ReplaceTokenProvider prov : proj.getLookup().lookupAll(ReplaceTokenProvider.class)) {
            replacements.putAll(prov.createReplacements(action, lookup));
        }
        return replacements;
    }

    private static void setupTaskName(String action, RunConfig config, Lookup lkp) {
        String title;
        String prjLabel;
        assert (config instanceof BeanRunConfig);
        BeanRunConfig bc = (BeanRunConfig)config;
        DataObject dobj = (DataObject)lkp.lookup(DataObject.class);
        NbMavenProject prj = (NbMavenProject)bc.getProject().getLookup().lookup(NbMavenProject.class);
        String dobjName = dobj != null ? dobj.getName() : "";
        String string = prjLabel = MavenSettings.OutputTabName.PROJECT_NAME.equals((Object)MavenSettings.getDefault().getOutputTabName()) ? ProjectUtils.getInformation((org.netbeans.api.project.Project)bc.getProject()).getDisplayName() : prj.getMavenProject().getArtifactId();
        if (MavenSettings.getDefault().isOutputTabShowConfig()) {
            prjLabel = prjLabel + ", " + ((M2ConfigProvider)bc.getProject().getLookup().lookup(M2ConfigProvider.class)).getActiveConfiguration().getDisplayName();
        }
        if ("run".equals(action)) {
            title = Bundle.TXT_Run(prjLabel);
        } else if ("debug".equals(action)) {
            title = Bundle.TXT_Debug(prjLabel);
        } else if ("profile".equals(action)) {
            title = Bundle.TXT_Profile(prjLabel);
        } else if ("test".equals(action)) {
            title = Bundle.TXT_Test(prjLabel);
        } else if (action.startsWith("run.single")) {
            title = Bundle.TXT_Run(dobjName);
        } else if (action.startsWith("debug.single") || "debug.test.single".equals(action)) {
            title = Bundle.TXT_Debug(dobjName);
        } else if (action.startsWith("profile.single") || "profile.test.single".equals(action)) {
            title = Bundle.TXT_Profile(dobjName);
        } else if ("test.single".equals(action)) {
            title = Bundle.TXT_Test(dobjName);
        } else if ("debug.fix".equals(action)) {
            title = Bundle.TXT_ApplyCodeChanges(prjLabel);
        } else if ("custom".equals(action)) {
            String name = config.getActionName();
            if (name != null && name.startsWith("CUSTOM-")) {
                name = name.substring("CUSTOM-".length());
            }
            title = name != null ? Bundle.TXT_CustomNamed(name, prjLabel) : Bundle.TXT_Build(prjLabel);
        } else {
            title = Bundle.TXT_Build(prjLabel);
        }
        bc.setTaskDisplayName(title);
        bc.setExecutionName(title);
    }

    public boolean isActionEnabled(String action, Lookup lookup) {
        ActionConvertor convertor;
        if ("delete".equals(action) || "rename".equals(action) || "copy".equals(action) || "move".equals(action)) {
            return true;
        }
        if (action.equals("run.single.method") || action.equals("debug.single.method")) {
            return true;
        }
        Collection convertors = this.proj.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator iterator = convertors.iterator();
        while (iterator.hasNext() && (convertedAction = (convertor = (ActionConvertor)iterator.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        return ActionToGoalUtils.isActionEnable(convertedAction, (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), lookup);
    }

    public static Action createCustomMavenAction(String name, NetbeansActionMapping mapping, boolean showUI, Lookup context, org.netbeans.api.project.Project project) {
        return new CustomAction(name, mapping, showUI, context, project);
    }

    public static ContextAwareAction customPopupActions() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(org.netbeans.api.project.Project p, FileObject fo) {
                CustomPopupActions customPopupActions;
                ActionProviderImpl ap = (ActionProviderImpl)p.getLookup().lookup(ActionProviderImpl.class);
                if (ap != null) {
                    ActionProviderImpl actionProviderImpl = ap;
                    actionProviderImpl.getClass();
                    customPopupActions = actionProviderImpl.new CustomPopupActions(this.triggeredOnFile, this.triggeredOnPom, fo);
                } else {
                    customPopupActions = null;
                }
                return customPopupActions;
            }
        };
    }

    public static ContextAwareAction closeSubprojectsAction() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(org.netbeans.api.project.Project p, FileObject fo) {
                NbMavenProjectImpl project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                if (project != null && "pom".equalsIgnoreCase(project.getProjectWatcher().getPackagingType())) {
                    return new CloseSubprojectsAction(project);
                }
                return null;
            }
        };
    }

    public static ContextAwareAction buildWithDependenciesAction() {
        return (ContextAwareAction)ProjectSensitiveActions.projectCommandAction((String)BUILD_WITH_DEPENDENCIES, (String)Bundle.ACT_Build_Deps(), null);
    }

    private static class UpdateCompilerOperation
    implements ModelOperation<POMModel> {
        private UpdateCompilerOperation() {
        }

        public void performOperation(POMModel model) {
            Project prj = model.getProject();
            ModelUtils.updatePluginVersion("org.apache.maven.plugins", "maven-compiler-plugin", "3.6.1", prj);
            ModelUtils.openAtPlugin(model, "org.apache.maven.plugins", "maven-compiler-plugin");
        }
    }

    private static class UpdateSurefireOperation
    implements ModelOperation<POMModel> {
        private final String newJUnit;
        private final String newSurefirePluginVersion;

        public UpdateSurefireOperation(@NullAllowed String newSurefirePluginVersion, @NullAllowed String newJUnit) {
            this.newSurefirePluginVersion = newSurefirePluginVersion;
            this.newJUnit = newJUnit;
        }

        public void performOperation(POMModel model) {
            Project prj = model.getProject();
            if (this.newJUnit != null) {
                this.findDependency("junit", "junit", this.newJUnit, prj);
            }
            if (this.newSurefirePluginVersion != null) {
                ModelUtils.updatePluginVersion("org.apache.maven.plugins", "maven-surefire-plugin", this.newSurefirePluginVersion, prj);
            }
            ModelUtils.openAtPlugin(model, "org.apache.maven.plugins", "maven-surefire-plugin");
        }

        private void findDependency(String groupId, String artifactID, String newVersion, Project prj) {
            Dependency dep;
            DependencyManagement dm = prj.getDependencyManagement();
            boolean setInDM = false;
            boolean setInDeps = false;
            if (dm != null && (dep = dm.findDependencyById(groupId, artifactID, null)) != null) {
                dep.setVersion(newVersion);
                setInDM = true;
            }
            if ((dep = prj.findDependencyById(groupId, artifactID, null)) != null) {
                if (dep.getVersion() != null) {
                    dep.setVersion(newVersion);
                    setInDeps = true;
                } else if (!setInDM) {
                    dep.setVersion(newVersion);
                    setInDeps = true;
                }
            }
            if (!setInDM && !setInDeps) {
                Dependency d = prj.getModel().getFactory().createDependency();
                d.setArtifactId(artifactID);
                d.setGroupId(groupId);
                d.setVersion(newVersion);
                prj.addDependency(d);
            }
        }
    }

    private static class CloseSubprojectsAction
    extends AbstractAction {
        private final NbMavenProjectImpl project;

        public CloseSubprojectsAction(NbMavenProjectImpl project) {
            this.project = project;
            this.putValue("Name", Bundle.ACT_CloseRequired());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Set res = ProjectUtils.getContainedProjects((org.netbeans.api.project.Project)project, (boolean)true);
                    org.netbeans.api.project.Project[] arr = res.toArray(new org.netbeans.api.project.Project[res.size()]);
                    OpenProjects.getDefault().close(arr);
                }
            });
        }
    }

    private final class CustomPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private final boolean onFile;
        private final boolean onPom;
        private final Lookup lookup;

        private CustomPopupActions(boolean onFile, boolean onPomFile, FileObject fo) {
            this.putValue("Name", onFile ? Bundle.LBL_Custom_Run_File() : Bundle.LBL_Custom_Run());
            this.onFile = onFile;
            this.onPom = onPomFile;
            this.lookup = fo != null ? Lookups.singleton((Object)fo) : Lookup.EMPTY;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu menu = new JMenu(this.onFile ? Bundle.LBL_Custom_Run_File() : Bundle.LBL_Custom_Run());
            final JMenuItem loading = new JMenuItem(Bundle.LBL_Loading());
            menu.add(loading);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    NetbeansActionMapping[] maps = CustomPopupActions.this.onFile && !CustomPopupActions.this.onPom ? ActionToGoalUtils.getActiveCustomMappingsForFile((NbMavenProjectImpl)ActionProviderImpl.this.proj.getLookup().lookup(NbMavenProjectImpl.class)) : ActionToGoalUtils.getActiveCustomMappings((NbMavenProjectImpl)ActionProviderImpl.this.proj.getLookup().lookup(NbMavenProjectImpl.class));
                    final ArrayList<Action> acts = new ArrayList<Action>();
                    for (NetbeansActionMapping mapp : maps) {
                        Action act = ActionProviderImpl.createCustomMavenAction(mapp.getActionName(), mapp, false, CustomPopupActions.this.lookup, ActionProviderImpl.this.proj);
                        act.putValue("Name", mapp.getDisplayName() == null ? mapp.getActionName() : mapp.getDisplayName());
                        acts.add(act);
                    }
                    acts.add(ActionProviderImpl.createCustomMavenAction(Bundle.LBL_Custom_run_goals(), new NetbeansActionMapping(), true, CustomPopupActions.this.lookup, ActionProviderImpl.this.proj));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean selected = menu.isSelected();
                            menu.remove(loading);
                            for (Action a : acts) {
                                menu.add(new JMenuItem(a));
                            }
                            menu.getPopupMenu().pack();
                            menu.repaint();
                            menu.updateUI();
                            menu.setSelected(selected);
                        }
                    });
                }
            }, 100);
            return menu;
        }
    }

    private static abstract class ConditionallyShownAction
    extends AbstractAction
    implements ContextAwareAction {
        protected boolean triggeredOnFile = false;
        protected boolean triggeredOnPom = false;

        protected ConditionallyShownAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            assert (false);
        }

        protected abstract Action forProject(@NonNull org.netbeans.api.project.Project var1, @NullAllowed FileObject var2);

        public final Action createContextAwareInstance(Lookup actionContext) {
            this.triggeredOnFile = false;
            this.triggeredOnPom = false;
            Collection projects = actionContext.lookupAll(org.netbeans.api.project.Project.class);
            if (projects.size() != 1) {
                Collection fobs = actionContext.lookupAll(FileObject.class);
                if (fobs.size() == 1) {
                    FileObject fo = (FileObject)fobs.iterator().next();
                    if ("pom.xml".equals(fo.getNameExt())) {
                        org.netbeans.api.project.Project p = null;
                        FileObject parent = fo.getParent();
                        for (org.netbeans.api.project.Project prj : projects) {
                            if (!prj.getProjectDirectory().equals(parent)) continue;
                            p = prj;
                            break;
                        }
                        if (p == null) {
                            p = FileOwnerQuery.getOwner((FileObject)fo);
                        }
                        if (p != null) {
                            this.triggeredOnFile = true;
                            this.triggeredOnPom = true;
                            Action a = this.forProject(p, null);
                            return a != null ? a : this;
                        }
                    } else {
                        org.netbeans.api.project.Project p = this.findOwner(projects, fo);
                        if (p == null) {
                            p = FileOwnerQuery.getOwner((FileObject)fo);
                        }
                        if (p != null) {
                            this.triggeredOnFile = true;
                            Action a = this.forProject(p, fo);
                            return a != null ? a : this;
                        }
                    }
                }
                return this;
            }
            Action a = this.forProject((org.netbeans.api.project.Project)projects.iterator().next(), null);
            return a != null ? a : this;
        }

        private org.netbeans.api.project.Project findOwner(Collection<? extends org.netbeans.api.project.Project> projects, FileObject fo) {
            FileObject parent = fo.getParent();
            if (parent == null) {
                return null;
            }
            for (org.netbeans.api.project.Project project : projects) {
                if (!project.getProjectDirectory().equals(fo.getParent())) continue;
                return project;
            }
            return null;
        }
    }

    private static final class CustomAction
    extends AbstractAction {
        private final NetbeansActionMapping mapping;
        private final boolean showUI;
        private final Lookup context;
        private final org.netbeans.api.project.Project proj;

        private CustomAction(String name, NetbeansActionMapping mapp, boolean showUI, Lookup context, org.netbeans.api.project.Project project) {
            this.mapping = mapp;
            this.putValue("Name", name);
            this.showUI = showUI;
            this.context = context;
            this.proj = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, String> replacements = ActionProviderImpl.replacements(this.proj, (String)this.getValue("Name"), this.context);
            for (Map.Entry<String, String> entry : this.mapping.getProperties().entrySet()) {
                entry.setValue(AbstractMavenActionsProvider.dynamicSubstitutions(replacements, entry.getValue()));
            }
            if (!this.showUI) {
                final M2ConfigProvider conf = (M2ConfigProvider)this.proj.getLookup().lookup(M2ConfigProvider.class);
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ModelRunConfig rc = this.createCustomRunConfig(conf);
                        ActionProviderImpl.setupTaskName("custom", rc, context);
                        RunUtils.run(rc);
                    }
                });
                return;
            }
            RunGoalsPanel pnl = new RunGoalsPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_Maven());
            final ActionToGoalMapping maps = ActionToGoalUtils.readMappingsFromFileAttributes(this.proj.getProjectDirectory());
            pnl.readMapping(this.mapping, (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), maps);
            pnl.setShowDebug(MavenSettings.getDefault().isShowDebug());
            pnl.setOffline(MavenSettings.getDefault().isOffline() != null ? MavenSettings.getDefault().isOffline() : false);
            pnl.setRecursive(true);
            Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retValue == DialogDescriptor.OK_OPTION) {
                pnl.applyValues(this.mapping);
                if (maps.getActions().size() > 10) {
                    maps.getActions().remove(0);
                }
                maps.getActions().add(this.mapping);
                final String remembered = pnl.isRememberedAs();
                final Boolean offline = pnl.isOffline();
                final boolean debug = pnl.isShowDebug();
                final boolean recursive = pnl.isRecursive();
                final boolean updateSnapshots = pnl.isUpdateSnapshots();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        M2ConfigProvider conf = (M2ConfigProvider)proj.getLookup().lookup(M2ConfigProvider.class);
                        ActionToGoalUtils.writeMappingsToFileAttributes(proj.getProjectDirectory(), maps);
                        if (remembered != null) {
                            try {
                                String tit = "CUSTOM-" + remembered;
                                mapping.setActionName(tit);
                                mapping.setDisplayName(remembered);
                                ModelHandle2.putMapping(mapping, proj, conf.getDefaultConfig());
                            }
                            catch (IOException ex) {
                                LOG.log(Level.INFO, "Cannot write custom action mapping", ex);
                            }
                        }
                        ModelRunConfig rc = this.createCustomRunConfig(conf);
                        rc.setOffline(offline);
                        rc.setShowDebug(debug);
                        rc.setRecursive(recursive);
                        rc.setUpdateSnapshots(updateSnapshots);
                        ActionProviderImpl.setupTaskName("custom", rc, Lookup.EMPTY);
                        RunUtils.run(rc);
                    }
                });
            }
        }

        private ModelRunConfig createCustomRunConfig(M2ConfigProvider conf) {
            ModelRunConfig rc = new ModelRunConfig(this.proj, this.mapping, this.mapping.getActionName(), null, Lookup.EMPTY, false);
            ArrayList<String> acts = new ArrayList<String>();
            acts.addAll(rc.getActivatedProfiles());
            acts.addAll(conf.getActiveConfiguration().getActivatedProfiles());
            rc.setActivatedProfiles(acts);
            HashMap<String, String> props = new HashMap<String, String>(rc.getProperties());
            props.putAll(conf.getActiveConfiguration().getProperties());
            rc.addProperties(props);
            rc.setTaskDisplayName(Bundle.TXT_Build(((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifactId()));
            return rc;
        }
    }
}

