/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.gradle.GradleAuxiliaryConfigImpl;
import org.netbeans.modules.gradle.GradleAuxiliaryPropertiesImpl;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.GradleProjectCache;
import org.netbeans.modules.gradle.GradleSharabilityQueryImpl;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.spi.GradleFiles;
import org.netbeans.modules.gradle.spi.GradleSettings;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NbGradleProjectImpl
implements Project {
    private static final Logger LOG = Logger.getLogger(NbGradleProjectImpl.class.getName());
    public static final RequestProcessor RELOAD_RP = new RequestProcessor("Gradle project reloading", 1);
    private final RequestProcessor.Task reloadTask = RELOAD_RP.create(new Runnable(){

        @Override
        public void run() {
            NbGradleProjectImpl.this.project = NbGradleProjectImpl.this.loadProject();
            ACCESSOR.doFireReload(NbGradleProjectImpl.this.watcher);
        }
    });
    private final FileObject projectDir;
    private final ProjectState projectState;
    private final Lookup lookup;
    private final Lookup basicLookup;
    private final Lookup completeLookup;
    private Updater openedProjectUpdater;
    private NbGradleProject.Quality aimedQuality = NbGradleProject.Quality.FALLBACK;
    @NonNull
    private final NbGradleProject watcher;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static WatcherAccessor ACCESSOR = null;
    GradleProject project;
    private final GradleFiles gradleFiles;

    public boolean isGradleProjectLoaded() {
        return this.project != null;
    }

    public NbGradleProjectImpl(FileObject projectDir, ProjectState projectState) {
        this.projectDir = projectDir;
        this.projectState = projectState;
        this.gradleFiles = new GradleFiles(FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)projectDir)), true);
        this.lookup = Lookups.proxy((Lookup.Provider)new Lookup.Provider(){

            public Lookup getLookup() {
                if (NbGradleProjectImpl.this.completeLookup == null) {
                    LOG.log(Level.FINE, "Accessing project's lookup before the instance is fully initialized at " + NbGradleProjectImpl.this.gradleFiles.getBuildScript(), new Exception());
                    assert (NbGradleProjectImpl.this.basicLookup != null);
                    return NbGradleProjectImpl.this.basicLookup;
                }
                return NbGradleProjectImpl.this.completeLookup;
            }
        });
        this.watcher = ACCESSOR.createWatcher(this);
        GradleAuxiliaryConfigImpl aux = new GradleAuxiliaryConfigImpl(projectDir, true);
        this.basicLookup = this.createBasicLookup(projectState, aux);
        this.completeLookup = LookupProviderSupport.createCompositeLookup((Lookup)this.basicLookup, (Lookup)new PluginDependentLookup(this.watcher));
    }

    public GradleFiles getGradleFiles() {
        return this.gradleFiles;
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createBasicLookup(ProjectState state, GradleAuxiliaryConfigImpl aux) {
        return Lookups.fixed((Object[])new Object[]{this, this.watcher, new CacheDirProvider(), aux, aux.getProblemProvider(), new GradleAuxiliaryPropertiesImpl(this), new GradleSharabilityQueryImpl(this), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl()), UILookupMergerSupport.createProjectProblemsProviderMerger(), UILookupMergerSupport.createRecommendedTemplatesMerger(), UILookupMergerSupport.createPrivilegedTemplatesMerger(), state});
    }

    public GradleProject getGradleProject() {
        if (this.project == null) {
            this.project = this.loadProject();
        }
        return this.project;
    }

    public void fireProjectReload(boolean wait) {
        this.reloadTask.schedule(0);
        if (wait) {
            this.reloadTask.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachAllUpdater() {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.openedProjectUpdater == null) {
                this.openedProjectUpdater = new Updater(new FileProvider(){

                    @Override
                    public Set<File> getFiles() {
                        GradleFiles gf = NbGradleProjectImpl.this.getGradleFiles();
                        LinkedHashSet<File> ret = new LinkedHashSet<File>();
                        for (GradleFiles.Kind kind : GradleFiles.Kind.PROJECT_FILES) {
                            ret.add(gf.getFile(kind));
                        }
                        return ret;
                    }
                });
            }
        }
        this.openedProjectUpdater.attachAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachAllUpdater() {
        NbGradleProjectImpl nbGradleProjectImpl = this;
        synchronized (nbGradleProjectImpl) {
            if (this.openedProjectUpdater != null) {
                this.openedProjectUpdater.detachAll();
            }
        }
    }

    void dumpProject() {
        this.project = null;
    }

    public NbGradleProject.Quality getAimedQuality() {
        return this.aimedQuality;
    }

    public NbGradleProject getProjectWatcher() {
        return this.watcher;
    }

    public void setAimedQuality(NbGradleProject.Quality aim) {
        if (this.aimedQuality == NbGradleProject.Quality.FALLBACK && aim.betterThan(NbGradleProject.Quality.FALLBACK)) {
            ACCESSOR.activate(this.watcher);
        }
        if (aim == NbGradleProject.Quality.FALLBACK && this.aimedQuality.betterThan(NbGradleProject.Quality.FALLBACK)) {
            ACCESSOR.passivate(this.watcher);
        }
        this.aimedQuality = aim;
        if (this.project == null || this.project.getQuality().worseThan(aim)) {
            this.project = this.loadProject();
            ACCESSOR.doFireReload(this.watcher);
        }
    }

    private GradleProject loadProject() {
        return this.loadProject(false, this.aimedQuality, new String[0]);
    }

    private GradleProject loadProject(boolean ignoreCache, NbGradleProject.Quality aim, String ... args) {
        GradleProject prj = GradleProjectCache.loadProject(this, aim, ignoreCache, false, args);
        return prj;
    }

    void reloadProject(boolean ignoreCache, NbGradleProject.Quality aim, String ... args) {
        RELOAD_RP.post(() -> {
            this.project = this.loadProject(ignoreCache, aim, args);
            ACCESSOR.doFireReload(this.watcher);
        });
    }

    public int hashCode() {
        return this.gradleFiles.hashCode() * 3;
    }

    public boolean equals(Object obj) {
        NbGradleProjectImpl impl;
        if (obj instanceof Project && (impl = (NbGradleProjectImpl)((Project)obj).getLookup().lookup(NbGradleProjectImpl.class)) != null) {
            return this.getGradleFiles().equals(impl.getGradleFiles());
        }
        return false;
    }

    public String toString() {
        if (this.isGradleProjectLoaded()) {
            return "Gradle: " + this.project.getBaseProject().getName() + "[" + (Object)((Object)this.project.getQuality()) + "]";
        }
        return "Unloaded Gradle Project: " + this.gradleFiles.toString();
    }

    static {
        Class<NbGradleProject> c = NbGradleProject.class;
        try {
            Class.forName(c.getName(), true, c.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, "very wrong, very wrong, yes indeed", ex);
        }
    }

    private class Updater
    implements FileChangeListener {
        final FileProvider fileProvider;
        Set<File> filesToWatch;
        long lastEventTime = 0L;

        Updater(FileProvider fp) {
            this.fileProvider = fp;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
            if (this.lastEventTime < fe.getTime()) {
                this.lastEventTime = System.currentTimeMillis();
                NbGradleProjectImpl.this.fireProjectReload(false);
            }
        }

        public void fileChanged(FileEvent fe) {
            if (this.lastEventTime < fe.getTime()) {
                this.lastEventTime = System.currentTimeMillis();
                NbGradleProjectImpl.this.fireProjectReload(false);
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.lastEventTime = System.currentTimeMillis();
            NbGradleProjectImpl.this.fireProjectReload(false);
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        synchronized void attachAll() {
            this.filesToWatch = this.fileProvider.getFiles();
            if (this.filesToWatch != null) {
                for (File f : this.filesToWatch) {
                    try {
                        FileUtil.addFileChangeListener((FileChangeListener)this, (File)f);
                    }
                    catch (IllegalArgumentException ex) {
                        assert (false) : "Project opened twice in a row";
                    }
                }
            }
        }

        synchronized void detachAll() {
            if (this.filesToWatch != null) {
                for (File f : this.filesToWatch) {
                    try {
                        FileUtil.removeFileChangeListener((FileChangeListener)this, (File)f);
                    }
                    catch (IllegalArgumentException ex) {
                        assert (false) : "Project closed twice in a row";
                    }
                }
            }
        }
    }

    private static class PluginDependentLookup
    extends ProxyLookup
    implements PropertyChangeListener {
        private static final String NB_GENERAL = "<nb-general>";
        private static final String NB_ROOT_PLUGIN = "root";
        private final WeakReference<NbGradleProject> watcherRef;
        private final Map<String, Lookup> pluginLookups = new HashMap<String, Lookup>();

        public PluginDependentLookup(NbGradleProject watcher) {
            this.watcherRef = new WeakReference<NbGradleProject>(watcher);
            Lookup general = Lookups.forPath((String)"Projects/org-netbeans-modules-gradle/Lookup");
            this.pluginLookups.put(NB_GENERAL, general);
            this.check();
            watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)watcher));
        }

        private void check() {
            boolean lookupsChanged = false;
            NbGradleProject watcher = (NbGradleProject)this.watcherRef.get();
            if (watcher != null) {
                lookupsChanged = !watcher.isGradleProjectLoaded();
                GradleBaseProject prj = watcher.projectLookup(GradleBaseProject.class);
                HashSet<String> currentPlugins = new HashSet<String>(prj.getPlugins());
                if (prj.isRoot()) {
                    currentPlugins.add(NB_ROOT_PLUGIN);
                }
                for (String cp : currentPlugins) {
                    if (this.pluginLookups.containsKey(cp)) continue;
                    Lookup pluginLookup = Lookups.forPath((String)("Projects/org-netbeans-modules-gradle/Plugins/" + cp + "/Lookup"));
                    this.pluginLookups.put(cp, pluginLookup);
                    lookupsChanged = true;
                }
                Iterator<String> it = this.pluginLookups.keySet().iterator();
                while (it.hasNext()) {
                    String oldPlugin = it.next();
                    if (currentPlugins.contains(oldPlugin) || NB_GENERAL.equals(oldPlugin)) continue;
                    it.remove();
                    lookupsChanged = true;
                }
            }
            if (lookupsChanged) {
                this.setLookups(this.pluginLookups.values().toArray(new Lookup[this.pluginLookups.size()]));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.check();
            }
        }
    }

    private class CacheDirProvider
    implements CacheDirectoryProvider {
        private CacheDirProvider() {
        }

        public FileObject getCacheDirectory() throws IOException {
            return FileUtil.createFolder((File)GradleProjectCache.getCacheDir(NbGradleProjectImpl.this.gradleFiles));
        }
    }

    static interface FileProvider {
        public Set<File> getFiles();
    }

    private class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            Runnable open = () -> {
                NbGradleProjectImpl.this.setAimedQuality(NbGradleProject.Quality.FULL);
                NbGradleProjectImpl.this.attachAllUpdater();
                if (ProjectProblems.isBroken((Project)NbGradleProjectImpl.this)) {
                    ProjectProblems.showAlert((Project)NbGradleProjectImpl.this);
                }
            };
            if (GradleSettings.getDefault().isOpenLazy()) {
                RELOAD_RP.post(open, 100);
            } else {
                open.run();
            }
        }

        protected void projectClosed() {
            NbGradleProjectImpl.this.setAimedQuality(NbGradleProject.Quality.FALLBACK);
            NbGradleProjectImpl.this.detachAllUpdater();
            NbGradleProjectImpl.this.dumpProject();
        }
    }

    public static abstract class WatcherAccessor {
        public abstract NbGradleProject createWatcher(NbGradleProjectImpl var1);

        public abstract void doFireReload(NbGradleProject var1);

        public abstract void activate(NbGradleProject var1);

        public abstract void passivate(NbGradleProject var1);
    }
}

