/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.io.File;
import java.util.Iterator;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.web.clientproject.api.WebClientProjectConstants;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class LibraryUtils {
    private static final String DEFAULT_LIBRARY_FOLDER = "js/libs";
    private static final String PREFERENCES_LIBRARY_FOLDER = "js.libs.folder";

    private LibraryUtils() {
        assert (false);
    }

    public static boolean isBroken(Project project, Library.Version library) {
        assert (project != null);
        assert (library != null);
        if (!library.isPersisted()) {
            return false;
        }
        String[] localFiles = library.getLocalFiles();
        if (localFiles == null) {
            return true;
        }
        FileObject projectDirectory = project.getProjectDirectory();
        for (String localFile : localFiles) {
            FileObject file = projectDirectory.getFileObject(localFile);
            if (file != null && file.isValid()) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static File getWebRoot(Project project) {
        Iterator iterator = ProjectWebRootQuery.getWebRoots((Project)project).iterator();
        if (iterator.hasNext()) {
            FileObject webRoot = (FileObject)iterator.next();
            return FileUtil.toFile((FileObject)webRoot);
        }
        return FileUtil.toFile((FileObject)project.getProjectDirectory());
    }

    public static String getLibraryFolder(Project project) {
        return LibraryUtils.getProjectPreferences(project).get(PREFERENCES_LIBRARY_FOLDER, DEFAULT_LIBRARY_FOLDER);
    }

    public static void storeLibraryFolder(Project project, String libraryFolder) {
        LibraryUtils.getProjectPreferences(project).put(PREFERENCES_LIBRARY_FOLDER, libraryFolder);
    }

    private static Preferences getProjectPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, WebClientProjectConstants.class, (boolean)true);
    }
}

