/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.Utils;
import org.netbeans.spi.project.SourceGroupModifierImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class GradleSourcesImpl
implements Sources,
SourceGroupModifierImplementation {
    private static final Map<String, String> COMMON_NAMES = new HashMap<String, String>();
    private final Project proj;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NbGradleProject.get((Project)GradleSourcesImpl.this.proj).isUnloadable()) {
                return;
            }
            if ("ProjectInfo".equals(evt.getPropertyName()) || "resources".equals(evt.getPropertyName())) {
                GradleSourcesImpl.this.checkChanges(true);
            }
        }
    };
    private Map<String, GradleJavaSourceSet> gradleSources = Collections.emptyMap();
    private Map<String, Collection<File>> sourceGroups;
    private final Map<Pair<String, File>, SourceGroup> cache = new HashMap<Pair<String, File>, SourceGroup>();

    public GradleSourcesImpl(Project proj) {
        this.proj = proj;
    }

    public synchronized SourceGroup[] getSourceGroups(String type) {
        if ("generic".equals(type)) {
            return new SourceGroup[]{new GradleSourceGroup(this.proj.getProjectDirectory(), "ProjectRoot", ProjectUtils.getInformation((Project)this.proj).getDisplayName())};
        }
        this.checkChanges(false);
        ArrayList<SourceGroup> ret = new ArrayList<SourceGroup>();
        for (String group : this.gradleSources.keySet()) {
            for (GradleJavaSourceSet.SourceType langType : GradleJavaSourceSet.SourceType.values()) {
                Set<File> dirs = this.gradleSources.get(group).getSourceDirs(langType);
                boolean unique = dirs.size() == 1;
                for (File dir : dirs) {
                    if (!dir.isDirectory()) continue;
                    ret.add(this.createSourceGroup(unique, group, dir, langType));
                }
            }
        }
        Collections.sort(ret, Comparator.comparing(SourceGroup::getName));
        return ret.toArray(new SourceGroup[ret.size()]);
    }

    SourceGroup createSourceGroup(boolean unique, String group, File dir, GradleJavaSourceSet.SourceType lang) {
        SourceGroup ret = this.cache.get(Pair.of((Object)lang.name(), (Object)dir));
        if (ret == null) {
            String msgKey = group + "." + lang.name();
            String groupKey = GradleSourcesImpl.sourceGroupName(msgKey, dir);
            String sgDisplayName = !"gatling".equals(group) ? GradleSourcesImpl.sourceGroupDisplayName(unique, group, dir, lang) : GradleSourcesImpl.gatlingSourceGroupDisplayName(unique, dir, lang);
            ret = new GradleSourceGroup(FileUtil.toFileObject((File)dir), groupKey, sgDisplayName);
            this.cache.put((Pair<String, File>)Pair.of((Object)lang.name(), (Object)dir), ret);
        }
        return ret;
    }

    SourceGroup createGeneratedSourceGroup(boolean unique, String group, File dir) {
        SourceGroup ret = this.cache.get(Pair.of((Object)"GENERATED", (Object)dir));
        if (ret == null) {
            String msgKey = group + ".GENERATED";
            String groupKey = GradleSourcesImpl.sourceGroupName(msgKey, dir);
            String sgDisplayName = GradleSourcesImpl.sourceGroupDisplayName(unique, group, dir, GradleJavaSourceSet.SourceType.JAVA);
            ret = new GradleSourceGroup(FileUtil.toFileObject((File)dir), groupKey, sgDisplayName);
            this.cache.put((Pair<String, File>)Pair.of((Object)"GENERATED", (Object)dir), ret);
        }
        return ret;
    }

    static String sourceGroupName(String key, File dir) {
        String ret = COMMON_NAMES.get(key + "." + dir.getName());
        ret = ret == null ? COMMON_NAMES.get(key) : ret;
        ret = ret == null ? "99" + key : ret;
        return ret;
    }

    static String sourceGroupDisplayName(boolean unique, String group, File dir, GradleJavaSourceSet.SourceType lang) {
        StringBuilder key = new StringBuilder();
        key.append("main".equals(group) ? "MAIN_" : "OTHER_");
        key.append(lang != GradleJavaSourceSet.SourceType.RESOURCES ? "LANG" : "RESOURCES");
        if (unique) {
            key.append("_UNIQUE");
        }
        String llang = lang.name().toLowerCase();
        String ggroup = Utils.camelCaseToTitle((String)group);
        if (!unique && llang.equals(dir.getName())) {
            dir = dir.getParentFile() != null ? dir.getParentFile() : dir;
        }
        return NbBundle.getMessage(GradleSourcesImpl.class, (String)key.toString(), (Object)ggroup, (Object)llang, (Object)dir.getName());
    }

    static String gatlingSourceGroupDisplayName(boolean unique, File dir, GradleJavaSourceSet.SourceType lang) {
        StringBuilder key = new StringBuilder("GATLING_");
        String dirName = dir.getName();
        if (lang == GradleJavaSourceSet.SourceType.RESOURCES) {
            switch (dirName) {
                case "bodies": {
                    key.append("BODIES");
                    break;
                }
                case "data": {
                    key.append("DATA");
                    break;
                }
                default: {
                    key.append("OTHER");
                }
            }
        }
        if (lang == GradleJavaSourceSet.SourceType.SCALA) {
            key.append("SCENARIOES");
            if (unique) {
                key.append("_UNIQUE");
            }
        }
        return NbBundle.getMessage(GradleSourcesImpl.class, (String)key.toString(), (Object)dir.getName());
    }

    private void checkChanges(boolean fireChanges) {
        boolean changed;
        boolean bl = changed = this.sourceGroups == null;
        if (GradleJavaProject.get(this.proj) != null) {
            Map<String, GradleJavaSourceSet> newSources = GradleJavaProject.get(this.proj).getSourceSets();
            if (this.sourceGroups != null) {
                HashSet<String> enteringGroups = new HashSet<String>(newSources.keySet());
                HashSet<String> leavingGroups = new HashSet<String>(this.sourceGroups.keySet());
                HashSet<String> remainingGroups = new HashSet<String>(newSources.keySet());
                remainingGroups.retainAll(this.sourceGroups.keySet());
                enteringGroups.removeAll(remainingGroups);
                leavingGroups.removeAll(remainingGroups);
                boolean bl2 = changed = !leavingGroups.isEmpty() || !enteringGroups.isEmpty();
                if (!changed) {
                    for (String rg : remainingGroups) {
                        if (this.sourceGroups.get(rg).equals(newSources.get(rg).getAvailableDirs(false))) continue;
                        changed = true;
                        break;
                    }
                }
            }
            this.sourceGroups = new HashMap<String, Collection<File>>();
            for (Map.Entry<String, GradleJavaSourceSet> entry : newSources.entrySet()) {
                this.sourceGroups.put(entry.getKey(), entry.getValue().getAvailableDirs(false));
            }
            this.gradleSources = newSources;
            this.cache.clear();
        }
        if (changed && fireChanges) {
            this.cs.fireChange();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (!this.cs.hasListeners()) {
            NbGradleProject.addPropertyChangeListener((Project)this.proj, (PropertyChangeListener)this.pcl);
        }
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
        if (!this.cs.hasListeners()) {
            NbGradleProject.removePropertyChangeListener((Project)this.proj, (PropertyChangeListener)this.pcl);
        }
    }

    public SourceGroup createSourceGroup(String type, String hint) {
        SourceGroup ret = null;
        GradleJavaProject gp = GradleJavaProject.get(this.proj);
        GradleJavaSourceSet ss = gp.getSourceSets().get(hint);
        if (ss != null) {
            try {
                File sgroot;
                GradleJavaSourceSet.SourceType st = GradleJavaSourceSet.SourceType.valueOf(type.toUpperCase());
                if (ss.getSourceDirs(st).size() == 1 && !(sgroot = ss.getSourceDirs(st).iterator().next()).exists()) {
                    FileUtil.createFolder((File)sgroot);
                    ret = this.createSourceGroup(true, hint, sgroot, st);
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean canCreateSourceGroup(String type, String hint) {
        boolean ret = "resources".equals(type);
        GradleJavaProject gp = GradleJavaProject.get(this.proj);
        ret = ret || GradleBaseProject.get((Project)this.proj).hasPlugins(new String[]{type});
        return ret && gp.getSourceSets().containsKey(hint);
    }

    static {
        COMMON_NAMES.put("main.JAVA", "01main.java");
        COMMON_NAMES.put("main.GROOVY", "02main.groovy");
        COMMON_NAMES.put("main.SCALA", "03main.scala");
        COMMON_NAMES.put("main.GENERATED", "04main.generated");
        COMMON_NAMES.put("main.RESOURCES", "09main.resources");
        COMMON_NAMES.put("test.JAVA", "11test.java");
        COMMON_NAMES.put("test.GROOVY", "12test.groovy");
        COMMON_NAMES.put("test.SCALA", "13test.scala");
        COMMON_NAMES.put("test.GENERATED", "14test.generated");
        COMMON_NAMES.put("test.RESOURCES", "19test.resources");
        COMMON_NAMES.put("gatling.SCALA", "41gatling.scala");
        COMMON_NAMES.put("gatling.RESOURCES.data", "42gatling.data");
        COMMON_NAMES.put("gatling.RESOURCES.bodies", "43gatling.bodies");
        COMMON_NAMES.put("gatling.RESOURCES", "49gatling.resources");
    }

    private final class GradleSourceGroup
    implements SourceGroup {
        private final FileObject rootFolder;
        private final String name;
        private final String displayName;

        public GradleSourceGroup(FileObject rootFolder, String name, String displayName) {
            this.rootFolder = rootFolder;
            this.name = name;
            this.displayName = displayName;
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean opened) {
            return null;
        }

        public boolean contains(FileObject file) {
            if (file != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)file)) {
                return false;
            }
            if (GradleSourcesImpl.this.proj != null) {
                if (file.isFolder() && file != GradleSourcesImpl.this.proj.getProjectDirectory() && ProjectManager.getDefault().isProject(file)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner((FileObject)file) != GradleSourcesImpl.this.proj) {
                    return false;
                }
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public String toString() {
            return "GradleSourceGroup: " + this.getDisplayName() + ", " + this.rootFolder.toString();
        }
    }
}

