/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.HashSet;
import java.util.Set;

public class EventBinding<T> {
    private final InstrumentationHandler.AbstractInstrumenter instrumenter;
    private final T element;
    private volatile boolean disposed;

    EventBinding(InstrumentationHandler.AbstractInstrumenter instrumenter, T element) {
        this.instrumenter = instrumenter;
        this.element = element;
    }

    public T getElement() {
        return this.element;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.disposed) {
            this.instrumenter.disposeBinding(this);
            this.disposed = true;
        }
    }

    synchronized void disposeBulk() {
        this.disposed = true;
    }

    static final class Allocation<T>
    extends EventBinding<T> {
        private final AllocationEventFilter filterAllocation;

        Allocation(InstrumentationHandler.AbstractInstrumenter instrumenter, AllocationEventFilter filter, T listener) {
            super(instrumenter, listener);
            this.filterAllocation = filter;
        }

        AllocationEventFilter getAllocationFilter() {
            return this.filterAllocation;
        }
    }

    static final class Source<T>
    extends EventBinding<T> {
        private final InstrumentationHandler.AbstractInstrumenter instrumenter;
        private final SourceSectionFilter filterSourceSection;
        private final SourceSectionFilter inputFilter;
        private final boolean isExecutionEvent;

        Source(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean isExecutionEvent) {
            super(instrumenter, element);
            this.instrumenter = instrumenter;
            this.inputFilter = inputFilter;
            this.filterSourceSection = filterSourceSection;
            this.isExecutionEvent = isExecutionEvent;
        }

        SourceSectionFilter getInputFilter() {
            return this.inputFilter;
        }

        Set<Class<?>> getLimitedTags() {
            Set<Class<?>> tags = this.filterSourceSection.getLimitedTags();
            if (this.inputFilter != null) {
                Set<Class<?>> inputTags = this.inputFilter.getLimitedTags();
                if (tags == null) {
                    return inputTags;
                }
                if (inputTags == null) {
                    return tags;
                }
                if (inputTags.equals(tags)) {
                    return tags;
                }
                HashSet compoundTags = new HashSet();
                compoundTags.addAll(tags);
                compoundTags.addAll(inputTags);
                return compoundTags;
            }
            return tags;
        }

        public SourceSectionFilter getFilter() {
            return this.filterSourceSection;
        }

        boolean isInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node node, SourceSection nodeSourceSection) {
            if (this.isInstrumentedLeaf(providedTags, node, nodeSourceSection)) {
                if (rootNode == null) {
                    return false;
                }
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        boolean isChildInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent, parentSourceSection)) {
                return false;
            }
            if (this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.inputFilter.isInstrumentedNode(providedTags, current, currentSourceSection)) {
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        boolean isChildInstrumentedLeaf(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent, parentSourceSection)) {
                return false;
            }
            return this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.inputFilter.isInstrumentedNode(providedTags, current, currentSourceSection);
        }

        boolean isInstrumentedRoot(Set<Class<?>> providedTags, RootNode rootNode, SourceSection rootSourceSection, int rootNodeBits) {
            return this.getInstrumenter().isInstrumentableRoot(rootNode) && this.getFilter().isInstrumentedRoot(providedTags, rootSourceSection, rootNode, rootNodeBits);
        }

        boolean isInstrumentedLeaf(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection section) {
            return this.getFilter().isInstrumentedNode(providedTags, instrumentedNode, section);
        }

        boolean isInstrumentedSource(com.oracle.truffle.api.source.Source source) {
            return this.getInstrumenter().isInstrumentableSource(source) && this.getFilter().isInstrumentedSource(source);
        }

        boolean isExecutionEvent() {
            return this.isExecutionEvent;
        }

        boolean isLanguageBinding() {
            return this.instrumenter instanceof InstrumentationHandler.LanguageClientInstrumenter;
        }

        InstrumentationHandler.AbstractInstrumenter getInstrumenter() {
            return this.instrumenter;
        }
    }
}

