/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast.visitors;

import com.oracle.truffle.regex.tregex.parser.ast.BackReference;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.MatchFound;
import com.oracle.truffle.regex.tregex.parser.ast.PositionAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.DepthFirstTraversalRegexASTVisitor;

public final class InitIDVisitor
extends DepthFirstTraversalRegexASTVisitor {
    public static final int REGEX_AST_ROOT_PARENT_ID = 0;
    private final RegexASTNode[] index;
    private int nextID;

    private InitIDVisitor(RegexASTNode[] index, int nextID) {
        this.index = index;
        this.nextID = nextID;
    }

    public static void init(RegexAST ast) {
        int initialID = 3 + ast.getWrappedPrefixLength() * 2;
        InitIDVisitor visitor = new InitIDVisitor(new RegexASTNode[initialID + ast.getNumberOfNodes() + 1], initialID);
        assert (ast.getWrappedRoot().getSubTreeParent().getId() == 0);
        visitor.index[0] = ast.getWrappedRoot().getSubTreeParent();
        visitor.run(ast.getWrappedRoot());
        ast.setIndex(visitor.index);
    }

    private void initID(RegexASTNode node) {
        node.setId(this.nextID++);
        this.index[node.getId()] = node;
    }

    @Override
    protected void visit(BackReference backReference) {
        this.initID(backReference);
    }

    @Override
    protected void visit(Group group) {
        this.initID(group);
    }

    @Override
    protected void leave(Group group) {
        MatchFound matchFound;
        if (group.getParent() instanceof RegexASTSubtreeRootNode && !(matchFound = group.getSubTreeParent().getMatchFound()).idInitialized()) {
            this.initID(matchFound);
        }
    }

    @Override
    protected void visit(Sequence sequence) {
        this.initID(sequence);
    }

    @Override
    protected void visit(PositionAssertion assertion) {
        this.initID(assertion);
    }

    @Override
    protected void visit(LookBehindAssertion assertion) {
        this.initID(assertion);
    }

    @Override
    protected void visit(LookAheadAssertion assertion) {
        this.initID(assertion);
    }

    @Override
    protected void visit(CharacterClass characterClass) {
        this.initID(characterClass);
    }

    @Override
    protected void visit(MatchFound matchFound) {
        this.initID(matchFound);
    }
}

