/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.dfa.NFAStateSet;
import com.oracle.truffle.regex.tregex.dfa.PrioritySensitiveNFATransitionSet;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NFATransitionSet
implements TransitionSet,
Iterable<NFAStateTransition> {
    private static final byte FLAG_FORWARD = 1;
    private static final byte FLAG_LEADS_TO_FINAL_STATE = 2;
    private static final byte FLAG_HASH_COMPUTED = 4;
    private final NFA nfa;
    private final NFAStateSet targetStateSet;
    private byte flags = 0;
    private short[] transitions;
    private short size = 0;
    private int cachedHash;

    NFATransitionSet(NFA nfa, boolean forward) {
        this.nfa = nfa;
        this.targetStateSet = new NFAStateSet(nfa);
        if (forward) {
            this.flags = (byte)(this.flags | 1);
        }
        this.transitions = new short[20];
    }

    NFATransitionSet(NFATransitionSet copy, int capacity) {
        this.nfa = copy.nfa;
        this.targetStateSet = copy.targetStateSet.copy();
        this.flags = copy.flags;
        this.transitions = new short[capacity];
        System.arraycopy(copy.transitions, 0, this.transitions, 0, copy.size);
        this.size = copy.size;
        this.cachedHash = copy.cachedHash;
    }

    public static NFATransitionSet create(NFA nfa, boolean forward, NFAStateTransition transition) {
        NFATransitionSet transitionSet = new NFATransitionSet(nfa, forward);
        transitionSet.add(transition);
        return transitionSet;
    }

    @Override
    public NFATransitionSet createMerged(TransitionSet other) {
        NFATransitionSet merged = new NFATransitionSet(this, this.mergedInitialCapacity((NFATransitionSet)other));
        merged.addAll(other);
        return merged;
    }

    int mergedInitialCapacity(NFATransitionSet other) {
        return this.size() + other.size() + 20;
    }

    private boolean isFlagSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    private void setFlag(byte flag) {
        this.flags = (byte)(this.flags | flag);
    }

    private void clearFlag(byte flag) {
        this.flags = (byte)(this.flags & ~flag);
    }

    public boolean isForward() {
        return this.isFlagSet((byte)1);
    }

    public boolean leadsToFinalState() {
        return this.isFlagSet((byte)2);
    }

    private void setLeadsToFinalState() {
        this.setFlag((byte)2);
    }

    boolean isHashComputed() {
        return this.isFlagSet((byte)4);
    }

    void setHashComputed() {
        this.setFlag((byte)4);
    }

    private void clearHashComputed() {
        this.clearFlag((byte)4);
    }

    int getCachedHash() {
        return this.cachedHash;
    }

    void setCachedHash(int cachedHash) {
        this.cachedHash = cachedHash;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    NFAStateTransition getTransition(int i) {
        return this.nfa.getTransitions()[this.transitions[i]];
    }

    public NFAStateSet getTargetStateSet() {
        return this.targetStateSet;
    }

    public void add(NFAStateTransition transition) {
        this.doAdd(transition);
    }

    void doAdd(NFAStateTransition transition) {
        NFAState target = transition.getTarget(this.isForward());
        assert (!target.isFinalState(this.isForward()));
        if (!this.targetStateSet.add(target)) {
            return;
        }
        if (target.hasTransitionToUnAnchoredFinalState(this.isForward())) {
            this.setLeadsToFinalState();
        }
        this.appendTransition(transition);
    }

    void ensureCapacity(int newSize) {
        int newLength;
        if (newSize < this.transitions.length) {
            return;
        }
        for (newLength = this.transitions.length * 2; newLength < newSize; newLength *= 2) {
        }
        this.transitions = Arrays.copyOf(this.transitions, newLength);
    }

    private void appendTransition(NFAStateTransition transition) {
        this.ensureCapacity(this.size + 1);
        assert (this.nfa.getTransitions()[transition.getId()] == transition);
        this.transitions[this.size] = transition.getId();
        this.size = (short)(this.size + 1);
        this.clearHashComputed();
    }

    @Override
    public void addAll(TransitionSet other) {
        NFATransitionSet o = (NFATransitionSet)other;
        this.ensureCapacity(this.size + o.size);
        for (int i = 0; i < o.size; ++i) {
            this.doAdd(o.getTransition(i));
        }
    }

    @Override
    public int hashCode() {
        if (!this.isHashComputed()) {
            this.cachedHash = Objects.hashCode(this.targetStateSet);
            this.setHashComputed();
        }
        return this.cachedHash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NFATransitionSet)) {
            return false;
        }
        assert (!(obj instanceof PrioritySensitiveNFATransitionSet)) : "Do not mix NFATransitionSet and PrioritySensitiveNFATransitionSet!";
        return Objects.equals(this.targetStateSet, ((NFATransitionSet)obj).targetStateSet);
    }

    @Override
    public Iterator<NFAStateTransition> iterator() {
        return new NFATransitionSetIterator(this.nfa, this.transitions, this.size);
    }

    @CompilerDirectives.TruffleBoundary
    public Stream<NFAStateTransition> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.stream().map(x -> x.getTarget(this.isForward()).idToString()).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.array(this);
    }

    private static final class NFATransitionSetIterator
    implements Iterator<NFAStateTransition> {
        private final NFA nfa;
        private final short[] transitions;
        private final short size;
        private short i = 0;

        private NFATransitionSetIterator(NFA nfa, short[] transitions, short size) {
            this.nfa = nfa;
            this.transitions = transitions;
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public NFAStateTransition next() {
            short s = this.i;
            this.i = (short)(s + 1);
            return this.nfa.getTransitions()[this.transitions[s]];
        }
    }
}

