/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.regex.tregex.automaton.StateTransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.NFATransitionSet;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import java.util.Iterator;

public class DFATransitionCanonicalizer
extends StateTransitionCanonicalizer<NFATransitionSet, DFAStateTransitionBuilder> {
    private final boolean genericCG;

    public DFATransitionCanonicalizer(boolean genericCG) {
        this.genericCG = genericCG;
    }

    @Override
    protected boolean isSameTargetMergeAllowed(DFAStateTransitionBuilder a, DFAStateTransitionBuilder b) {
        if (!this.genericCG) {
            return true;
        }
        assert (((NFATransitionSet)a.getTransitionSet()).isForward() && ((NFATransitionSet)b.getTransitionSet()).isForward());
        assert (((NFATransitionSet)a.getTransitionSet()).equals(b.getTransitionSet()));
        Iterator<NFAStateTransition> ia = ((NFATransitionSet)a.getTransitionSet()).iterator();
        Iterator<NFAStateTransition> ib = ((NFATransitionSet)b.getTransitionSet()).iterator();
        while (ia.hasNext()) {
            NFAStateTransition lastA = ia.next();
            NFAStateTransition lastB = ib.next();
            assert (lastA.getTarget().equals(lastB.getTarget()));
            if (lastA.getSource().equals(lastB.getSource()) && lastA.getGroupBoundaries().equals(lastB.getGroupBoundaries())) continue;
            return false;
        }
        return true;
    }

    protected DFAStateTransitionBuilder[] createResultArray(int size) {
        return new DFAStateTransitionBuilder[size];
    }
}

