/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cpplite.debugger.DebuggerAnnotation;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.xml.sax.InputSource;

public class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    private static Object currentLine;

    static synchronized void markCurrent(Object line) {
        Utils.unmarkCurrent();
        Annotatable[] annotatables = (Annotatable[])line;
        int i = 0;
        int k = annotatables.length;
        DebuggerAnnotation[] annotations = new DebuggerAnnotation[k];
        annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPCLinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC", annotatables[i]);
        for (i = 1; i < k; ++i) {
            annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPC2LinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC2", annotatables[i]);
        }
        currentLine = annotations;
        Utils.showLine(line);
    }

    static synchronized void unmarkCurrent() {
        if (currentLine != null) {
            int k = ((DebuggerAnnotation[])currentLine).length;
            for (int i = 0; i < k; ++i) {
                ((DebuggerAnnotation[])currentLine)[i].detach();
            }
            currentLine = null;
        }
    }

    static void showLine(Object line) {
        final Annotatable[] a = (Annotatable[])line;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (a[0] instanceof Line) {
                    ((Line)a[0]).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else if (a[0] instanceof Line.Part) {
                    ((Line.Part)a[0]).getLine().show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else {
                    throw new InternalError();
                }
            }
        });
    }

    static int getLineNumber(Object line) {
        Annotatable[] a = (Annotatable[])line;
        if (a[0] instanceof Line) {
            return ((Line)a[0]).getLineNumber();
        }
        if (a[0] instanceof Line.Part) {
            return ((Line.Part)a[0]).getLine().getLineNumber();
        }
        throw new InternalError();
    }

    public static boolean contains(Object currentLine, Line line) {
        if (currentLine == null) {
            return false;
        }
        Annotatable[] a = (Annotatable[])currentLine;
        int k = a.length;
        for (int i = 0; i < k; ++i) {
            if (a[i].equals(line)) {
                return true;
            }
            if (!(a[i] instanceof Line.Part) || !((Line.Part)a[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }

    private static int findIndexOf(String text, String target) {
        int index = 0;
        while ((index = text.indexOf(target, index)) > 0) {
            char c = text.charAt(index - 1);
            if (!Character.isWhitespace(c) && c != ',' && c != '\"') {
                ++index;
                continue;
            }
            if (text.length() <= index + target.length() || Character.isWhitespace(c = text.charAt(index + target.length())) || c == ',' || c == '\"') break;
            ++index;
        }
        return index;
    }

    private static InputSource createInputSource(FileObject fo, EditorCookie editor, final StyledDocument document) throws IOException, BadLocationException {
        final StringWriter w = new StringWriter(document.getLength());
        final EditorKit kit = Utils.findKit(editor);
        if (kit == null) {
            return null;
        }
        final IOException[] ioe = new IOException[1];
        final BadLocationException[] ble = new BadLocationException[1];
        document.render(new Runnable(){

            @Override
            public void run() {
                try {
                    kit.write(w, (Document)document, 0, document.getLength());
                }
                catch (IOException e) {
                    ioe[0] = e;
                }
                catch (BadLocationException e) {
                    ble[0] = e;
                }
            }
        });
        if (ioe[0] != null) {
            throw ioe[0];
        }
        if (ble[0] != null) {
            throw ble[0];
        }
        InputSource in = new InputSource(new StringReader(w.toString()));
        if (fo != null) {
            in.setSystemId(fo.toURL().toExternalForm());
        }
        return in;
    }

    private static EditorKit findKit(final EditorCookie editor) {
        if (SwingUtilities.isEventDispatchThread()) {
            return Utils.findKit_(editor);
        }
        final EditorKit[] ek = new EditorKit[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ek[0] = Utils.findKit_(editor);
                }
            });
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(ex.getTargetException());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return ek[0];
    }

    private static EditorKit findKit_(EditorCookie editor) {
        EditorKit kit;
        JEditorPane[] panes = editor.getOpenedPanes();
        if (panes != null) {
            kit = panes[0].getEditorKit();
        } else {
            kit = JEditorPane.createEditorKitForContentType("text/xml");
            if (kit == null) {
                kit = new DefaultEditorKit();
            }
        }
        assert (kit != null);
        return kit;
    }
}

