/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.nashorn.regexp.joni;

import com.oracle.truffle.regex.nashorn.regexp.joni.Analyser;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.AnchorNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.BackRefNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.CClassNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.ConsAltNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.EncloseNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.Node;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.QuantifierNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.ast.StringNode;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.ErrorMessages;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.InternalException;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.SyntaxException;

public abstract class Compiler
implements ErrorMessages {
    protected final Analyser analyser;
    protected final Regex regex;

    protected Compiler(Analyser analyser) {
        this.analyser = analyser;
        this.regex = analyser.regex;
    }

    public final void compile() {
        this.prepare();
        this.compileTree(this.analyser.root);
        this.finish();
    }

    protected abstract void prepare();

    protected abstract void finish();

    protected abstract void compileAltNode(ConsAltNode var1);

    protected void compileStringRawNode(StringNode sn) {
        if (sn.length() <= 0) {
            return;
        }
        this.addCompileString(sn.chars, sn.p, sn.length(), false);
    }

    protected void compileStringNode(StringNode node) {
        int prev;
        StringNode sn = node;
        if (sn.length() <= 0) {
            return;
        }
        boolean ambig = sn.isAmbig();
        int p = prev = sn.p;
        int end = sn.end;
        char[] chars = sn.chars;
        ++p;
        int slen = 1;
        while (p < end) {
            ++slen;
            ++p;
        }
        this.addCompileString(chars, prev, slen, ambig);
    }

    protected abstract void addCompileString(char[] var1, int var2, int var3, boolean var4);

    protected abstract void compileCClassNode(CClassNode var1);

    protected abstract void compileAnyCharNode();

    protected abstract void compileBackrefNode(BackRefNode var1);

    protected abstract void compileNonCECQuantifierNode(QuantifierNode var1);

    protected abstract void compileOptionNode(EncloseNode var1);

    protected abstract void compileEncloseNode(EncloseNode var1);

    protected abstract void compileAnchorNode(AnchorNode var1);

    protected void compileTree(Node node) {
        switch (node.getType()) {
            case 8: {
                ConsAltNode lin = (ConsAltNode)node;
                do {
                    this.compileTree(lin.car);
                } while ((lin = lin.cdr) != null);
                break;
            }
            case 9: {
                this.compileAltNode((ConsAltNode)node);
                break;
            }
            case 0: {
                StringNode sn = (StringNode)node;
                if (sn.isRaw()) {
                    this.compileStringRawNode(sn);
                    break;
                }
                this.compileStringNode(sn);
                break;
            }
            case 1: {
                this.compileCClassNode((CClassNode)node);
                break;
            }
            case 3: {
                this.compileAnyCharNode();
                break;
            }
            case 4: {
                this.compileBackrefNode((BackRefNode)node);
                break;
            }
            case 5: {
                this.compileNonCECQuantifierNode((QuantifierNode)node);
                break;
            }
            case 6: {
                EncloseNode enode = (EncloseNode)node;
                if (enode.isOption()) {
                    this.compileOptionNode(enode);
                    break;
                }
                this.compileEncloseNode(enode);
                break;
            }
            case 7: {
                this.compileAnchorNode((AnchorNode)node);
                break;
            }
            default: {
                this.newInternalException("internal parser error (bug)");
            }
        }
    }

    protected final void compileTreeNTimes(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            this.compileTree(node);
        }
    }

    protected void newSyntaxException(String message) {
        throw new SyntaxException(message);
    }

    protected void newInternalException(String message) {
        throw new InternalException(message);
    }

    protected Range findEnclosedCaptureGroups(Node node) {
        switch (node.getType()) {
            case 8: 
            case 9: {
                ConsAltNode lin = (ConsAltNode)node;
                Range ret = this.findEnclosedCaptureGroups(lin.car);
                while ((lin = lin.cdr) != null) {
                    ret = ret.union(this.findEnclosedCaptureGroups(lin.car));
                }
                return ret;
            }
            case 5: {
                QuantifierNode quantifierNode = (QuantifierNode)node;
                return this.findEnclosedCaptureGroups(quantifierNode.target);
            }
            case 6: {
                EncloseNode encloseNode = (EncloseNode)node;
                Range inner = this.findEnclosedCaptureGroups(encloseNode.target);
                if (encloseNode.type == 1) {
                    return new Range(encloseNode.regNum).union(inner);
                }
                return inner;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 7: {
                return Range.EMPTY;
            }
        }
        throw new InternalException("internal parser error (bug)");
    }

    protected static class Range {
        public boolean empty;
        public int from;
        public int to;
        public static final Range EMPTY = new Range();

        public Range() {
            this.empty = true;
        }

        public Range(int singleton) {
            this.empty = false;
            this.from = singleton;
            this.to = singleton + 1;
        }

        public Range(int from, int to) {
            this.empty = false;
            this.from = from;
            this.to = to;
        }

        public Range union(Range other) {
            if (this.empty) {
                return other;
            }
            if (other.empty) {
                return this;
            }
            return new Range(Math.min(this.from, other.from), Math.max(this.to, other.to));
        }
    }
}

